/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.BatchGetRequestMapCopier;
import software.amazon.awssdk.services.dynamodb.model.BatchGetResponseMapCopier;
import software.amazon.awssdk.services.dynamodb.model.ConsumedCapacity;
import software.amazon.awssdk.services.dynamodb.model.ConsumedCapacityMultipleCopier;
import software.amazon.awssdk.services.dynamodb.model.DynamoDBResponse;
import software.amazon.awssdk.services.dynamodb.model.KeysAndAttributes;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BatchGetItemResponse
extends DynamoDBResponse
implements ToCopyableBuilder<Builder, BatchGetItemResponse> {
    private final Map<String, List<Map<String, AttributeValue>>> responses;
    private final Map<String, KeysAndAttributes> unprocessedKeys;
    private final List<ConsumedCapacity> consumedCapacity;

    private BatchGetItemResponse(BuilderImpl builder) {
        super(builder);
        this.responses = builder.responses;
        this.unprocessedKeys = builder.unprocessedKeys;
        this.consumedCapacity = builder.consumedCapacity;
    }

    public Map<String, List<Map<String, AttributeValue>>> responses() {
        return this.responses;
    }

    public Map<String, KeysAndAttributes> unprocessedKeys() {
        return this.unprocessedKeys;
    }

    public List<ConsumedCapacity> consumedCapacity() {
        return this.consumedCapacity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.responses());
        hashCode = 31 * hashCode + Objects.hashCode(this.unprocessedKeys());
        hashCode = 31 * hashCode + Objects.hashCode(this.consumedCapacity());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetItemResponse)) {
            return false;
        }
        BatchGetItemResponse other = (BatchGetItemResponse)((Object)obj);
        return Objects.equals(this.responses(), other.responses()) && Objects.equals(this.unprocessedKeys(), other.unprocessedKeys()) && Objects.equals(this.consumedCapacity(), other.consumedCapacity());
    }

    public String toString() {
        return ToString.builder((String)"BatchGetItemResponse").add("Responses", this.responses()).add("UnprocessedKeys", this.unprocessedKeys()).add("ConsumedCapacity", this.consumedCapacity()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Responses": {
                return Optional.of(clazz.cast(this.responses()));
            }
            case "UnprocessedKeys": {
                return Optional.of(clazz.cast(this.unprocessedKeys()));
            }
            case "ConsumedCapacity": {
                return Optional.of(clazz.cast(this.consumedCapacity()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DynamoDBResponse.BuilderImpl
    implements Builder {
        private Map<String, List<Map<String, AttributeValue>>> responses;
        private Map<String, KeysAndAttributes> unprocessedKeys;
        private List<ConsumedCapacity> consumedCapacity;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetItemResponse model) {
            super(model);
            this.responses(model.responses);
            this.unprocessedKeys(model.unprocessedKeys);
            this.consumedCapacity(model.consumedCapacity);
        }

        public final Map<String, ? extends Collection<Map<String, AttributeValue>>> getResponses() {
            return this.responses;
        }

        @Override
        public final Builder responses(Map<String, ? extends Collection<Map<String, AttributeValue>>> responses) {
            this.responses = BatchGetResponseMapCopier.copy(responses);
            return this;
        }

        public final void setResponses(Map<String, ? extends Collection<Map<String, AttributeValue>>> responses) {
            this.responses = BatchGetResponseMapCopier.copy(responses);
        }

        public final Map<String, KeysAndAttributes.Builder> getUnprocessedKeys() {
            return this.unprocessedKeys != null ? CollectionUtils.mapValues(this.unprocessedKeys, KeysAndAttributes::toBuilder) : null;
        }

        @Override
        public final Builder unprocessedKeys(Map<String, KeysAndAttributes> unprocessedKeys) {
            this.unprocessedKeys = BatchGetRequestMapCopier.copy(unprocessedKeys);
            return this;
        }

        public final void setUnprocessedKeys(Map<String, KeysAndAttributes.BuilderImpl> unprocessedKeys) {
            this.unprocessedKeys = BatchGetRequestMapCopier.copyFromBuilder(unprocessedKeys);
        }

        public final Collection<ConsumedCapacity.Builder> getConsumedCapacity() {
            return this.consumedCapacity != null ? (Collection)this.consumedCapacity.stream().map(ConsumedCapacity::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder consumedCapacity(Collection<ConsumedCapacity> consumedCapacity) {
            this.consumedCapacity = ConsumedCapacityMultipleCopier.copy(consumedCapacity);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder consumedCapacity(ConsumedCapacity ... consumedCapacity) {
            this.consumedCapacity(Arrays.asList(consumedCapacity));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder consumedCapacity(Consumer<ConsumedCapacity.Builder> ... consumedCapacity) {
            this.consumedCapacity(Stream.of(consumedCapacity).map(c -> (ConsumedCapacity)((ConsumedCapacity.Builder)ConsumedCapacity.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setConsumedCapacity(Collection<ConsumedCapacity.BuilderImpl> consumedCapacity) {
            this.consumedCapacity = ConsumedCapacityMultipleCopier.copyFromBuilder(consumedCapacity);
        }

        @Override
        public BatchGetItemResponse build() {
            return new BatchGetItemResponse(this);
        }
    }

    public static interface Builder
    extends DynamoDBResponse.Builder,
    CopyableBuilder<Builder, BatchGetItemResponse> {
        public Builder responses(Map<String, ? extends Collection<Map<String, AttributeValue>>> var1);

        public Builder unprocessedKeys(Map<String, KeysAndAttributes> var1);

        public Builder consumedCapacity(Collection<ConsumedCapacity> var1);

        public Builder consumedCapacity(ConsumedCapacity ... var1);

        public Builder consumedCapacity(Consumer<ConsumedCapacity.Builder> ... var1);
    }
}

