/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.dynamodb.model.StreamDescription;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class StreamDescriptionMarshaller {
    private static final MarshallingInfo<String> STREAMARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StreamArn").isBinary(false).build();
    private static final MarshallingInfo<String> STREAMLABEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StreamLabel").isBinary(false).build();
    private static final MarshallingInfo<String> STREAMSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StreamStatus").isBinary(false).build();
    private static final MarshallingInfo<String> STREAMVIEWTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StreamViewType").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATIONREQUESTDATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationRequestDateTime").isBinary(false).build();
    private static final MarshallingInfo<String> TABLENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TableName").isBinary(false).build();
    private static final MarshallingInfo<List> KEYSCHEMA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KeySchema").isBinary(false).build();
    private static final MarshallingInfo<List> SHARDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Shards").isBinary(false).build();
    private static final MarshallingInfo<String> LASTEVALUATEDSHARDID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastEvaluatedShardId").isBinary(false).build();
    private static final StreamDescriptionMarshaller INSTANCE = new StreamDescriptionMarshaller();

    private StreamDescriptionMarshaller() {
    }

    public static StreamDescriptionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(StreamDescription streamDescription, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)streamDescription, (String)"streamDescription");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)streamDescription.streamArn(), STREAMARN_BINDING);
            protocolMarshaller.marshall((Object)streamDescription.streamLabel(), STREAMLABEL_BINDING);
            protocolMarshaller.marshall((Object)streamDescription.streamStatusAsString(), STREAMSTATUS_BINDING);
            protocolMarshaller.marshall((Object)streamDescription.streamViewTypeAsString(), STREAMVIEWTYPE_BINDING);
            protocolMarshaller.marshall((Object)streamDescription.creationRequestDateTime(), CREATIONREQUESTDATETIME_BINDING);
            protocolMarshaller.marshall((Object)streamDescription.tableName(), TABLENAME_BINDING);
            protocolMarshaller.marshall(streamDescription.keySchema(), KEYSCHEMA_BINDING);
            protocolMarshaller.marshall(streamDescription.shards(), SHARDS_BINDING);
            protocolMarshaller.marshall((Object)streamDescription.lastEvaluatedShardId(), LASTEVALUATEDSHARDID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

