/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.dynamodb.model.UpdateItemRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class UpdateItemRequestModelMarshaller {
    private static final MarshallingInfo<String> TABLENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TableName").isBinary(false).build();
    private static final MarshallingInfo<Map> KEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Key").isBinary(false).build();
    private static final MarshallingInfo<Map> ATTRIBUTEUPDATES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AttributeUpdates").isBinary(false).build();
    private static final MarshallingInfo<Map> EXPECTED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Expected").isBinary(false).build();
    private static final MarshallingInfo<String> CONDITIONALOPERATOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConditionalOperator").isBinary(false).build();
    private static final MarshallingInfo<String> RETURNVALUES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReturnValues").isBinary(false).build();
    private static final MarshallingInfo<String> RETURNCONSUMEDCAPACITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReturnConsumedCapacity").isBinary(false).build();
    private static final MarshallingInfo<String> RETURNITEMCOLLECTIONMETRICS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReturnItemCollectionMetrics").isBinary(false).build();
    private static final MarshallingInfo<String> UPDATEEXPRESSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UpdateExpression").isBinary(false).build();
    private static final MarshallingInfo<String> CONDITIONEXPRESSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConditionExpression").isBinary(false).build();
    private static final MarshallingInfo<Map> EXPRESSIONATTRIBUTENAMES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExpressionAttributeNames").isBinary(false).build();
    private static final MarshallingInfo<Map> EXPRESSIONATTRIBUTEVALUES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExpressionAttributeValues").isBinary(false).build();
    private static final UpdateItemRequestModelMarshaller INSTANCE = new UpdateItemRequestModelMarshaller();

    private UpdateItemRequestModelMarshaller() {
    }

    public static UpdateItemRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(UpdateItemRequest updateItemRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)updateItemRequest), (String)"updateItemRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)updateItemRequest.tableName(), TABLENAME_BINDING);
            protocolMarshaller.marshall(updateItemRequest.key(), KEY_BINDING);
            protocolMarshaller.marshall(updateItemRequest.attributeUpdates(), ATTRIBUTEUPDATES_BINDING);
            protocolMarshaller.marshall(updateItemRequest.expected(), EXPECTED_BINDING);
            protocolMarshaller.marshall((Object)updateItemRequest.conditionalOperatorAsString(), CONDITIONALOPERATOR_BINDING);
            protocolMarshaller.marshall((Object)updateItemRequest.returnValuesAsString(), RETURNVALUES_BINDING);
            protocolMarshaller.marshall((Object)updateItemRequest.returnConsumedCapacityAsString(), RETURNCONSUMEDCAPACITY_BINDING);
            protocolMarshaller.marshall((Object)updateItemRequest.returnItemCollectionMetricsAsString(), RETURNITEMCOLLECTIONMETRICS_BINDING);
            protocolMarshaller.marshall((Object)updateItemRequest.updateExpression(), UPDATEEXPRESSION_BINDING);
            protocolMarshaller.marshall((Object)updateItemRequest.conditionExpression(), CONDITIONEXPRESSION_BINDING);
            protocolMarshaller.marshall(updateItemRequest.expressionAttributeNames(), EXPRESSIONATTRIBUTENAMES_BINDING);
            protocolMarshaller.marshall(updateItemRequest.expressionAttributeValues(), EXPRESSIONATTRIBUTEVALUES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

