/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodbstreams;

import java.util.function.Consumer;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.dynamodb.model.DescribeStreamRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeStreamResponse;
import software.amazon.awssdk.services.dynamodb.model.DynamoDBException;
import software.amazon.awssdk.services.dynamodb.model.ExpiredIteratorException;
import software.amazon.awssdk.services.dynamodb.model.GetRecordsRequest;
import software.amazon.awssdk.services.dynamodb.model.GetRecordsResponse;
import software.amazon.awssdk.services.dynamodb.model.GetShardIteratorRequest;
import software.amazon.awssdk.services.dynamodb.model.GetShardIteratorResponse;
import software.amazon.awssdk.services.dynamodb.model.InternalServerErrorException;
import software.amazon.awssdk.services.dynamodb.model.LimitExceededException;
import software.amazon.awssdk.services.dynamodb.model.ListStreamsRequest;
import software.amazon.awssdk.services.dynamodb.model.ListStreamsResponse;
import software.amazon.awssdk.services.dynamodb.model.ResourceNotFoundException;
import software.amazon.awssdk.services.dynamodb.model.TrimmedDataAccessException;
import software.amazon.awssdk.services.dynamodbstreams.DefaultDynamoDBStreamsClientBuilder;
import software.amazon.awssdk.services.dynamodbstreams.DynamoDBStreamsClientBuilder;
import software.amazon.awssdk.services.dynamodbstreams.paginators.DescribeStreamIterable;
import software.amazon.awssdk.services.dynamodbstreams.paginators.ListStreamsIterable;
import software.amazon.awssdk.utils.SdkAutoCloseable;

public interface DynamoDBStreamsClient
extends SdkClient,
SdkAutoCloseable {
    public static final String SERVICE_NAME = "dynamodb";

    public static DynamoDBStreamsClient create() {
        return (DynamoDBStreamsClient)DynamoDBStreamsClient.builder().build();
    }

    public static DynamoDBStreamsClientBuilder builder() {
        return new DefaultDynamoDBStreamsClientBuilder();
    }

    default public DescribeStreamResponse describeStream(DescribeStreamRequest describeStreamRequest) throws ResourceNotFoundException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDBException {
        throw new UnsupportedOperationException();
    }

    default public DescribeStreamResponse describeStream(Consumer<DescribeStreamRequest.Builder> describeStreamRequest) throws ResourceNotFoundException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDBException {
        return this.describeStream((DescribeStreamRequest)((Object)((DescribeStreamRequest.Builder)DescribeStreamRequest.builder().apply(describeStreamRequest)).build()));
    }

    default public DescribeStreamIterable describeStreamPaginator(DescribeStreamRequest describeStreamRequest) throws ResourceNotFoundException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDBException {
        throw new UnsupportedOperationException();
    }

    default public DescribeStreamIterable describeStreamPaginator(Consumer<DescribeStreamRequest.Builder> describeStreamRequest) throws ResourceNotFoundException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDBException {
        return this.describeStreamPaginator((DescribeStreamRequest)((Object)((DescribeStreamRequest.Builder)DescribeStreamRequest.builder().apply(describeStreamRequest)).build()));
    }

    default public GetRecordsResponse getRecords(GetRecordsRequest getRecordsRequest) throws ResourceNotFoundException, LimitExceededException, InternalServerErrorException, ExpiredIteratorException, TrimmedDataAccessException, AwsServiceException, SdkClientException, DynamoDBException {
        throw new UnsupportedOperationException();
    }

    default public GetRecordsResponse getRecords(Consumer<GetRecordsRequest.Builder> getRecordsRequest) throws ResourceNotFoundException, LimitExceededException, InternalServerErrorException, ExpiredIteratorException, TrimmedDataAccessException, AwsServiceException, SdkClientException, DynamoDBException {
        return this.getRecords((GetRecordsRequest)((Object)((GetRecordsRequest.Builder)GetRecordsRequest.builder().apply(getRecordsRequest)).build()));
    }

    default public GetShardIteratorResponse getShardIterator(GetShardIteratorRequest getShardIteratorRequest) throws ResourceNotFoundException, InternalServerErrorException, TrimmedDataAccessException, AwsServiceException, SdkClientException, DynamoDBException {
        throw new UnsupportedOperationException();
    }

    default public GetShardIteratorResponse getShardIterator(Consumer<GetShardIteratorRequest.Builder> getShardIteratorRequest) throws ResourceNotFoundException, InternalServerErrorException, TrimmedDataAccessException, AwsServiceException, SdkClientException, DynamoDBException {
        return this.getShardIterator((GetShardIteratorRequest)((Object)((GetShardIteratorRequest.Builder)GetShardIteratorRequest.builder().apply(getShardIteratorRequest)).build()));
    }

    default public ListStreamsResponse listStreams() throws ResourceNotFoundException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDBException {
        return this.listStreams((ListStreamsRequest)((Object)ListStreamsRequest.builder().build()));
    }

    default public ListStreamsResponse listStreams(ListStreamsRequest listStreamsRequest) throws ResourceNotFoundException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDBException {
        throw new UnsupportedOperationException();
    }

    default public ListStreamsResponse listStreams(Consumer<ListStreamsRequest.Builder> listStreamsRequest) throws ResourceNotFoundException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDBException {
        return this.listStreams((ListStreamsRequest)((Object)((ListStreamsRequest.Builder)ListStreamsRequest.builder().apply(listStreamsRequest)).build()));
    }

    default public ListStreamsIterable listStreamsPaginator(ListStreamsRequest listStreamsRequest) throws ResourceNotFoundException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDBException {
        throw new UnsupportedOperationException();
    }

    default public ListStreamsIterable listStreamsPaginator() throws ResourceNotFoundException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDBException {
        return this.listStreamsPaginator((ListStreamsRequest)((Object)ListStreamsRequest.builder().build()));
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)"streams.dynamodb");
    }
}

