/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.transform.GlobalTableGlobalSecondaryIndexSettingsUpdateMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the settings of a global secondary index for a global table that will be modified.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GlobalTableGlobalSecondaryIndexSettingsUpdate implements StructuredPojo,
        ToCopyableBuilder<GlobalTableGlobalSecondaryIndexSettingsUpdate.Builder, GlobalTableGlobalSecondaryIndexSettingsUpdate> {
    private final String indexName;

    private final Long provisionedWriteCapacityUnits;

    private GlobalTableGlobalSecondaryIndexSettingsUpdate(BuilderImpl builder) {
        this.indexName = builder.indexName;
        this.provisionedWriteCapacityUnits = builder.provisionedWriteCapacityUnits;
    }

    /**
     * <p>
     * The name of the global secondary index. The name must be unique among all other indexes on this table.
     * </p>
     * 
     * @return The name of the global secondary index. The name must be unique among all other indexes on this table.
     */
    public String indexName() {
        return indexName;
    }

    /**
     * <p>
     * The maximum number of writes consumed per second before DynamoDB returns a <code>ThrottlingException.</code>
     * </p>
     * 
     * @return The maximum number of writes consumed per second before DynamoDB returns a
     *         <code>ThrottlingException.</code>
     */
    public Long provisionedWriteCapacityUnits() {
        return provisionedWriteCapacityUnits;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(indexName());
        hashCode = 31 * hashCode + Objects.hashCode(provisionedWriteCapacityUnits());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GlobalTableGlobalSecondaryIndexSettingsUpdate)) {
            return false;
        }
        GlobalTableGlobalSecondaryIndexSettingsUpdate other = (GlobalTableGlobalSecondaryIndexSettingsUpdate) obj;
        return Objects.equals(indexName(), other.indexName())
                && Objects.equals(provisionedWriteCapacityUnits(), other.provisionedWriteCapacityUnits());
    }

    @Override
    public String toString() {
        return ToString.builder("GlobalTableGlobalSecondaryIndexSettingsUpdate").add("IndexName", indexName())
                .add("ProvisionedWriteCapacityUnits", provisionedWriteCapacityUnits()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IndexName":
            return Optional.ofNullable(clazz.cast(indexName()));
        case "ProvisionedWriteCapacityUnits":
            return Optional.ofNullable(clazz.cast(provisionedWriteCapacityUnits()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        GlobalTableGlobalSecondaryIndexSettingsUpdateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, GlobalTableGlobalSecondaryIndexSettingsUpdate> {
        /**
         * <p>
         * The name of the global secondary index. The name must be unique among all other indexes on this table.
         * </p>
         * 
         * @param indexName
         *        The name of the global secondary index. The name must be unique among all other indexes on this table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexName(String indexName);

        /**
         * <p>
         * The maximum number of writes consumed per second before DynamoDB returns a <code>ThrottlingException.</code>
         * </p>
         * 
         * @param provisionedWriteCapacityUnits
         *        The maximum number of writes consumed per second before DynamoDB returns a
         *        <code>ThrottlingException.</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedWriteCapacityUnits(Long provisionedWriteCapacityUnits);
    }

    static final class BuilderImpl implements Builder {
        private String indexName;

        private Long provisionedWriteCapacityUnits;

        private BuilderImpl() {
        }

        private BuilderImpl(GlobalTableGlobalSecondaryIndexSettingsUpdate model) {
            indexName(model.indexName);
            provisionedWriteCapacityUnits(model.provisionedWriteCapacityUnits);
        }

        public final String getIndexName() {
            return indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        public final Long getProvisionedWriteCapacityUnits() {
            return provisionedWriteCapacityUnits;
        }

        @Override
        public final Builder provisionedWriteCapacityUnits(Long provisionedWriteCapacityUnits) {
            this.provisionedWriteCapacityUnits = provisionedWriteCapacityUnits;
            return this;
        }

        public final void setProvisionedWriteCapacityUnits(Long provisionedWriteCapacityUnits) {
            this.provisionedWriteCapacityUnits = provisionedWriteCapacityUnits;
        }

        @Override
        public GlobalTableGlobalSecondaryIndexSettingsUpdate build() {
            return new GlobalTableGlobalSecondaryIndexSettingsUpdate(this);
        }
    }
}
