/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.transform.ReplicaGlobalSecondaryIndexSettingsDescriptionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the properties of a global secondary index.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReplicaGlobalSecondaryIndexSettingsDescription implements StructuredPojo,
        ToCopyableBuilder<ReplicaGlobalSecondaryIndexSettingsDescription.Builder, ReplicaGlobalSecondaryIndexSettingsDescription> {
    private final String indexName;

    private final String indexStatus;

    private final Long provisionedReadCapacityUnits;

    private final Long provisionedWriteCapacityUnits;

    private ReplicaGlobalSecondaryIndexSettingsDescription(BuilderImpl builder) {
        this.indexName = builder.indexName;
        this.indexStatus = builder.indexStatus;
        this.provisionedReadCapacityUnits = builder.provisionedReadCapacityUnits;
        this.provisionedWriteCapacityUnits = builder.provisionedWriteCapacityUnits;
    }

    /**
     * <p>
     * The name of the global secondary index. The name must be unique among all other indexes on this table.
     * </p>
     * 
     * @return The name of the global secondary index. The name must be unique among all other indexes on this table.
     */
    public String indexName() {
        return indexName;
    }

    /**
     * <p>
     * The current status of the global secondary index:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATING</code> - The global secondary index is being created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATING</code> - The global secondary index is being updated.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETING</code> - The global secondary index is being deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVE</code> - The global secondary index is ready for use.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #indexStatus} will
     * return {@link IndexStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #indexStatusAsString}.
     * </p>
     * 
     * @return The current status of the global secondary index:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATING</code> - The global secondary index is being created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATING</code> - The global secondary index is being updated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETING</code> - The global secondary index is being deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code> - The global secondary index is ready for use.
     *         </p>
     *         </li>
     * @see IndexStatus
     */
    public IndexStatus indexStatus() {
        return IndexStatus.fromValue(indexStatus);
    }

    /**
     * <p>
     * The current status of the global secondary index:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATING</code> - The global secondary index is being created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATING</code> - The global secondary index is being updated.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETING</code> - The global secondary index is being deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVE</code> - The global secondary index is ready for use.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #indexStatus} will
     * return {@link IndexStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #indexStatusAsString}.
     * </p>
     * 
     * @return The current status of the global secondary index:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATING</code> - The global secondary index is being created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATING</code> - The global secondary index is being updated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETING</code> - The global secondary index is being deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code> - The global secondary index is ready for use.
     *         </p>
     *         </li>
     * @see IndexStatus
     */
    public String indexStatusAsString() {
        return indexStatus;
    }

    /**
     * <p>
     * The maximum number of strongly consistent reads consumed per second before DynamoDB returns a
     * <code>ThrottlingException</code>.
     * </p>
     * 
     * @return The maximum number of strongly consistent reads consumed per second before DynamoDB returns a
     *         <code>ThrottlingException</code>.
     */
    public Long provisionedReadCapacityUnits() {
        return provisionedReadCapacityUnits;
    }

    /**
     * <p>
     * The maximum number of writes consumed per second before DynamoDB returns a <code>ThrottlingException</code>.
     * </p>
     * 
     * @return The maximum number of writes consumed per second before DynamoDB returns a
     *         <code>ThrottlingException</code>.
     */
    public Long provisionedWriteCapacityUnits() {
        return provisionedWriteCapacityUnits;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(indexName());
        hashCode = 31 * hashCode + Objects.hashCode(indexStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(provisionedReadCapacityUnits());
        hashCode = 31 * hashCode + Objects.hashCode(provisionedWriteCapacityUnits());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicaGlobalSecondaryIndexSettingsDescription)) {
            return false;
        }
        ReplicaGlobalSecondaryIndexSettingsDescription other = (ReplicaGlobalSecondaryIndexSettingsDescription) obj;
        return Objects.equals(indexName(), other.indexName())
                && Objects.equals(indexStatusAsString(), other.indexStatusAsString())
                && Objects.equals(provisionedReadCapacityUnits(), other.provisionedReadCapacityUnits())
                && Objects.equals(provisionedWriteCapacityUnits(), other.provisionedWriteCapacityUnits());
    }

    @Override
    public String toString() {
        return ToString.builder("ReplicaGlobalSecondaryIndexSettingsDescription").add("IndexName", indexName())
                .add("IndexStatus", indexStatusAsString()).add("ProvisionedReadCapacityUnits", provisionedReadCapacityUnits())
                .add("ProvisionedWriteCapacityUnits", provisionedWriteCapacityUnits()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IndexName":
            return Optional.ofNullable(clazz.cast(indexName()));
        case "IndexStatus":
            return Optional.ofNullable(clazz.cast(indexStatusAsString()));
        case "ProvisionedReadCapacityUnits":
            return Optional.ofNullable(clazz.cast(provisionedReadCapacityUnits()));
        case "ProvisionedWriteCapacityUnits":
            return Optional.ofNullable(clazz.cast(provisionedWriteCapacityUnits()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ReplicaGlobalSecondaryIndexSettingsDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ReplicaGlobalSecondaryIndexSettingsDescription> {
        /**
         * <p>
         * The name of the global secondary index. The name must be unique among all other indexes on this table.
         * </p>
         * 
         * @param indexName
         *        The name of the global secondary index. The name must be unique among all other indexes on this table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexName(String indexName);

        /**
         * <p>
         * The current status of the global secondary index:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATING</code> - The global secondary index is being created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATING</code> - The global secondary index is being updated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETING</code> - The global secondary index is being deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVE</code> - The global secondary index is ready for use.
         * </p>
         * </li>
         * </ul>
         * 
         * @param indexStatus
         *        The current status of the global secondary index:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATING</code> - The global secondary index is being created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATING</code> - The global secondary index is being updated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETING</code> - The global secondary index is being deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code> - The global secondary index is ready for use.
         *        </p>
         *        </li>
         * @see IndexStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IndexStatus
         */
        Builder indexStatus(String indexStatus);

        /**
         * <p>
         * The current status of the global secondary index:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATING</code> - The global secondary index is being created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATING</code> - The global secondary index is being updated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETING</code> - The global secondary index is being deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVE</code> - The global secondary index is ready for use.
         * </p>
         * </li>
         * </ul>
         * 
         * @param indexStatus
         *        The current status of the global secondary index:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATING</code> - The global secondary index is being created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATING</code> - The global secondary index is being updated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETING</code> - The global secondary index is being deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code> - The global secondary index is ready for use.
         *        </p>
         *        </li>
         * @see IndexStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IndexStatus
         */
        Builder indexStatus(IndexStatus indexStatus);

        /**
         * <p>
         * The maximum number of strongly consistent reads consumed per second before DynamoDB returns a
         * <code>ThrottlingException</code>.
         * </p>
         * 
         * @param provisionedReadCapacityUnits
         *        The maximum number of strongly consistent reads consumed per second before DynamoDB returns a
         *        <code>ThrottlingException</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedReadCapacityUnits(Long provisionedReadCapacityUnits);

        /**
         * <p>
         * The maximum number of writes consumed per second before DynamoDB returns a <code>ThrottlingException</code>.
         * </p>
         * 
         * @param provisionedWriteCapacityUnits
         *        The maximum number of writes consumed per second before DynamoDB returns a
         *        <code>ThrottlingException</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedWriteCapacityUnits(Long provisionedWriteCapacityUnits);
    }

    static final class BuilderImpl implements Builder {
        private String indexName;

        private String indexStatus;

        private Long provisionedReadCapacityUnits;

        private Long provisionedWriteCapacityUnits;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicaGlobalSecondaryIndexSettingsDescription model) {
            indexName(model.indexName);
            indexStatus(model.indexStatus);
            provisionedReadCapacityUnits(model.provisionedReadCapacityUnits);
            provisionedWriteCapacityUnits(model.provisionedWriteCapacityUnits);
        }

        public final String getIndexName() {
            return indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        public final String getIndexStatus() {
            return indexStatus;
        }

        @Override
        public final Builder indexStatus(String indexStatus) {
            this.indexStatus = indexStatus;
            return this;
        }

        @Override
        public final Builder indexStatus(IndexStatus indexStatus) {
            this.indexStatus(indexStatus.toString());
            return this;
        }

        public final void setIndexStatus(String indexStatus) {
            this.indexStatus = indexStatus;
        }

        public final Long getProvisionedReadCapacityUnits() {
            return provisionedReadCapacityUnits;
        }

        @Override
        public final Builder provisionedReadCapacityUnits(Long provisionedReadCapacityUnits) {
            this.provisionedReadCapacityUnits = provisionedReadCapacityUnits;
            return this;
        }

        public final void setProvisionedReadCapacityUnits(Long provisionedReadCapacityUnits) {
            this.provisionedReadCapacityUnits = provisionedReadCapacityUnits;
        }

        public final Long getProvisionedWriteCapacityUnits() {
            return provisionedWriteCapacityUnits;
        }

        @Override
        public final Builder provisionedWriteCapacityUnits(Long provisionedWriteCapacityUnits) {
            this.provisionedWriteCapacityUnits = provisionedWriteCapacityUnits;
            return this;
        }

        public final void setProvisionedWriteCapacityUnits(Long provisionedWriteCapacityUnits) {
            this.provisionedWriteCapacityUnits = provisionedWriteCapacityUnits;
        }

        @Override
        public ReplicaGlobalSecondaryIndexSettingsDescription build() {
            return new ReplicaGlobalSecondaryIndexSettingsDescription(this);
        }
    }
}
