/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.dynamodb.transform.SourceTableFeatureDetailsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the details of the features enabled on the table when the backup was created. For example, LSIs, GSIs,
 * streams, TTL.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SourceTableFeatureDetails implements StructuredPojo,
        ToCopyableBuilder<SourceTableFeatureDetails.Builder, SourceTableFeatureDetails> {
    private final List<LocalSecondaryIndexInfo> localSecondaryIndexes;

    private final List<GlobalSecondaryIndexInfo> globalSecondaryIndexes;

    private final StreamSpecification streamDescription;

    private final TimeToLiveDescription timeToLiveDescription;

    private final SSEDescription sseDescription;

    private SourceTableFeatureDetails(BuilderImpl builder) {
        this.localSecondaryIndexes = builder.localSecondaryIndexes;
        this.globalSecondaryIndexes = builder.globalSecondaryIndexes;
        this.streamDescription = builder.streamDescription;
        this.timeToLiveDescription = builder.timeToLiveDescription;
        this.sseDescription = builder.sseDescription;
    }

    /**
     * <p>
     * Represents the LSI properties for the table when the backup was created. It includes the IndexName, KeySchema and
     * Projection for the LSIs on the table at the time of backup.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Represents the LSI properties for the table when the backup was created. It includes the IndexName,
     *         KeySchema and Projection for the LSIs on the table at the time of backup.
     */
    public List<LocalSecondaryIndexInfo> localSecondaryIndexes() {
        return localSecondaryIndexes;
    }

    /**
     * <p>
     * Represents the GSI properties for the table when the backup was created. It includes the IndexName, KeySchema,
     * Projection and ProvisionedThroughput for the GSIs on the table at the time of backup.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Represents the GSI properties for the table when the backup was created. It includes the IndexName,
     *         KeySchema, Projection and ProvisionedThroughput for the GSIs on the table at the time of backup.
     */
    public List<GlobalSecondaryIndexInfo> globalSecondaryIndexes() {
        return globalSecondaryIndexes;
    }

    /**
     * <p>
     * Stream settings on the table when the backup was created.
     * </p>
     * 
     * @return Stream settings on the table when the backup was created.
     */
    public StreamSpecification streamDescription() {
        return streamDescription;
    }

    /**
     * <p>
     * Time to Live settings on the table when the backup was created.
     * </p>
     * 
     * @return Time to Live settings on the table when the backup was created.
     */
    public TimeToLiveDescription timeToLiveDescription() {
        return timeToLiveDescription;
    }

    /**
     * <p>
     * The description of the server-side encryption status on the table when the backup was created.
     * </p>
     * 
     * @return The description of the server-side encryption status on the table when the backup was created.
     */
    public SSEDescription sseDescription() {
        return sseDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(localSecondaryIndexes());
        hashCode = 31 * hashCode + Objects.hashCode(globalSecondaryIndexes());
        hashCode = 31 * hashCode + Objects.hashCode(streamDescription());
        hashCode = 31 * hashCode + Objects.hashCode(timeToLiveDescription());
        hashCode = 31 * hashCode + Objects.hashCode(sseDescription());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceTableFeatureDetails)) {
            return false;
        }
        SourceTableFeatureDetails other = (SourceTableFeatureDetails) obj;
        return Objects.equals(localSecondaryIndexes(), other.localSecondaryIndexes())
                && Objects.equals(globalSecondaryIndexes(), other.globalSecondaryIndexes())
                && Objects.equals(streamDescription(), other.streamDescription())
                && Objects.equals(timeToLiveDescription(), other.timeToLiveDescription())
                && Objects.equals(sseDescription(), other.sseDescription());
    }

    @Override
    public String toString() {
        return ToString.builder("SourceTableFeatureDetails").add("LocalSecondaryIndexes", localSecondaryIndexes())
                .add("GlobalSecondaryIndexes", globalSecondaryIndexes()).add("StreamDescription", streamDescription())
                .add("TimeToLiveDescription", timeToLiveDescription()).add("SSEDescription", sseDescription()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LocalSecondaryIndexes":
            return Optional.ofNullable(clazz.cast(localSecondaryIndexes()));
        case "GlobalSecondaryIndexes":
            return Optional.ofNullable(clazz.cast(globalSecondaryIndexes()));
        case "StreamDescription":
            return Optional.ofNullable(clazz.cast(streamDescription()));
        case "TimeToLiveDescription":
            return Optional.ofNullable(clazz.cast(timeToLiveDescription()));
        case "SSEDescription":
            return Optional.ofNullable(clazz.cast(sseDescription()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SourceTableFeatureDetailsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, SourceTableFeatureDetails> {
        /**
         * <p>
         * Represents the LSI properties for the table when the backup was created. It includes the IndexName, KeySchema
         * and Projection for the LSIs on the table at the time of backup.
         * </p>
         * 
         * @param localSecondaryIndexes
         *        Represents the LSI properties for the table when the backup was created. It includes the IndexName,
         *        KeySchema and Projection for the LSIs on the table at the time of backup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localSecondaryIndexes(Collection<LocalSecondaryIndexInfo> localSecondaryIndexes);

        /**
         * <p>
         * Represents the LSI properties for the table when the backup was created. It includes the IndexName, KeySchema
         * and Projection for the LSIs on the table at the time of backup.
         * </p>
         * 
         * @param localSecondaryIndexes
         *        Represents the LSI properties for the table when the backup was created. It includes the IndexName,
         *        KeySchema and Projection for the LSIs on the table at the time of backup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localSecondaryIndexes(LocalSecondaryIndexInfo... localSecondaryIndexes);

        /**
         * <p>
         * Represents the LSI properties for the table when the backup was created. It includes the IndexName, KeySchema
         * and Projection for the LSIs on the table at the time of backup.
         * </p>
         * This is a convenience that creates an instance of the {@link List<LocalSecondaryIndexInfo>.Builder} avoiding
         * the need to create one manually via {@link List<LocalSecondaryIndexInfo>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LocalSecondaryIndexInfo>.Builder#build()} is called
         * immediately and its result is passed to {@link #localSecondaryIndexes(List<LocalSecondaryIndexInfo>)}.
         * 
         * @param localSecondaryIndexes
         *        a consumer that will call methods on {@link List<LocalSecondaryIndexInfo>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #localSecondaryIndexes(List<LocalSecondaryIndexInfo>)
         */
        Builder localSecondaryIndexes(Consumer<LocalSecondaryIndexInfo.Builder>... localSecondaryIndexes);

        /**
         * <p>
         * Represents the GSI properties for the table when the backup was created. It includes the IndexName,
         * KeySchema, Projection and ProvisionedThroughput for the GSIs on the table at the time of backup.
         * </p>
         * 
         * @param globalSecondaryIndexes
         *        Represents the GSI properties for the table when the backup was created. It includes the IndexName,
         *        KeySchema, Projection and ProvisionedThroughput for the GSIs on the table at the time of backup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalSecondaryIndexes(Collection<GlobalSecondaryIndexInfo> globalSecondaryIndexes);

        /**
         * <p>
         * Represents the GSI properties for the table when the backup was created. It includes the IndexName,
         * KeySchema, Projection and ProvisionedThroughput for the GSIs on the table at the time of backup.
         * </p>
         * 
         * @param globalSecondaryIndexes
         *        Represents the GSI properties for the table when the backup was created. It includes the IndexName,
         *        KeySchema, Projection and ProvisionedThroughput for the GSIs on the table at the time of backup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalSecondaryIndexes(GlobalSecondaryIndexInfo... globalSecondaryIndexes);

        /**
         * <p>
         * Represents the GSI properties for the table when the backup was created. It includes the IndexName,
         * KeySchema, Projection and ProvisionedThroughput for the GSIs on the table at the time of backup.
         * </p>
         * This is a convenience that creates an instance of the {@link List<GlobalSecondaryIndexInfo>.Builder} avoiding
         * the need to create one manually via {@link List<GlobalSecondaryIndexInfo>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<GlobalSecondaryIndexInfo>.Builder#build()} is called
         * immediately and its result is passed to {@link #globalSecondaryIndexes(List<GlobalSecondaryIndexInfo>)}.
         * 
         * @param globalSecondaryIndexes
         *        a consumer that will call methods on {@link List<GlobalSecondaryIndexInfo>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #globalSecondaryIndexes(List<GlobalSecondaryIndexInfo>)
         */
        Builder globalSecondaryIndexes(Consumer<GlobalSecondaryIndexInfo.Builder>... globalSecondaryIndexes);

        /**
         * <p>
         * Stream settings on the table when the backup was created.
         * </p>
         * 
         * @param streamDescription
         *        Stream settings on the table when the backup was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamDescription(StreamSpecification streamDescription);

        /**
         * <p>
         * Stream settings on the table when the backup was created.
         * </p>
         * This is a convenience that creates an instance of the {@link StreamSpecification.Builder} avoiding the need
         * to create one manually via {@link StreamSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link StreamSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #streamDescription(StreamSpecification)}.
         * 
         * @param streamDescription
         *        a consumer that will call methods on {@link StreamSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #streamDescription(StreamSpecification)
         */
        default Builder streamDescription(Consumer<StreamSpecification.Builder> streamDescription) {
            return streamDescription(StreamSpecification.builder().applyMutation(streamDescription).build());
        }

        /**
         * <p>
         * Time to Live settings on the table when the backup was created.
         * </p>
         * 
         * @param timeToLiveDescription
         *        Time to Live settings on the table when the backup was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeToLiveDescription(TimeToLiveDescription timeToLiveDescription);

        /**
         * <p>
         * Time to Live settings on the table when the backup was created.
         * </p>
         * This is a convenience that creates an instance of the {@link TimeToLiveDescription.Builder} avoiding the need
         * to create one manually via {@link TimeToLiveDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link TimeToLiveDescription.Builder#build()} is called immediately and
         * its result is passed to {@link #timeToLiveDescription(TimeToLiveDescription)}.
         * 
         * @param timeToLiveDescription
         *        a consumer that will call methods on {@link TimeToLiveDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timeToLiveDescription(TimeToLiveDescription)
         */
        default Builder timeToLiveDescription(Consumer<TimeToLiveDescription.Builder> timeToLiveDescription) {
            return timeToLiveDescription(TimeToLiveDescription.builder().applyMutation(timeToLiveDescription).build());
        }

        /**
         * <p>
         * The description of the server-side encryption status on the table when the backup was created.
         * </p>
         * 
         * @param sseDescription
         *        The description of the server-side encryption status on the table when the backup was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sseDescription(SSEDescription sseDescription);

        /**
         * <p>
         * The description of the server-side encryption status on the table when the backup was created.
         * </p>
         * This is a convenience that creates an instance of the {@link SSEDescription.Builder} avoiding the need to
         * create one manually via {@link SSEDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link SSEDescription.Builder#build()} is called immediately and its
         * result is passed to {@link #sseDescription(SSEDescription)}.
         * 
         * @param sseDescription
         *        a consumer that will call methods on {@link SSEDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sseDescription(SSEDescription)
         */
        default Builder sseDescription(Consumer<SSEDescription.Builder> sseDescription) {
            return sseDescription(SSEDescription.builder().applyMutation(sseDescription).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<LocalSecondaryIndexInfo> localSecondaryIndexes = DefaultSdkAutoConstructList.getInstance();

        private List<GlobalSecondaryIndexInfo> globalSecondaryIndexes = DefaultSdkAutoConstructList.getInstance();

        private StreamSpecification streamDescription;

        private TimeToLiveDescription timeToLiveDescription;

        private SSEDescription sseDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceTableFeatureDetails model) {
            localSecondaryIndexes(model.localSecondaryIndexes);
            globalSecondaryIndexes(model.globalSecondaryIndexes);
            streamDescription(model.streamDescription);
            timeToLiveDescription(model.timeToLiveDescription);
            sseDescription(model.sseDescription);
        }

        public final Collection<LocalSecondaryIndexInfo.Builder> getLocalSecondaryIndexes() {
            return localSecondaryIndexes != null ? localSecondaryIndexes.stream().map(LocalSecondaryIndexInfo::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder localSecondaryIndexes(Collection<LocalSecondaryIndexInfo> localSecondaryIndexes) {
            this.localSecondaryIndexes = LocalSecondaryIndexesCopier.copy(localSecondaryIndexes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder localSecondaryIndexes(LocalSecondaryIndexInfo... localSecondaryIndexes) {
            localSecondaryIndexes(Arrays.asList(localSecondaryIndexes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder localSecondaryIndexes(Consumer<LocalSecondaryIndexInfo.Builder>... localSecondaryIndexes) {
            localSecondaryIndexes(Stream.of(localSecondaryIndexes)
                    .map(c -> LocalSecondaryIndexInfo.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLocalSecondaryIndexes(Collection<LocalSecondaryIndexInfo.BuilderImpl> localSecondaryIndexes) {
            this.localSecondaryIndexes = LocalSecondaryIndexesCopier.copyFromBuilder(localSecondaryIndexes);
        }

        public final Collection<GlobalSecondaryIndexInfo.Builder> getGlobalSecondaryIndexes() {
            return globalSecondaryIndexes != null ? globalSecondaryIndexes.stream().map(GlobalSecondaryIndexInfo::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder globalSecondaryIndexes(Collection<GlobalSecondaryIndexInfo> globalSecondaryIndexes) {
            this.globalSecondaryIndexes = GlobalSecondaryIndexesCopier.copy(globalSecondaryIndexes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalSecondaryIndexes(GlobalSecondaryIndexInfo... globalSecondaryIndexes) {
            globalSecondaryIndexes(Arrays.asList(globalSecondaryIndexes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalSecondaryIndexes(Consumer<GlobalSecondaryIndexInfo.Builder>... globalSecondaryIndexes) {
            globalSecondaryIndexes(Stream.of(globalSecondaryIndexes)
                    .map(c -> GlobalSecondaryIndexInfo.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setGlobalSecondaryIndexes(Collection<GlobalSecondaryIndexInfo.BuilderImpl> globalSecondaryIndexes) {
            this.globalSecondaryIndexes = GlobalSecondaryIndexesCopier.copyFromBuilder(globalSecondaryIndexes);
        }

        public final StreamSpecification.Builder getStreamDescription() {
            return streamDescription != null ? streamDescription.toBuilder() : null;
        }

        @Override
        public final Builder streamDescription(StreamSpecification streamDescription) {
            this.streamDescription = streamDescription;
            return this;
        }

        public final void setStreamDescription(StreamSpecification.BuilderImpl streamDescription) {
            this.streamDescription = streamDescription != null ? streamDescription.build() : null;
        }

        public final TimeToLiveDescription.Builder getTimeToLiveDescription() {
            return timeToLiveDescription != null ? timeToLiveDescription.toBuilder() : null;
        }

        @Override
        public final Builder timeToLiveDescription(TimeToLiveDescription timeToLiveDescription) {
            this.timeToLiveDescription = timeToLiveDescription;
            return this;
        }

        public final void setTimeToLiveDescription(TimeToLiveDescription.BuilderImpl timeToLiveDescription) {
            this.timeToLiveDescription = timeToLiveDescription != null ? timeToLiveDescription.build() : null;
        }

        public final SSEDescription.Builder getSSEDescription() {
            return sseDescription != null ? sseDescription.toBuilder() : null;
        }

        @Override
        public final Builder sseDescription(SSEDescription sseDescription) {
            this.sseDescription = sseDescription;
            return this;
        }

        public final void setSSEDescription(SSEDescription.BuilderImpl sseDescription) {
            this.sseDescription = sseDescription != null ? sseDescription.build() : null;
        }

        @Override
        public SourceTableFeatureDetails build() {
            return new SourceTableFeatureDetails(this);
        }
    }
}
