/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateGlobalTableSettingsRequest extends DynamoDbRequest implements
        ToCopyableBuilder<UpdateGlobalTableSettingsRequest.Builder, UpdateGlobalTableSettingsRequest> {
    private final String globalTableName;

    private final Long globalTableProvisionedWriteCapacityUnits;

    private final List<GlobalTableGlobalSecondaryIndexSettingsUpdate> globalTableGlobalSecondaryIndexSettingsUpdate;

    private final List<ReplicaSettingsUpdate> replicaSettingsUpdate;

    private UpdateGlobalTableSettingsRequest(BuilderImpl builder) {
        super(builder);
        this.globalTableName = builder.globalTableName;
        this.globalTableProvisionedWriteCapacityUnits = builder.globalTableProvisionedWriteCapacityUnits;
        this.globalTableGlobalSecondaryIndexSettingsUpdate = builder.globalTableGlobalSecondaryIndexSettingsUpdate;
        this.replicaSettingsUpdate = builder.replicaSettingsUpdate;
    }

    /**
     * <p>
     * The name of the global table
     * </p>
     * 
     * @return The name of the global table
     */
    public String globalTableName() {
        return globalTableName;
    }

    /**
     * <p>
     * The maximum number of writes consumed per second before DynamoDB returns a <code>ThrottlingException.</code>
     * </p>
     * 
     * @return The maximum number of writes consumed per second before DynamoDB returns a
     *         <code>ThrottlingException.</code>
     */
    public Long globalTableProvisionedWriteCapacityUnits() {
        return globalTableProvisionedWriteCapacityUnits;
    }

    /**
     * <p>
     * Represents the settings of a global secondary index for a global table that will be modified.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Represents the settings of a global secondary index for a global table that will be modified.
     */
    public List<GlobalTableGlobalSecondaryIndexSettingsUpdate> globalTableGlobalSecondaryIndexSettingsUpdate() {
        return globalTableGlobalSecondaryIndexSettingsUpdate;
    }

    /**
     * <p>
     * Represents the settings for a global table in a region that will be modified.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Represents the settings for a global table in a region that will be modified.
     */
    public List<ReplicaSettingsUpdate> replicaSettingsUpdate() {
        return replicaSettingsUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(globalTableName());
        hashCode = 31 * hashCode + Objects.hashCode(globalTableProvisionedWriteCapacityUnits());
        hashCode = 31 * hashCode + Objects.hashCode(globalTableGlobalSecondaryIndexSettingsUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(replicaSettingsUpdate());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateGlobalTableSettingsRequest)) {
            return false;
        }
        UpdateGlobalTableSettingsRequest other = (UpdateGlobalTableSettingsRequest) obj;
        return Objects.equals(globalTableName(), other.globalTableName())
                && Objects.equals(globalTableProvisionedWriteCapacityUnits(), other.globalTableProvisionedWriteCapacityUnits())
                && Objects.equals(globalTableGlobalSecondaryIndexSettingsUpdate(),
                        other.globalTableGlobalSecondaryIndexSettingsUpdate())
                && Objects.equals(replicaSettingsUpdate(), other.replicaSettingsUpdate());
    }

    @Override
    public String toString() {
        return ToString.builder("UpdateGlobalTableSettingsRequest").add("GlobalTableName", globalTableName())
                .add("GlobalTableProvisionedWriteCapacityUnits", globalTableProvisionedWriteCapacityUnits())
                .add("GlobalTableGlobalSecondaryIndexSettingsUpdate", globalTableGlobalSecondaryIndexSettingsUpdate())
                .add("ReplicaSettingsUpdate", replicaSettingsUpdate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GlobalTableName":
            return Optional.ofNullable(clazz.cast(globalTableName()));
        case "GlobalTableProvisionedWriteCapacityUnits":
            return Optional.ofNullable(clazz.cast(globalTableProvisionedWriteCapacityUnits()));
        case "GlobalTableGlobalSecondaryIndexSettingsUpdate":
            return Optional.ofNullable(clazz.cast(globalTableGlobalSecondaryIndexSettingsUpdate()));
        case "ReplicaSettingsUpdate":
            return Optional.ofNullable(clazz.cast(replicaSettingsUpdate()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends DynamoDbRequest.Builder, CopyableBuilder<Builder, UpdateGlobalTableSettingsRequest> {
        /**
         * <p>
         * The name of the global table
         * </p>
         * 
         * @param globalTableName
         *        The name of the global table
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalTableName(String globalTableName);

        /**
         * <p>
         * The maximum number of writes consumed per second before DynamoDB returns a <code>ThrottlingException.</code>
         * </p>
         * 
         * @param globalTableProvisionedWriteCapacityUnits
         *        The maximum number of writes consumed per second before DynamoDB returns a
         *        <code>ThrottlingException.</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalTableProvisionedWriteCapacityUnits(Long globalTableProvisionedWriteCapacityUnits);

        /**
         * <p>
         * Represents the settings of a global secondary index for a global table that will be modified.
         * </p>
         * 
         * @param globalTableGlobalSecondaryIndexSettingsUpdate
         *        Represents the settings of a global secondary index for a global table that will be modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalTableGlobalSecondaryIndexSettingsUpdate(
                Collection<GlobalTableGlobalSecondaryIndexSettingsUpdate> globalTableGlobalSecondaryIndexSettingsUpdate);

        /**
         * <p>
         * Represents the settings of a global secondary index for a global table that will be modified.
         * </p>
         * 
         * @param globalTableGlobalSecondaryIndexSettingsUpdate
         *        Represents the settings of a global secondary index for a global table that will be modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalTableGlobalSecondaryIndexSettingsUpdate(
                GlobalTableGlobalSecondaryIndexSettingsUpdate... globalTableGlobalSecondaryIndexSettingsUpdate);

        /**
         * <p>
         * Represents the settings of a global secondary index for a global table that will be modified.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <GlobalTableGlobalSecondaryIndexSettingsUpdate>.Builder} avoiding the need to create one manually via
         * {@link List<GlobalTableGlobalSecondaryIndexSettingsUpdate>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List
         * <GlobalTableGlobalSecondaryIndexSettingsUpdate>.Builder#build()} is called immediately and its result is
         * passed to {@link
         * #globalTableGlobalSecondaryIndexSettingsUpdate(List<GlobalTableGlobalSecondaryIndexSettingsUpdate>)}.
         * 
         * @param globalTableGlobalSecondaryIndexSettingsUpdate
         *        a consumer that will call methods on {@link List
         *        <GlobalTableGlobalSecondaryIndexSettingsUpdate>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #globalTableGlobalSecondaryIndexSettingsUpdate(List<GlobalTableGlobalSecondaryIndexSettingsUpdate>)
         */
        Builder globalTableGlobalSecondaryIndexSettingsUpdate(
                Consumer<GlobalTableGlobalSecondaryIndexSettingsUpdate.Builder>... globalTableGlobalSecondaryIndexSettingsUpdate);

        /**
         * <p>
         * Represents the settings for a global table in a region that will be modified.
         * </p>
         * 
         * @param replicaSettingsUpdate
         *        Represents the settings for a global table in a region that will be modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicaSettingsUpdate(Collection<ReplicaSettingsUpdate> replicaSettingsUpdate);

        /**
         * <p>
         * Represents the settings for a global table in a region that will be modified.
         * </p>
         * 
         * @param replicaSettingsUpdate
         *        Represents the settings for a global table in a region that will be modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicaSettingsUpdate(ReplicaSettingsUpdate... replicaSettingsUpdate);

        /**
         * <p>
         * Represents the settings for a global table in a region that will be modified.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ReplicaSettingsUpdate>.Builder} avoiding
         * the need to create one manually via {@link List<ReplicaSettingsUpdate>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ReplicaSettingsUpdate>.Builder#build()} is called
         * immediately and its result is passed to {@link #replicaSettingsUpdate(List<ReplicaSettingsUpdate>)}.
         * 
         * @param replicaSettingsUpdate
         *        a consumer that will call methods on {@link List<ReplicaSettingsUpdate>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replicaSettingsUpdate(List<ReplicaSettingsUpdate>)
         */
        Builder replicaSettingsUpdate(Consumer<ReplicaSettingsUpdate.Builder>... replicaSettingsUpdate);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DynamoDbRequest.BuilderImpl implements Builder {
        private String globalTableName;

        private Long globalTableProvisionedWriteCapacityUnits;

        private List<GlobalTableGlobalSecondaryIndexSettingsUpdate> globalTableGlobalSecondaryIndexSettingsUpdate = DefaultSdkAutoConstructList
                .getInstance();

        private List<ReplicaSettingsUpdate> replicaSettingsUpdate = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateGlobalTableSettingsRequest model) {
            super(model);
            globalTableName(model.globalTableName);
            globalTableProvisionedWriteCapacityUnits(model.globalTableProvisionedWriteCapacityUnits);
            globalTableGlobalSecondaryIndexSettingsUpdate(model.globalTableGlobalSecondaryIndexSettingsUpdate);
            replicaSettingsUpdate(model.replicaSettingsUpdate);
        }

        public final String getGlobalTableName() {
            return globalTableName;
        }

        @Override
        public final Builder globalTableName(String globalTableName) {
            this.globalTableName = globalTableName;
            return this;
        }

        public final void setGlobalTableName(String globalTableName) {
            this.globalTableName = globalTableName;
        }

        public final Long getGlobalTableProvisionedWriteCapacityUnits() {
            return globalTableProvisionedWriteCapacityUnits;
        }

        @Override
        public final Builder globalTableProvisionedWriteCapacityUnits(Long globalTableProvisionedWriteCapacityUnits) {
            this.globalTableProvisionedWriteCapacityUnits = globalTableProvisionedWriteCapacityUnits;
            return this;
        }

        public final void setGlobalTableProvisionedWriteCapacityUnits(Long globalTableProvisionedWriteCapacityUnits) {
            this.globalTableProvisionedWriteCapacityUnits = globalTableProvisionedWriteCapacityUnits;
        }

        public final Collection<GlobalTableGlobalSecondaryIndexSettingsUpdate.Builder> getGlobalTableGlobalSecondaryIndexSettingsUpdate() {
            return globalTableGlobalSecondaryIndexSettingsUpdate != null ? globalTableGlobalSecondaryIndexSettingsUpdate.stream()
                    .map(GlobalTableGlobalSecondaryIndexSettingsUpdate::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder globalTableGlobalSecondaryIndexSettingsUpdate(
                Collection<GlobalTableGlobalSecondaryIndexSettingsUpdate> globalTableGlobalSecondaryIndexSettingsUpdate) {
            this.globalTableGlobalSecondaryIndexSettingsUpdate = GlobalTableGlobalSecondaryIndexSettingsUpdateListCopier
                    .copy(globalTableGlobalSecondaryIndexSettingsUpdate);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalTableGlobalSecondaryIndexSettingsUpdate(
                GlobalTableGlobalSecondaryIndexSettingsUpdate... globalTableGlobalSecondaryIndexSettingsUpdate) {
            globalTableGlobalSecondaryIndexSettingsUpdate(Arrays.asList(globalTableGlobalSecondaryIndexSettingsUpdate));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalTableGlobalSecondaryIndexSettingsUpdate(
                Consumer<GlobalTableGlobalSecondaryIndexSettingsUpdate.Builder>... globalTableGlobalSecondaryIndexSettingsUpdate) {
            globalTableGlobalSecondaryIndexSettingsUpdate(Stream.of(globalTableGlobalSecondaryIndexSettingsUpdate)
                    .map(c -> GlobalTableGlobalSecondaryIndexSettingsUpdate.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setGlobalTableGlobalSecondaryIndexSettingsUpdate(
                Collection<GlobalTableGlobalSecondaryIndexSettingsUpdate.BuilderImpl> globalTableGlobalSecondaryIndexSettingsUpdate) {
            this.globalTableGlobalSecondaryIndexSettingsUpdate = GlobalTableGlobalSecondaryIndexSettingsUpdateListCopier
                    .copyFromBuilder(globalTableGlobalSecondaryIndexSettingsUpdate);
        }

        public final Collection<ReplicaSettingsUpdate.Builder> getReplicaSettingsUpdate() {
            return replicaSettingsUpdate != null ? replicaSettingsUpdate.stream().map(ReplicaSettingsUpdate::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder replicaSettingsUpdate(Collection<ReplicaSettingsUpdate> replicaSettingsUpdate) {
            this.replicaSettingsUpdate = ReplicaSettingsUpdateListCopier.copy(replicaSettingsUpdate);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicaSettingsUpdate(ReplicaSettingsUpdate... replicaSettingsUpdate) {
            replicaSettingsUpdate(Arrays.asList(replicaSettingsUpdate));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicaSettingsUpdate(Consumer<ReplicaSettingsUpdate.Builder>... replicaSettingsUpdate) {
            replicaSettingsUpdate(Stream.of(replicaSettingsUpdate)
                    .map(c -> ReplicaSettingsUpdate.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setReplicaSettingsUpdate(Collection<ReplicaSettingsUpdate.BuilderImpl> replicaSettingsUpdate) {
            this.replicaSettingsUpdate = ReplicaSettingsUpdateListCopier.copyFromBuilder(replicaSettingsUpdate);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateGlobalTableSettingsRequest build() {
            return new UpdateGlobalTableSettingsRequest(this);
        }
    }
}
