/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.dynamodb.model.DynamoDbRequest;
import software.amazon.awssdk.services.dynamodb.model.Replica;
import software.amazon.awssdk.services.dynamodb.model.ReplicaListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateGlobalTableRequest
extends DynamoDbRequest
implements ToCopyableBuilder<Builder, CreateGlobalTableRequest> {
    private final String globalTableName;
    private final List<Replica> replicationGroup;

    private CreateGlobalTableRequest(BuilderImpl builder) {
        super(builder);
        this.globalTableName = builder.globalTableName;
        this.replicationGroup = builder.replicationGroup;
    }

    public String globalTableName() {
        return this.globalTableName;
    }

    public List<Replica> replicationGroup() {
        return this.replicationGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.globalTableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationGroup());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGlobalTableRequest)) {
            return false;
        }
        CreateGlobalTableRequest other = (CreateGlobalTableRequest)((Object)obj);
        return Objects.equals(this.globalTableName(), other.globalTableName()) && Objects.equals(this.replicationGroup(), other.replicationGroup());
    }

    public String toString() {
        return ToString.builder((String)"CreateGlobalTableRequest").add("GlobalTableName", (Object)this.globalTableName()).add("ReplicationGroup", this.replicationGroup()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GlobalTableName": {
                return Optional.ofNullable(clazz.cast(this.globalTableName()));
            }
            case "ReplicationGroup": {
                return Optional.ofNullable(clazz.cast(this.replicationGroup()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DynamoDbRequest.BuilderImpl
    implements Builder {
        private String globalTableName;
        private List<Replica> replicationGroup = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGlobalTableRequest model) {
            super(model);
            this.globalTableName(model.globalTableName);
            this.replicationGroup(model.replicationGroup);
        }

        public final String getGlobalTableName() {
            return this.globalTableName;
        }

        @Override
        public final Builder globalTableName(String globalTableName) {
            this.globalTableName = globalTableName;
            return this;
        }

        public final void setGlobalTableName(String globalTableName) {
            this.globalTableName = globalTableName;
        }

        public final Collection<Replica.Builder> getReplicationGroup() {
            return this.replicationGroup != null ? (Collection)this.replicationGroup.stream().map(Replica::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder replicationGroup(Collection<Replica> replicationGroup) {
            this.replicationGroup = ReplicaListCopier.copy(replicationGroup);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationGroup(Replica ... replicationGroup) {
            this.replicationGroup(Arrays.asList(replicationGroup));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationGroup(Consumer<Replica.Builder> ... replicationGroup) {
            this.replicationGroup(Stream.of(replicationGroup).map(c -> (Replica)((Replica.Builder)Replica.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setReplicationGroup(Collection<Replica.BuilderImpl> replicationGroup) {
            this.replicationGroup = ReplicaListCopier.copyFromBuilder(replicationGroup);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateGlobalTableRequest build() {
            return new CreateGlobalTableRequest(this);
        }
    }

    public static interface Builder
    extends DynamoDbRequest.Builder,
    CopyableBuilder<Builder, CreateGlobalTableRequest> {
        public Builder globalTableName(String var1);

        public Builder replicationGroup(Collection<Replica> var1);

        public Builder replicationGroup(Replica ... var1);

        public Builder replicationGroup(Consumer<Replica.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

