/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.dynamodb.model.KeySchemaCopier;
import software.amazon.awssdk.services.dynamodb.model.KeySchemaElement;
import software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughput;
import software.amazon.awssdk.services.dynamodb.transform.SourceTableDetailsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SourceTableDetails
implements StructuredPojo,
ToCopyableBuilder<Builder, SourceTableDetails> {
    private final String tableName;
    private final String tableId;
    private final String tableArn;
    private final Long tableSizeBytes;
    private final List<KeySchemaElement> keySchema;
    private final Instant tableCreationDateTime;
    private final ProvisionedThroughput provisionedThroughput;
    private final Long itemCount;

    private SourceTableDetails(BuilderImpl builder) {
        this.tableName = builder.tableName;
        this.tableId = builder.tableId;
        this.tableArn = builder.tableArn;
        this.tableSizeBytes = builder.tableSizeBytes;
        this.keySchema = builder.keySchema;
        this.tableCreationDateTime = builder.tableCreationDateTime;
        this.provisionedThroughput = builder.provisionedThroughput;
        this.itemCount = builder.itemCount;
    }

    public String tableName() {
        return this.tableName;
    }

    public String tableId() {
        return this.tableId;
    }

    public String tableArn() {
        return this.tableArn;
    }

    public Long tableSizeBytes() {
        return this.tableSizeBytes;
    }

    public List<KeySchemaElement> keySchema() {
        return this.keySchema;
    }

    public Instant tableCreationDateTime() {
        return this.tableCreationDateTime;
    }

    public ProvisionedThroughput provisionedThroughput() {
        return this.provisionedThroughput;
    }

    public Long itemCount() {
        return this.itemCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableId());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableSizeBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.keySchema());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableCreationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedThroughput());
        hashCode = 31 * hashCode + Objects.hashCode(this.itemCount());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceTableDetails)) {
            return false;
        }
        SourceTableDetails other = (SourceTableDetails)obj;
        return Objects.equals(this.tableName(), other.tableName()) && Objects.equals(this.tableId(), other.tableId()) && Objects.equals(this.tableArn(), other.tableArn()) && Objects.equals(this.tableSizeBytes(), other.tableSizeBytes()) && Objects.equals(this.keySchema(), other.keySchema()) && Objects.equals(this.tableCreationDateTime(), other.tableCreationDateTime()) && Objects.equals(this.provisionedThroughput(), other.provisionedThroughput()) && Objects.equals(this.itemCount(), other.itemCount());
    }

    public String toString() {
        return ToString.builder((String)"SourceTableDetails").add("TableName", (Object)this.tableName()).add("TableId", (Object)this.tableId()).add("TableArn", (Object)this.tableArn()).add("TableSizeBytes", (Object)this.tableSizeBytes()).add("KeySchema", this.keySchema()).add("TableCreationDateTime", (Object)this.tableCreationDateTime()).add("ProvisionedThroughput", (Object)this.provisionedThroughput()).add("ItemCount", (Object)this.itemCount()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TableName": {
                return Optional.ofNullable(clazz.cast(this.tableName()));
            }
            case "TableId": {
                return Optional.ofNullable(clazz.cast(this.tableId()));
            }
            case "TableArn": {
                return Optional.ofNullable(clazz.cast(this.tableArn()));
            }
            case "TableSizeBytes": {
                return Optional.ofNullable(clazz.cast(this.tableSizeBytes()));
            }
            case "KeySchema": {
                return Optional.ofNullable(clazz.cast(this.keySchema()));
            }
            case "TableCreationDateTime": {
                return Optional.ofNullable(clazz.cast(this.tableCreationDateTime()));
            }
            case "ProvisionedThroughput": {
                return Optional.ofNullable(clazz.cast(this.provisionedThroughput()));
            }
            case "ItemCount": {
                return Optional.ofNullable(clazz.cast(this.itemCount()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SourceTableDetailsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String tableName;
        private String tableId;
        private String tableArn;
        private Long tableSizeBytes;
        private List<KeySchemaElement> keySchema = DefaultSdkAutoConstructList.getInstance();
        private Instant tableCreationDateTime;
        private ProvisionedThroughput provisionedThroughput;
        private Long itemCount;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceTableDetails model) {
            this.tableName(model.tableName);
            this.tableId(model.tableId);
            this.tableArn(model.tableArn);
            this.tableSizeBytes(model.tableSizeBytes);
            this.keySchema(model.keySchema);
            this.tableCreationDateTime(model.tableCreationDateTime);
            this.provisionedThroughput(model.provisionedThroughput);
            this.itemCount(model.itemCount);
        }

        public final String getTableName() {
            return this.tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final String getTableId() {
            return this.tableId;
        }

        @Override
        public final Builder tableId(String tableId) {
            this.tableId = tableId;
            return this;
        }

        public final void setTableId(String tableId) {
            this.tableId = tableId;
        }

        public final String getTableArn() {
            return this.tableArn;
        }

        @Override
        public final Builder tableArn(String tableArn) {
            this.tableArn = tableArn;
            return this;
        }

        public final void setTableArn(String tableArn) {
            this.tableArn = tableArn;
        }

        public final Long getTableSizeBytes() {
            return this.tableSizeBytes;
        }

        @Override
        public final Builder tableSizeBytes(Long tableSizeBytes) {
            this.tableSizeBytes = tableSizeBytes;
            return this;
        }

        public final void setTableSizeBytes(Long tableSizeBytes) {
            this.tableSizeBytes = tableSizeBytes;
        }

        public final Collection<KeySchemaElement.Builder> getKeySchema() {
            return this.keySchema != null ? (Collection)this.keySchema.stream().map(KeySchemaElement::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder keySchema(Collection<KeySchemaElement> keySchema) {
            this.keySchema = KeySchemaCopier.copy(keySchema);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keySchema(KeySchemaElement ... keySchema) {
            this.keySchema(Arrays.asList(keySchema));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keySchema(Consumer<KeySchemaElement.Builder> ... keySchema) {
            this.keySchema(Stream.of(keySchema).map(c -> (KeySchemaElement)((KeySchemaElement.Builder)KeySchemaElement.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setKeySchema(Collection<KeySchemaElement.BuilderImpl> keySchema) {
            this.keySchema = KeySchemaCopier.copyFromBuilder(keySchema);
        }

        public final Instant getTableCreationDateTime() {
            return this.tableCreationDateTime;
        }

        @Override
        public final Builder tableCreationDateTime(Instant tableCreationDateTime) {
            this.tableCreationDateTime = tableCreationDateTime;
            return this;
        }

        public final void setTableCreationDateTime(Instant tableCreationDateTime) {
            this.tableCreationDateTime = tableCreationDateTime;
        }

        public final ProvisionedThroughput.Builder getProvisionedThroughput() {
            return this.provisionedThroughput != null ? this.provisionedThroughput.toBuilder() : null;
        }

        @Override
        public final Builder provisionedThroughput(ProvisionedThroughput provisionedThroughput) {
            this.provisionedThroughput = provisionedThroughput;
            return this;
        }

        public final void setProvisionedThroughput(ProvisionedThroughput.BuilderImpl provisionedThroughput) {
            this.provisionedThroughput = provisionedThroughput != null ? provisionedThroughput.build() : null;
        }

        public final Long getItemCount() {
            return this.itemCount;
        }

        @Override
        public final Builder itemCount(Long itemCount) {
            this.itemCount = itemCount;
            return this;
        }

        public final void setItemCount(Long itemCount) {
            this.itemCount = itemCount;
        }

        public SourceTableDetails build() {
            return new SourceTableDetails(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SourceTableDetails> {
        public Builder tableName(String var1);

        public Builder tableId(String var1);

        public Builder tableArn(String var1);

        public Builder tableSizeBytes(Long var1);

        public Builder keySchema(Collection<KeySchemaElement> var1);

        public Builder keySchema(KeySchemaElement ... var1);

        public Builder keySchema(Consumer<KeySchemaElement.Builder> ... var1);

        public Builder tableCreationDateTime(Instant var1);

        public Builder provisionedThroughput(ProvisionedThroughput var1);

        default public Builder provisionedThroughput(Consumer<ProvisionedThroughput.Builder> provisionedThroughput) {
            return this.provisionedThroughput((ProvisionedThroughput)((ProvisionedThroughput.Builder)ProvisionedThroughput.builder().applyMutation(provisionedThroughput)).build());
        }

        public Builder itemCount(Long var1);
    }
}

