/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.BatchGetItemRequest;
import software.amazon.awssdk.services.dynamodb.model.BatchGetItemResponse;

public class BatchGetItemIterable
implements SdkIterable<BatchGetItemResponse> {
    private final DynamoDbClient client;
    private final BatchGetItemRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public BatchGetItemIterable(DynamoDbClient client, BatchGetItemRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new BatchGetItemResponseFetcher();
    }

    public Iterator<BatchGetItemResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final BatchGetItemIterable resume(BatchGetItemResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new BatchGetItemIterable(this.client, (BatchGetItemRequest)((Object)this.firstRequest.toBuilder().requestItems(lastSuccessfulPage.unprocessedKeys()).build()));
        }
        return new BatchGetItemIterable(this.client, this.firstRequest){

            @Override
            public Iterator<BatchGetItemResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class BatchGetItemResponseFetcher
    implements SyncPageFetcher<BatchGetItemResponse> {
        private BatchGetItemResponseFetcher() {
        }

        public boolean hasNextPage(BatchGetItemResponse previousPage) {
            return previousPage.unprocessedKeys() != null && !SdkAutoConstructList.class.isInstance(previousPage.unprocessedKeys()) && !SdkAutoConstructMap.class.isInstance(previousPage.unprocessedKeys());
        }

        public BatchGetItemResponse nextPage(BatchGetItemResponse previousPage) {
            if (previousPage == null) {
                return BatchGetItemIterable.this.client.batchGetItem(BatchGetItemIterable.this.firstRequest);
            }
            return BatchGetItemIterable.this.client.batchGetItem((BatchGetItemRequest)((Object)BatchGetItemIterable.this.firstRequest.toBuilder().requestItems(previousPage.unprocessedKeys()).build()));
        }
    }
}

