/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.QueryRequest;
import software.amazon.awssdk.services.dynamodb.model.QueryResponse;

public class QueryPublisher
implements SdkPublisher<QueryResponse> {
    private final DynamoDbAsyncClient client;
    private final QueryRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public QueryPublisher(DynamoDbAsyncClient client, QueryRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private QueryPublisher(DynamoDbAsyncClient client, QueryRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new QueryResponseFetcher();
    }

    public void subscribe(Subscriber<? super QueryResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Map<String, AttributeValue>> items() {
        Function<QueryResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new QueryResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private final QueryPublisher resume(QueryResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new QueryPublisher(this.client, (QueryRequest)((Object)this.firstRequest.toBuilder().exclusiveStartKey(lastSuccessfulPage.lastEvaluatedKey()).build()));
        }
        return new QueryPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super QueryResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class QueryResponseFetcher
    implements AsyncPageFetcher<QueryResponse> {
        private QueryResponseFetcher() {
        }

        public boolean hasNextPage(QueryResponse previousPage) {
            return previousPage.lastEvaluatedKey() != null && !SdkAutoConstructList.class.isInstance(previousPage.lastEvaluatedKey()) && !SdkAutoConstructMap.class.isInstance(previousPage.lastEvaluatedKey());
        }

        public CompletableFuture<QueryResponse> nextPage(QueryResponse previousPage) {
            if (previousPage == null) {
                return QueryPublisher.this.client.query(QueryPublisher.this.firstRequest);
            }
            return QueryPublisher.this.client.query((QueryRequest)((Object)QueryPublisher.this.firstRequest.toBuilder().exclusiveStartKey(previousPage.lastEvaluatedKey()).build()));
        }
    }
}

