/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.transform.AutoScalingPolicyDescriptionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the properties of the scaling policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutoScalingPolicyDescription implements StructuredPojo,
        ToCopyableBuilder<AutoScalingPolicyDescription.Builder, AutoScalingPolicyDescription> {
    private final String policyName;

    private final AutoScalingTargetTrackingScalingPolicyConfigurationDescription targetTrackingScalingPolicyConfiguration;

    private AutoScalingPolicyDescription(BuilderImpl builder) {
        this.policyName = builder.policyName;
        this.targetTrackingScalingPolicyConfiguration = builder.targetTrackingScalingPolicyConfiguration;
    }

    /**
     * <p>
     * The name of the scaling policy.
     * </p>
     * 
     * @return The name of the scaling policy.
     */
    public String policyName() {
        return policyName;
    }

    /**
     * <p>
     * Represents a target tracking scaling policy configuration.
     * </p>
     * 
     * @return Represents a target tracking scaling policy configuration.
     */
    public AutoScalingTargetTrackingScalingPolicyConfigurationDescription targetTrackingScalingPolicyConfiguration() {
        return targetTrackingScalingPolicyConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(policyName());
        hashCode = 31 * hashCode + Objects.hashCode(targetTrackingScalingPolicyConfiguration());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoScalingPolicyDescription)) {
            return false;
        }
        AutoScalingPolicyDescription other = (AutoScalingPolicyDescription) obj;
        return Objects.equals(policyName(), other.policyName())
                && Objects.equals(targetTrackingScalingPolicyConfiguration(), other.targetTrackingScalingPolicyConfiguration());
    }

    @Override
    public String toString() {
        return ToString.builder("AutoScalingPolicyDescription").add("PolicyName", policyName())
                .add("TargetTrackingScalingPolicyConfiguration", targetTrackingScalingPolicyConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PolicyName":
            return Optional.ofNullable(clazz.cast(policyName()));
        case "TargetTrackingScalingPolicyConfiguration":
            return Optional.ofNullable(clazz.cast(targetTrackingScalingPolicyConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AutoScalingPolicyDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, AutoScalingPolicyDescription> {
        /**
         * <p>
         * The name of the scaling policy.
         * </p>
         * 
         * @param policyName
         *        The name of the scaling policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyName(String policyName);

        /**
         * <p>
         * Represents a target tracking scaling policy configuration.
         * </p>
         * 
         * @param targetTrackingScalingPolicyConfiguration
         *        Represents a target tracking scaling policy configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetTrackingScalingPolicyConfiguration(
                AutoScalingTargetTrackingScalingPolicyConfigurationDescription targetTrackingScalingPolicyConfiguration);

        /**
         * <p>
         * Represents a target tracking scaling policy configuration.
         * </p>
         * This is a convenience that creates an instance of the
         * {@link AutoScalingTargetTrackingScalingPolicyConfigurationDescription.Builder} avoiding the need to create
         * one manually via {@link AutoScalingTargetTrackingScalingPolicyConfigurationDescription#builder()}.
         *
         * When the {@link Consumer} completes,
         * {@link AutoScalingTargetTrackingScalingPolicyConfigurationDescription.Builder#build()} is called immediately
         * and its result is passed to
         * {@link #targetTrackingScalingPolicyConfiguration(AutoScalingTargetTrackingScalingPolicyConfigurationDescription)}
         * .
         * 
         * @param targetTrackingScalingPolicyConfiguration
         *        a consumer that will call methods on
         *        {@link AutoScalingTargetTrackingScalingPolicyConfigurationDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetTrackingScalingPolicyConfiguration(AutoScalingTargetTrackingScalingPolicyConfigurationDescription)
         */
        default Builder targetTrackingScalingPolicyConfiguration(
                Consumer<AutoScalingTargetTrackingScalingPolicyConfigurationDescription.Builder> targetTrackingScalingPolicyConfiguration) {
            return targetTrackingScalingPolicyConfiguration(AutoScalingTargetTrackingScalingPolicyConfigurationDescription
                    .builder().applyMutation(targetTrackingScalingPolicyConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String policyName;

        private AutoScalingTargetTrackingScalingPolicyConfigurationDescription targetTrackingScalingPolicyConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoScalingPolicyDescription model) {
            policyName(model.policyName);
            targetTrackingScalingPolicyConfiguration(model.targetTrackingScalingPolicyConfiguration);
        }

        public final String getPolicyName() {
            return policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        public final AutoScalingTargetTrackingScalingPolicyConfigurationDescription.Builder getTargetTrackingScalingPolicyConfiguration() {
            return targetTrackingScalingPolicyConfiguration != null ? targetTrackingScalingPolicyConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder targetTrackingScalingPolicyConfiguration(
                AutoScalingTargetTrackingScalingPolicyConfigurationDescription targetTrackingScalingPolicyConfiguration) {
            this.targetTrackingScalingPolicyConfiguration = targetTrackingScalingPolicyConfiguration;
            return this;
        }

        public final void setTargetTrackingScalingPolicyConfiguration(
                AutoScalingTargetTrackingScalingPolicyConfigurationDescription.BuilderImpl targetTrackingScalingPolicyConfiguration) {
            this.targetTrackingScalingPolicyConfiguration = targetTrackingScalingPolicyConfiguration != null ? targetTrackingScalingPolicyConfiguration
                    .build() : null;
        }

        @Override
        public AutoScalingPolicyDescription build() {
            return new AutoScalingPolicyDescription(this);
        }
    }
}
