/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.transform.AutoScalingTargetTrackingScalingPolicyConfigurationUpdateMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the settings of a target tracking scaling policy that will be modified.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutoScalingTargetTrackingScalingPolicyConfigurationUpdate
        implements
        StructuredPojo,
        ToCopyableBuilder<AutoScalingTargetTrackingScalingPolicyConfigurationUpdate.Builder, AutoScalingTargetTrackingScalingPolicyConfigurationUpdate> {
    private final Boolean disableScaleIn;

    private final Integer scaleInCooldown;

    private final Integer scaleOutCooldown;

    private final Double targetValue;

    private AutoScalingTargetTrackingScalingPolicyConfigurationUpdate(BuilderImpl builder) {
        this.disableScaleIn = builder.disableScaleIn;
        this.scaleInCooldown = builder.scaleInCooldown;
        this.scaleOutCooldown = builder.scaleOutCooldown;
        this.targetValue = builder.targetValue;
    }

    /**
     * <p>
     * Indicates whether scale in by the target tracking policy is disabled. If the value is true, scale in is disabled
     * and the target tracking policy won't remove capacity from the scalable resource. Otherwise, scale in is enabled
     * and the target tracking policy can remove capacity from the scalable resource. The default value is false.
     * </p>
     * 
     * @return Indicates whether scale in by the target tracking policy is disabled. If the value is true, scale in is
     *         disabled and the target tracking policy won't remove capacity from the scalable resource. Otherwise,
     *         scale in is enabled and the target tracking policy can remove capacity from the scalable resource. The
     *         default value is false.
     */
    public Boolean disableScaleIn() {
        return disableScaleIn;
    }

    /**
     * <p>
     * The amount of time, in seconds, after a scale in activity completes before another scale in activity can start.
     * The cooldown period is used to block subsequent scale in requests until it has expired. You should scale in
     * conservatively to protect your application's availability. However, if another alarm triggers a scale out policy
     * during the cooldown period after a scale-in, application autoscaling scales out your scalable target immediately.
     * </p>
     * 
     * @return The amount of time, in seconds, after a scale in activity completes before another scale in activity can
     *         start. The cooldown period is used to block subsequent scale in requests until it has expired. You should
     *         scale in conservatively to protect your application's availability. However, if another alarm triggers a
     *         scale out policy during the cooldown period after a scale-in, application autoscaling scales out your
     *         scalable target immediately.
     */
    public Integer scaleInCooldown() {
        return scaleInCooldown;
    }

    /**
     * <p>
     * The amount of time, in seconds, after a scale out activity completes before another scale out activity can start.
     * While the cooldown period is in effect, the capacity that has been added by the previous scale out event that
     * initiated the cooldown is calculated as part of the desired capacity for the next scale out. You should
     * continuously (but not excessively) scale out.
     * </p>
     * 
     * @return The amount of time, in seconds, after a scale out activity completes before another scale out activity
     *         can start. While the cooldown period is in effect, the capacity that has been added by the previous scale
     *         out event that initiated the cooldown is calculated as part of the desired capacity for the next scale
     *         out. You should continuously (but not excessively) scale out.
     */
    public Integer scaleOutCooldown() {
        return scaleOutCooldown;
    }

    /**
     * <p>
     * The target value for the metric. The range is 8.515920e-109 to 1.174271e+108 (Base 10) or 2e-360 to 2e360 (Base
     * 2).
     * </p>
     * 
     * @return The target value for the metric. The range is 8.515920e-109 to 1.174271e+108 (Base 10) or 2e-360 to 2e360
     *         (Base 2).
     */
    public Double targetValue() {
        return targetValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(disableScaleIn());
        hashCode = 31 * hashCode + Objects.hashCode(scaleInCooldown());
        hashCode = 31 * hashCode + Objects.hashCode(scaleOutCooldown());
        hashCode = 31 * hashCode + Objects.hashCode(targetValue());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoScalingTargetTrackingScalingPolicyConfigurationUpdate)) {
            return false;
        }
        AutoScalingTargetTrackingScalingPolicyConfigurationUpdate other = (AutoScalingTargetTrackingScalingPolicyConfigurationUpdate) obj;
        return Objects.equals(disableScaleIn(), other.disableScaleIn())
                && Objects.equals(scaleInCooldown(), other.scaleInCooldown())
                && Objects.equals(scaleOutCooldown(), other.scaleOutCooldown())
                && Objects.equals(targetValue(), other.targetValue());
    }

    @Override
    public String toString() {
        return ToString.builder("AutoScalingTargetTrackingScalingPolicyConfigurationUpdate")
                .add("DisableScaleIn", disableScaleIn()).add("ScaleInCooldown", scaleInCooldown())
                .add("ScaleOutCooldown", scaleOutCooldown()).add("TargetValue", targetValue()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DisableScaleIn":
            return Optional.ofNullable(clazz.cast(disableScaleIn()));
        case "ScaleInCooldown":
            return Optional.ofNullable(clazz.cast(scaleInCooldown()));
        case "ScaleOutCooldown":
            return Optional.ofNullable(clazz.cast(scaleOutCooldown()));
        case "TargetValue":
            return Optional.ofNullable(clazz.cast(targetValue()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AutoScalingTargetTrackingScalingPolicyConfigurationUpdateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, AutoScalingTargetTrackingScalingPolicyConfigurationUpdate> {
        /**
         * <p>
         * Indicates whether scale in by the target tracking policy is disabled. If the value is true, scale in is
         * disabled and the target tracking policy won't remove capacity from the scalable resource. Otherwise, scale in
         * is enabled and the target tracking policy can remove capacity from the scalable resource. The default value
         * is false.
         * </p>
         * 
         * @param disableScaleIn
         *        Indicates whether scale in by the target tracking policy is disabled. If the value is true, scale in
         *        is disabled and the target tracking policy won't remove capacity from the scalable resource.
         *        Otherwise, scale in is enabled and the target tracking policy can remove capacity from the scalable
         *        resource. The default value is false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disableScaleIn(Boolean disableScaleIn);

        /**
         * <p>
         * The amount of time, in seconds, after a scale in activity completes before another scale in activity can
         * start. The cooldown period is used to block subsequent scale in requests until it has expired. You should
         * scale in conservatively to protect your application's availability. However, if another alarm triggers a
         * scale out policy during the cooldown period after a scale-in, application autoscaling scales out your
         * scalable target immediately.
         * </p>
         * 
         * @param scaleInCooldown
         *        The amount of time, in seconds, after a scale in activity completes before another scale in activity
         *        can start. The cooldown period is used to block subsequent scale in requests until it has expired. You
         *        should scale in conservatively to protect your application's availability. However, if another alarm
         *        triggers a scale out policy during the cooldown period after a scale-in, application autoscaling
         *        scales out your scalable target immediately.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scaleInCooldown(Integer scaleInCooldown);

        /**
         * <p>
         * The amount of time, in seconds, after a scale out activity completes before another scale out activity can
         * start. While the cooldown period is in effect, the capacity that has been added by the previous scale out
         * event that initiated the cooldown is calculated as part of the desired capacity for the next scale out. You
         * should continuously (but not excessively) scale out.
         * </p>
         * 
         * @param scaleOutCooldown
         *        The amount of time, in seconds, after a scale out activity completes before another scale out activity
         *        can start. While the cooldown period is in effect, the capacity that has been added by the previous
         *        scale out event that initiated the cooldown is calculated as part of the desired capacity for the next
         *        scale out. You should continuously (but not excessively) scale out.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scaleOutCooldown(Integer scaleOutCooldown);

        /**
         * <p>
         * The target value for the metric. The range is 8.515920e-109 to 1.174271e+108 (Base 10) or 2e-360 to 2e360
         * (Base 2).
         * </p>
         * 
         * @param targetValue
         *        The target value for the metric. The range is 8.515920e-109 to 1.174271e+108 (Base 10) or 2e-360 to
         *        2e360 (Base 2).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetValue(Double targetValue);
    }

    static final class BuilderImpl implements Builder {
        private Boolean disableScaleIn;

        private Integer scaleInCooldown;

        private Integer scaleOutCooldown;

        private Double targetValue;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoScalingTargetTrackingScalingPolicyConfigurationUpdate model) {
            disableScaleIn(model.disableScaleIn);
            scaleInCooldown(model.scaleInCooldown);
            scaleOutCooldown(model.scaleOutCooldown);
            targetValue(model.targetValue);
        }

        public final Boolean getDisableScaleIn() {
            return disableScaleIn;
        }

        @Override
        public final Builder disableScaleIn(Boolean disableScaleIn) {
            this.disableScaleIn = disableScaleIn;
            return this;
        }

        public final void setDisableScaleIn(Boolean disableScaleIn) {
            this.disableScaleIn = disableScaleIn;
        }

        public final Integer getScaleInCooldown() {
            return scaleInCooldown;
        }

        @Override
        public final Builder scaleInCooldown(Integer scaleInCooldown) {
            this.scaleInCooldown = scaleInCooldown;
            return this;
        }

        public final void setScaleInCooldown(Integer scaleInCooldown) {
            this.scaleInCooldown = scaleInCooldown;
        }

        public final Integer getScaleOutCooldown() {
            return scaleOutCooldown;
        }

        @Override
        public final Builder scaleOutCooldown(Integer scaleOutCooldown) {
            this.scaleOutCooldown = scaleOutCooldown;
            return this;
        }

        public final void setScaleOutCooldown(Integer scaleOutCooldown) {
            this.scaleOutCooldown = scaleOutCooldown;
        }

        public final Double getTargetValue() {
            return targetValue;
        }

        @Override
        public final Builder targetValue(Double targetValue) {
            this.targetValue = targetValue;
            return this;
        }

        public final void setTargetValue(Double targetValue) {
            this.targetValue = targetValue;
        }

        @Override
        public AutoScalingTargetTrackingScalingPolicyConfigurationUpdate build() {
            return new AutoScalingTargetTrackingScalingPolicyConfigurationUpdate(this);
        }
    }
}
