/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.transform.BackupSummaryMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details for the backup.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BackupSummary implements StructuredPojo, ToCopyableBuilder<BackupSummary.Builder, BackupSummary> {
    private final String tableName;

    private final String tableId;

    private final String tableArn;

    private final String backupArn;

    private final String backupName;

    private final Instant backupCreationDateTime;

    private final Instant backupExpiryDateTime;

    private final String backupStatus;

    private final String backupType;

    private final Long backupSizeBytes;

    private BackupSummary(BuilderImpl builder) {
        this.tableName = builder.tableName;
        this.tableId = builder.tableId;
        this.tableArn = builder.tableArn;
        this.backupArn = builder.backupArn;
        this.backupName = builder.backupName;
        this.backupCreationDateTime = builder.backupCreationDateTime;
        this.backupExpiryDateTime = builder.backupExpiryDateTime;
        this.backupStatus = builder.backupStatus;
        this.backupType = builder.backupType;
        this.backupSizeBytes = builder.backupSizeBytes;
    }

    /**
     * <p>
     * Name of the table.
     * </p>
     * 
     * @return Name of the table.
     */
    public String tableName() {
        return tableName;
    }

    /**
     * <p>
     * Unique identifier for the table.
     * </p>
     * 
     * @return Unique identifier for the table.
     */
    public String tableId() {
        return tableId;
    }

    /**
     * <p>
     * ARN associated with the table.
     * </p>
     * 
     * @return ARN associated with the table.
     */
    public String tableArn() {
        return tableArn;
    }

    /**
     * <p>
     * ARN associated with the backup.
     * </p>
     * 
     * @return ARN associated with the backup.
     */
    public String backupArn() {
        return backupArn;
    }

    /**
     * <p>
     * Name of the specified backup.
     * </p>
     * 
     * @return Name of the specified backup.
     */
    public String backupName() {
        return backupName;
    }

    /**
     * <p>
     * Time at which the backup was created.
     * </p>
     * 
     * @return Time at which the backup was created.
     */
    public Instant backupCreationDateTime() {
        return backupCreationDateTime;
    }

    /**
     * <p>
     * Time at which the automatic on-demand backup created by DynamoDB will expire. This <code>SYSTEM</code> on-demand
     * backup expires automatically 35 days after its creation.
     * </p>
     * 
     * @return Time at which the automatic on-demand backup created by DynamoDB will expire. This <code>SYSTEM</code>
     *         on-demand backup expires automatically 35 days after its creation.
     */
    public Instant backupExpiryDateTime() {
        return backupExpiryDateTime;
    }

    /**
     * <p>
     * Backup can be in one of the following states: CREATING, ACTIVE, DELETED.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #backupStatus} will
     * return {@link BackupStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #backupStatusAsString}.
     * </p>
     * 
     * @return Backup can be in one of the following states: CREATING, ACTIVE, DELETED.
     * @see BackupStatus
     */
    public BackupStatus backupStatus() {
        return BackupStatus.fromValue(backupStatus);
    }

    /**
     * <p>
     * Backup can be in one of the following states: CREATING, ACTIVE, DELETED.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #backupStatus} will
     * return {@link BackupStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #backupStatusAsString}.
     * </p>
     * 
     * @return Backup can be in one of the following states: CREATING, ACTIVE, DELETED.
     * @see BackupStatus
     */
    public String backupStatusAsString() {
        return backupStatus;
    }

    /**
     * <p>
     * BackupType:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>USER</code> - On-demand backup created by you.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SYSTEM</code> - On-demand backup automatically created by DynamoDB.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #backupType} will
     * return {@link BackupType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #backupTypeAsString}.
     * </p>
     * 
     * @return BackupType:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>USER</code> - On-demand backup created by you.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SYSTEM</code> - On-demand backup automatically created by DynamoDB.
     *         </p>
     *         </li>
     * @see BackupType
     */
    public BackupType backupType() {
        return BackupType.fromValue(backupType);
    }

    /**
     * <p>
     * BackupType:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>USER</code> - On-demand backup created by you.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SYSTEM</code> - On-demand backup automatically created by DynamoDB.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #backupType} will
     * return {@link BackupType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #backupTypeAsString}.
     * </p>
     * 
     * @return BackupType:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>USER</code> - On-demand backup created by you.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SYSTEM</code> - On-demand backup automatically created by DynamoDB.
     *         </p>
     *         </li>
     * @see BackupType
     */
    public String backupTypeAsString() {
        return backupType;
    }

    /**
     * <p>
     * Size of the backup in bytes.
     * </p>
     * 
     * @return Size of the backup in bytes.
     */
    public Long backupSizeBytes() {
        return backupSizeBytes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        hashCode = 31 * hashCode + Objects.hashCode(tableId());
        hashCode = 31 * hashCode + Objects.hashCode(tableArn());
        hashCode = 31 * hashCode + Objects.hashCode(backupArn());
        hashCode = 31 * hashCode + Objects.hashCode(backupName());
        hashCode = 31 * hashCode + Objects.hashCode(backupCreationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(backupExpiryDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(backupStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(backupTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(backupSizeBytes());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BackupSummary)) {
            return false;
        }
        BackupSummary other = (BackupSummary) obj;
        return Objects.equals(tableName(), other.tableName()) && Objects.equals(tableId(), other.tableId())
                && Objects.equals(tableArn(), other.tableArn()) && Objects.equals(backupArn(), other.backupArn())
                && Objects.equals(backupName(), other.backupName())
                && Objects.equals(backupCreationDateTime(), other.backupCreationDateTime())
                && Objects.equals(backupExpiryDateTime(), other.backupExpiryDateTime())
                && Objects.equals(backupStatusAsString(), other.backupStatusAsString())
                && Objects.equals(backupTypeAsString(), other.backupTypeAsString())
                && Objects.equals(backupSizeBytes(), other.backupSizeBytes());
    }

    @Override
    public String toString() {
        return ToString.builder("BackupSummary").add("TableName", tableName()).add("TableId", tableId())
                .add("TableArn", tableArn()).add("BackupArn", backupArn()).add("BackupName", backupName())
                .add("BackupCreationDateTime", backupCreationDateTime()).add("BackupExpiryDateTime", backupExpiryDateTime())
                .add("BackupStatus", backupStatusAsString()).add("BackupType", backupTypeAsString())
                .add("BackupSizeBytes", backupSizeBytes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        case "TableId":
            return Optional.ofNullable(clazz.cast(tableId()));
        case "TableArn":
            return Optional.ofNullable(clazz.cast(tableArn()));
        case "BackupArn":
            return Optional.ofNullable(clazz.cast(backupArn()));
        case "BackupName":
            return Optional.ofNullable(clazz.cast(backupName()));
        case "BackupCreationDateTime":
            return Optional.ofNullable(clazz.cast(backupCreationDateTime()));
        case "BackupExpiryDateTime":
            return Optional.ofNullable(clazz.cast(backupExpiryDateTime()));
        case "BackupStatus":
            return Optional.ofNullable(clazz.cast(backupStatusAsString()));
        case "BackupType":
            return Optional.ofNullable(clazz.cast(backupTypeAsString()));
        case "BackupSizeBytes":
            return Optional.ofNullable(clazz.cast(backupSizeBytes()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BackupSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, BackupSummary> {
        /**
         * <p>
         * Name of the table.
         * </p>
         * 
         * @param tableName
         *        Name of the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * Unique identifier for the table.
         * </p>
         * 
         * @param tableId
         *        Unique identifier for the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableId(String tableId);

        /**
         * <p>
         * ARN associated with the table.
         * </p>
         * 
         * @param tableArn
         *        ARN associated with the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableArn(String tableArn);

        /**
         * <p>
         * ARN associated with the backup.
         * </p>
         * 
         * @param backupArn
         *        ARN associated with the backup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupArn(String backupArn);

        /**
         * <p>
         * Name of the specified backup.
         * </p>
         * 
         * @param backupName
         *        Name of the specified backup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupName(String backupName);

        /**
         * <p>
         * Time at which the backup was created.
         * </p>
         * 
         * @param backupCreationDateTime
         *        Time at which the backup was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupCreationDateTime(Instant backupCreationDateTime);

        /**
         * <p>
         * Time at which the automatic on-demand backup created by DynamoDB will expire. This <code>SYSTEM</code>
         * on-demand backup expires automatically 35 days after its creation.
         * </p>
         * 
         * @param backupExpiryDateTime
         *        Time at which the automatic on-demand backup created by DynamoDB will expire. This <code>SYSTEM</code>
         *        on-demand backup expires automatically 35 days after its creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupExpiryDateTime(Instant backupExpiryDateTime);

        /**
         * <p>
         * Backup can be in one of the following states: CREATING, ACTIVE, DELETED.
         * </p>
         * 
         * @param backupStatus
         *        Backup can be in one of the following states: CREATING, ACTIVE, DELETED.
         * @see BackupStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BackupStatus
         */
        Builder backupStatus(String backupStatus);

        /**
         * <p>
         * Backup can be in one of the following states: CREATING, ACTIVE, DELETED.
         * </p>
         * 
         * @param backupStatus
         *        Backup can be in one of the following states: CREATING, ACTIVE, DELETED.
         * @see BackupStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BackupStatus
         */
        Builder backupStatus(BackupStatus backupStatus);

        /**
         * <p>
         * BackupType:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>USER</code> - On-demand backup created by you.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SYSTEM</code> - On-demand backup automatically created by DynamoDB.
         * </p>
         * </li>
         * </ul>
         * 
         * @param backupType
         *        BackupType:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>USER</code> - On-demand backup created by you.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SYSTEM</code> - On-demand backup automatically created by DynamoDB.
         *        </p>
         *        </li>
         * @see BackupType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BackupType
         */
        Builder backupType(String backupType);

        /**
         * <p>
         * BackupType:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>USER</code> - On-demand backup created by you.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SYSTEM</code> - On-demand backup automatically created by DynamoDB.
         * </p>
         * </li>
         * </ul>
         * 
         * @param backupType
         *        BackupType:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>USER</code> - On-demand backup created by you.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SYSTEM</code> - On-demand backup automatically created by DynamoDB.
         *        </p>
         *        </li>
         * @see BackupType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BackupType
         */
        Builder backupType(BackupType backupType);

        /**
         * <p>
         * Size of the backup in bytes.
         * </p>
         * 
         * @param backupSizeBytes
         *        Size of the backup in bytes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupSizeBytes(Long backupSizeBytes);
    }

    static final class BuilderImpl implements Builder {
        private String tableName;

        private String tableId;

        private String tableArn;

        private String backupArn;

        private String backupName;

        private Instant backupCreationDateTime;

        private Instant backupExpiryDateTime;

        private String backupStatus;

        private String backupType;

        private Long backupSizeBytes;

        private BuilderImpl() {
        }

        private BuilderImpl(BackupSummary model) {
            tableName(model.tableName);
            tableId(model.tableId);
            tableArn(model.tableArn);
            backupArn(model.backupArn);
            backupName(model.backupName);
            backupCreationDateTime(model.backupCreationDateTime);
            backupExpiryDateTime(model.backupExpiryDateTime);
            backupStatus(model.backupStatus);
            backupType(model.backupType);
            backupSizeBytes(model.backupSizeBytes);
        }

        public final String getTableName() {
            return tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final String getTableId() {
            return tableId;
        }

        @Override
        public final Builder tableId(String tableId) {
            this.tableId = tableId;
            return this;
        }

        public final void setTableId(String tableId) {
            this.tableId = tableId;
        }

        public final String getTableArn() {
            return tableArn;
        }

        @Override
        public final Builder tableArn(String tableArn) {
            this.tableArn = tableArn;
            return this;
        }

        public final void setTableArn(String tableArn) {
            this.tableArn = tableArn;
        }

        public final String getBackupArn() {
            return backupArn;
        }

        @Override
        public final Builder backupArn(String backupArn) {
            this.backupArn = backupArn;
            return this;
        }

        public final void setBackupArn(String backupArn) {
            this.backupArn = backupArn;
        }

        public final String getBackupName() {
            return backupName;
        }

        @Override
        public final Builder backupName(String backupName) {
            this.backupName = backupName;
            return this;
        }

        public final void setBackupName(String backupName) {
            this.backupName = backupName;
        }

        public final Instant getBackupCreationDateTime() {
            return backupCreationDateTime;
        }

        @Override
        public final Builder backupCreationDateTime(Instant backupCreationDateTime) {
            this.backupCreationDateTime = backupCreationDateTime;
            return this;
        }

        public final void setBackupCreationDateTime(Instant backupCreationDateTime) {
            this.backupCreationDateTime = backupCreationDateTime;
        }

        public final Instant getBackupExpiryDateTime() {
            return backupExpiryDateTime;
        }

        @Override
        public final Builder backupExpiryDateTime(Instant backupExpiryDateTime) {
            this.backupExpiryDateTime = backupExpiryDateTime;
            return this;
        }

        public final void setBackupExpiryDateTime(Instant backupExpiryDateTime) {
            this.backupExpiryDateTime = backupExpiryDateTime;
        }

        public final String getBackupStatus() {
            return backupStatus;
        }

        @Override
        public final Builder backupStatus(String backupStatus) {
            this.backupStatus = backupStatus;
            return this;
        }

        @Override
        public final Builder backupStatus(BackupStatus backupStatus) {
            this.backupStatus(backupStatus.toString());
            return this;
        }

        public final void setBackupStatus(String backupStatus) {
            this.backupStatus = backupStatus;
        }

        public final String getBackupType() {
            return backupType;
        }

        @Override
        public final Builder backupType(String backupType) {
            this.backupType = backupType;
            return this;
        }

        @Override
        public final Builder backupType(BackupType backupType) {
            this.backupType(backupType.toString());
            return this;
        }

        public final void setBackupType(String backupType) {
            this.backupType = backupType;
        }

        public final Long getBackupSizeBytes() {
            return backupSizeBytes;
        }

        @Override
        public final Builder backupSizeBytes(Long backupSizeBytes) {
            this.backupSizeBytes = backupSizeBytes;
            return this;
        }

        public final void setBackupSizeBytes(Long backupSizeBytes) {
            this.backupSizeBytes = backupSizeBytes;
        }

        @Override
        public BackupSummary build() {
            return new BackupSummary(this);
        }
    }
}
