/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.transform.DeleteGlobalSecondaryIndexActionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a global secondary index to be deleted from an existing table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteGlobalSecondaryIndexAction implements StructuredPojo,
        ToCopyableBuilder<DeleteGlobalSecondaryIndexAction.Builder, DeleteGlobalSecondaryIndexAction> {
    private final String indexName;

    private DeleteGlobalSecondaryIndexAction(BuilderImpl builder) {
        this.indexName = builder.indexName;
    }

    /**
     * <p>
     * The name of the global secondary index to be deleted.
     * </p>
     * 
     * @return The name of the global secondary index to be deleted.
     */
    public String indexName() {
        return indexName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(indexName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteGlobalSecondaryIndexAction)) {
            return false;
        }
        DeleteGlobalSecondaryIndexAction other = (DeleteGlobalSecondaryIndexAction) obj;
        return Objects.equals(indexName(), other.indexName());
    }

    @Override
    public String toString() {
        return ToString.builder("DeleteGlobalSecondaryIndexAction").add("IndexName", indexName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IndexName":
            return Optional.ofNullable(clazz.cast(indexName()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DeleteGlobalSecondaryIndexActionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, DeleteGlobalSecondaryIndexAction> {
        /**
         * <p>
         * The name of the global secondary index to be deleted.
         * </p>
         * 
         * @param indexName
         *        The name of the global secondary index to be deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexName(String indexName);
    }

    static final class BuilderImpl implements Builder {
        private String indexName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteGlobalSecondaryIndexAction model) {
            indexName(model.indexName);
        }

        public final String getIndexName() {
            return indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        @Override
        public DeleteGlobalSecondaryIndexAction build() {
            return new DeleteGlobalSecondaryIndexAction(this);
        }
    }
}
