/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.transform.EndpointMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class Endpoint implements StructuredPojo, ToCopyableBuilder<Endpoint.Builder, Endpoint> {
    private final String address;

    private final Long cachePeriodInMinutes;

    private Endpoint(BuilderImpl builder) {
        this.address = builder.address;
        this.cachePeriodInMinutes = builder.cachePeriodInMinutes;
    }

    /**
     * Returns the value of the Address property for this object.
     * 
     * @return The value of the Address property for this object.
     */
    public String address() {
        return address;
    }

    /**
     * Returns the value of the CachePeriodInMinutes property for this object.
     * 
     * @return The value of the CachePeriodInMinutes property for this object.
     */
    public Long cachePeriodInMinutes() {
        return cachePeriodInMinutes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(address());
        hashCode = 31 * hashCode + Objects.hashCode(cachePeriodInMinutes());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Endpoint)) {
            return false;
        }
        Endpoint other = (Endpoint) obj;
        return Objects.equals(address(), other.address()) && Objects.equals(cachePeriodInMinutes(), other.cachePeriodInMinutes());
    }

    @Override
    public String toString() {
        return ToString.builder("Endpoint").add("Address", address()).add("CachePeriodInMinutes", cachePeriodInMinutes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Address":
            return Optional.ofNullable(clazz.cast(address()));
        case "CachePeriodInMinutes":
            return Optional.ofNullable(clazz.cast(cachePeriodInMinutes()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EndpointMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Endpoint> {
        /**
         * Sets the value of the Address property for this object.
         *
         * @param address
         *        The new value for the Address property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder address(String address);

        /**
         * Sets the value of the CachePeriodInMinutes property for this object.
         *
         * @param cachePeriodInMinutes
         *        The new value for the CachePeriodInMinutes property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cachePeriodInMinutes(Long cachePeriodInMinutes);
    }

    static final class BuilderImpl implements Builder {
        private String address;

        private Long cachePeriodInMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(Endpoint model) {
            address(model.address);
            cachePeriodInMinutes(model.cachePeriodInMinutes);
        }

        public final String getAddress() {
            return address;
        }

        @Override
        public final Builder address(String address) {
            this.address = address;
            return this;
        }

        public final void setAddress(String address) {
            this.address = address;
        }

        public final Long getCachePeriodInMinutes() {
            return cachePeriodInMinutes;
        }

        @Override
        public final Builder cachePeriodInMinutes(Long cachePeriodInMinutes) {
            this.cachePeriodInMinutes = cachePeriodInMinutes;
            return this;
        }

        public final void setCachePeriodInMinutes(Long cachePeriodInMinutes) {
            this.cachePeriodInMinutes = cachePeriodInMinutes;
        }

        @Override
        public Endpoint build() {
            return new Endpoint(this);
        }
    }
}
