/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.transform.ReplicaGlobalSecondaryIndexSettingsUpdateMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the settings of a global secondary index for a global table that will be modified.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReplicaGlobalSecondaryIndexSettingsUpdate implements StructuredPojo,
        ToCopyableBuilder<ReplicaGlobalSecondaryIndexSettingsUpdate.Builder, ReplicaGlobalSecondaryIndexSettingsUpdate> {
    private final String indexName;

    private final Long provisionedReadCapacityUnits;

    private final AutoScalingSettingsUpdate provisionedReadCapacityAutoScalingSettingsUpdate;

    private ReplicaGlobalSecondaryIndexSettingsUpdate(BuilderImpl builder) {
        this.indexName = builder.indexName;
        this.provisionedReadCapacityUnits = builder.provisionedReadCapacityUnits;
        this.provisionedReadCapacityAutoScalingSettingsUpdate = builder.provisionedReadCapacityAutoScalingSettingsUpdate;
    }

    /**
     * <p>
     * The name of the global secondary index. The name must be unique among all other indexes on this table.
     * </p>
     * 
     * @return The name of the global secondary index. The name must be unique among all other indexes on this table.
     */
    public String indexName() {
        return indexName;
    }

    /**
     * <p>
     * The maximum number of strongly consistent reads consumed per second before DynamoDB returns a
     * <code>ThrottlingException</code>.
     * </p>
     * 
     * @return The maximum number of strongly consistent reads consumed per second before DynamoDB returns a
     *         <code>ThrottlingException</code>.
     */
    public Long provisionedReadCapacityUnits() {
        return provisionedReadCapacityUnits;
    }

    /**
     * <p>
     * Autoscaling settings for managing a global secondary index replica's read capacity units.
     * </p>
     * 
     * @return Autoscaling settings for managing a global secondary index replica's read capacity units.
     */
    public AutoScalingSettingsUpdate provisionedReadCapacityAutoScalingSettingsUpdate() {
        return provisionedReadCapacityAutoScalingSettingsUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(indexName());
        hashCode = 31 * hashCode + Objects.hashCode(provisionedReadCapacityUnits());
        hashCode = 31 * hashCode + Objects.hashCode(provisionedReadCapacityAutoScalingSettingsUpdate());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicaGlobalSecondaryIndexSettingsUpdate)) {
            return false;
        }
        ReplicaGlobalSecondaryIndexSettingsUpdate other = (ReplicaGlobalSecondaryIndexSettingsUpdate) obj;
        return Objects.equals(indexName(), other.indexName())
                && Objects.equals(provisionedReadCapacityUnits(), other.provisionedReadCapacityUnits())
                && Objects.equals(provisionedReadCapacityAutoScalingSettingsUpdate(),
                        other.provisionedReadCapacityAutoScalingSettingsUpdate());
    }

    @Override
    public String toString() {
        return ToString.builder("ReplicaGlobalSecondaryIndexSettingsUpdate").add("IndexName", indexName())
                .add("ProvisionedReadCapacityUnits", provisionedReadCapacityUnits())
                .add("ProvisionedReadCapacityAutoScalingSettingsUpdate", provisionedReadCapacityAutoScalingSettingsUpdate())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IndexName":
            return Optional.ofNullable(clazz.cast(indexName()));
        case "ProvisionedReadCapacityUnits":
            return Optional.ofNullable(clazz.cast(provisionedReadCapacityUnits()));
        case "ProvisionedReadCapacityAutoScalingSettingsUpdate":
            return Optional.ofNullable(clazz.cast(provisionedReadCapacityAutoScalingSettingsUpdate()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ReplicaGlobalSecondaryIndexSettingsUpdateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ReplicaGlobalSecondaryIndexSettingsUpdate> {
        /**
         * <p>
         * The name of the global secondary index. The name must be unique among all other indexes on this table.
         * </p>
         * 
         * @param indexName
         *        The name of the global secondary index. The name must be unique among all other indexes on this table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexName(String indexName);

        /**
         * <p>
         * The maximum number of strongly consistent reads consumed per second before DynamoDB returns a
         * <code>ThrottlingException</code>.
         * </p>
         * 
         * @param provisionedReadCapacityUnits
         *        The maximum number of strongly consistent reads consumed per second before DynamoDB returns a
         *        <code>ThrottlingException</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedReadCapacityUnits(Long provisionedReadCapacityUnits);

        /**
         * <p>
         * Autoscaling settings for managing a global secondary index replica's read capacity units.
         * </p>
         * 
         * @param provisionedReadCapacityAutoScalingSettingsUpdate
         *        Autoscaling settings for managing a global secondary index replica's read capacity units.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedReadCapacityAutoScalingSettingsUpdate(
                AutoScalingSettingsUpdate provisionedReadCapacityAutoScalingSettingsUpdate);

        /**
         * <p>
         * Autoscaling settings for managing a global secondary index replica's read capacity units.
         * </p>
         * This is a convenience that creates an instance of the {@link AutoScalingSettingsUpdate.Builder} avoiding the
         * need to create one manually via {@link AutoScalingSettingsUpdate#builder()}.
         *
         * When the {@link Consumer} completes, {@link AutoScalingSettingsUpdate.Builder#build()} is called immediately
         * and its result is passed to
         * {@link #provisionedReadCapacityAutoScalingSettingsUpdate(AutoScalingSettingsUpdate)}.
         * 
         * @param provisionedReadCapacityAutoScalingSettingsUpdate
         *        a consumer that will call methods on {@link AutoScalingSettingsUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #provisionedReadCapacityAutoScalingSettingsUpdate(AutoScalingSettingsUpdate)
         */
        default Builder provisionedReadCapacityAutoScalingSettingsUpdate(
                Consumer<AutoScalingSettingsUpdate.Builder> provisionedReadCapacityAutoScalingSettingsUpdate) {
            return provisionedReadCapacityAutoScalingSettingsUpdate(AutoScalingSettingsUpdate.builder()
                    .applyMutation(provisionedReadCapacityAutoScalingSettingsUpdate).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String indexName;

        private Long provisionedReadCapacityUnits;

        private AutoScalingSettingsUpdate provisionedReadCapacityAutoScalingSettingsUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicaGlobalSecondaryIndexSettingsUpdate model) {
            indexName(model.indexName);
            provisionedReadCapacityUnits(model.provisionedReadCapacityUnits);
            provisionedReadCapacityAutoScalingSettingsUpdate(model.provisionedReadCapacityAutoScalingSettingsUpdate);
        }

        public final String getIndexName() {
            return indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        public final Long getProvisionedReadCapacityUnits() {
            return provisionedReadCapacityUnits;
        }

        @Override
        public final Builder provisionedReadCapacityUnits(Long provisionedReadCapacityUnits) {
            this.provisionedReadCapacityUnits = provisionedReadCapacityUnits;
            return this;
        }

        public final void setProvisionedReadCapacityUnits(Long provisionedReadCapacityUnits) {
            this.provisionedReadCapacityUnits = provisionedReadCapacityUnits;
        }

        public final AutoScalingSettingsUpdate.Builder getProvisionedReadCapacityAutoScalingSettingsUpdate() {
            return provisionedReadCapacityAutoScalingSettingsUpdate != null ? provisionedReadCapacityAutoScalingSettingsUpdate
                    .toBuilder() : null;
        }

        @Override
        public final Builder provisionedReadCapacityAutoScalingSettingsUpdate(
                AutoScalingSettingsUpdate provisionedReadCapacityAutoScalingSettingsUpdate) {
            this.provisionedReadCapacityAutoScalingSettingsUpdate = provisionedReadCapacityAutoScalingSettingsUpdate;
            return this;
        }

        public final void setProvisionedReadCapacityAutoScalingSettingsUpdate(
                AutoScalingSettingsUpdate.BuilderImpl provisionedReadCapacityAutoScalingSettingsUpdate) {
            this.provisionedReadCapacityAutoScalingSettingsUpdate = provisionedReadCapacityAutoScalingSettingsUpdate != null ? provisionedReadCapacityAutoScalingSettingsUpdate
                    .build() : null;
        }

        @Override
        public ReplicaGlobalSecondaryIndexSettingsUpdate build() {
            return new ReplicaGlobalSecondaryIndexSettingsUpdate(this);
        }
    }
}
