/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.dynamodb.transform.ReplicaSettingsUpdateMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the settings for a global table in a region that will be modified.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReplicaSettingsUpdate implements StructuredPojo,
        ToCopyableBuilder<ReplicaSettingsUpdate.Builder, ReplicaSettingsUpdate> {
    private final String regionName;

    private final Long replicaProvisionedReadCapacityUnits;

    private final AutoScalingSettingsUpdate replicaProvisionedReadCapacityAutoScalingSettingsUpdate;

    private final List<ReplicaGlobalSecondaryIndexSettingsUpdate> replicaGlobalSecondaryIndexSettingsUpdate;

    private ReplicaSettingsUpdate(BuilderImpl builder) {
        this.regionName = builder.regionName;
        this.replicaProvisionedReadCapacityUnits = builder.replicaProvisionedReadCapacityUnits;
        this.replicaProvisionedReadCapacityAutoScalingSettingsUpdate = builder.replicaProvisionedReadCapacityAutoScalingSettingsUpdate;
        this.replicaGlobalSecondaryIndexSettingsUpdate = builder.replicaGlobalSecondaryIndexSettingsUpdate;
    }

    /**
     * <p>
     * The region of the replica to be added.
     * </p>
     * 
     * @return The region of the replica to be added.
     */
    public String regionName() {
        return regionName;
    }

    /**
     * <p>
     * The maximum number of strongly consistent reads consumed per second before DynamoDB returns a
     * <code>ThrottlingException</code>. For more information, see <a href=
     * "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput"
     * >Specifying Read and Write Requirements</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * 
     * @return The maximum number of strongly consistent reads consumed per second before DynamoDB returns a
     *         <code>ThrottlingException</code>. For more information, see <a href=
     *         "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput"
     *         >Specifying Read and Write Requirements</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     */
    public Long replicaProvisionedReadCapacityUnits() {
        return replicaProvisionedReadCapacityUnits;
    }

    /**
     * <p>
     * Autoscaling settings for managing a global table replica's read capacity units.
     * </p>
     * 
     * @return Autoscaling settings for managing a global table replica's read capacity units.
     */
    public AutoScalingSettingsUpdate replicaProvisionedReadCapacityAutoScalingSettingsUpdate() {
        return replicaProvisionedReadCapacityAutoScalingSettingsUpdate;
    }

    /**
     * <p>
     * Represents the settings of a global secondary index for a global table that will be modified.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Represents the settings of a global secondary index for a global table that will be modified.
     */
    public List<ReplicaGlobalSecondaryIndexSettingsUpdate> replicaGlobalSecondaryIndexSettingsUpdate() {
        return replicaGlobalSecondaryIndexSettingsUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(regionName());
        hashCode = 31 * hashCode + Objects.hashCode(replicaProvisionedReadCapacityUnits());
        hashCode = 31 * hashCode + Objects.hashCode(replicaProvisionedReadCapacityAutoScalingSettingsUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(replicaGlobalSecondaryIndexSettingsUpdate());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicaSettingsUpdate)) {
            return false;
        }
        ReplicaSettingsUpdate other = (ReplicaSettingsUpdate) obj;
        return Objects.equals(regionName(), other.regionName())
                && Objects.equals(replicaProvisionedReadCapacityUnits(), other.replicaProvisionedReadCapacityUnits())
                && Objects.equals(replicaProvisionedReadCapacityAutoScalingSettingsUpdate(),
                        other.replicaProvisionedReadCapacityAutoScalingSettingsUpdate())
                && Objects.equals(replicaGlobalSecondaryIndexSettingsUpdate(), other.replicaGlobalSecondaryIndexSettingsUpdate());
    }

    @Override
    public String toString() {
        return ToString
                .builder("ReplicaSettingsUpdate")
                .add("RegionName", regionName())
                .add("ReplicaProvisionedReadCapacityUnits", replicaProvisionedReadCapacityUnits())
                .add("ReplicaProvisionedReadCapacityAutoScalingSettingsUpdate",
                        replicaProvisionedReadCapacityAutoScalingSettingsUpdate())
                .add("ReplicaGlobalSecondaryIndexSettingsUpdate", replicaGlobalSecondaryIndexSettingsUpdate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RegionName":
            return Optional.ofNullable(clazz.cast(regionName()));
        case "ReplicaProvisionedReadCapacityUnits":
            return Optional.ofNullable(clazz.cast(replicaProvisionedReadCapacityUnits()));
        case "ReplicaProvisionedReadCapacityAutoScalingSettingsUpdate":
            return Optional.ofNullable(clazz.cast(replicaProvisionedReadCapacityAutoScalingSettingsUpdate()));
        case "ReplicaGlobalSecondaryIndexSettingsUpdate":
            return Optional.ofNullable(clazz.cast(replicaGlobalSecondaryIndexSettingsUpdate()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ReplicaSettingsUpdateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ReplicaSettingsUpdate> {
        /**
         * <p>
         * The region of the replica to be added.
         * </p>
         * 
         * @param regionName
         *        The region of the replica to be added.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionName(String regionName);

        /**
         * <p>
         * The maximum number of strongly consistent reads consumed per second before DynamoDB returns a
         * <code>ThrottlingException</code>. For more information, see <a href=
         * "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput"
         * >Specifying Read and Write Requirements</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param replicaProvisionedReadCapacityUnits
         *        The maximum number of strongly consistent reads consumed per second before DynamoDB returns a
         *        <code>ThrottlingException</code>. For more information, see <a href=
         *        "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput"
         *        >Specifying Read and Write Requirements</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicaProvisionedReadCapacityUnits(Long replicaProvisionedReadCapacityUnits);

        /**
         * <p>
         * Autoscaling settings for managing a global table replica's read capacity units.
         * </p>
         * 
         * @param replicaProvisionedReadCapacityAutoScalingSettingsUpdate
         *        Autoscaling settings for managing a global table replica's read capacity units.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicaProvisionedReadCapacityAutoScalingSettingsUpdate(
                AutoScalingSettingsUpdate replicaProvisionedReadCapacityAutoScalingSettingsUpdate);

        /**
         * <p>
         * Autoscaling settings for managing a global table replica's read capacity units.
         * </p>
         * This is a convenience that creates an instance of the {@link AutoScalingSettingsUpdate.Builder} avoiding the
         * need to create one manually via {@link AutoScalingSettingsUpdate#builder()}.
         *
         * When the {@link Consumer} completes, {@link AutoScalingSettingsUpdate.Builder#build()} is called immediately
         * and its result is passed to
         * {@link #replicaProvisionedReadCapacityAutoScalingSettingsUpdate(AutoScalingSettingsUpdate)}.
         * 
         * @param replicaProvisionedReadCapacityAutoScalingSettingsUpdate
         *        a consumer that will call methods on {@link AutoScalingSettingsUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replicaProvisionedReadCapacityAutoScalingSettingsUpdate(AutoScalingSettingsUpdate)
         */
        default Builder replicaProvisionedReadCapacityAutoScalingSettingsUpdate(
                Consumer<AutoScalingSettingsUpdate.Builder> replicaProvisionedReadCapacityAutoScalingSettingsUpdate) {
            return replicaProvisionedReadCapacityAutoScalingSettingsUpdate(AutoScalingSettingsUpdate.builder()
                    .applyMutation(replicaProvisionedReadCapacityAutoScalingSettingsUpdate).build());
        }

        /**
         * <p>
         * Represents the settings of a global secondary index for a global table that will be modified.
         * </p>
         * 
         * @param replicaGlobalSecondaryIndexSettingsUpdate
         *        Represents the settings of a global secondary index for a global table that will be modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicaGlobalSecondaryIndexSettingsUpdate(
                Collection<ReplicaGlobalSecondaryIndexSettingsUpdate> replicaGlobalSecondaryIndexSettingsUpdate);

        /**
         * <p>
         * Represents the settings of a global secondary index for a global table that will be modified.
         * </p>
         * 
         * @param replicaGlobalSecondaryIndexSettingsUpdate
         *        Represents the settings of a global secondary index for a global table that will be modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicaGlobalSecondaryIndexSettingsUpdate(
                ReplicaGlobalSecondaryIndexSettingsUpdate... replicaGlobalSecondaryIndexSettingsUpdate);

        /**
         * <p>
         * Represents the settings of a global secondary index for a global table that will be modified.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <ReplicaGlobalSecondaryIndexSettingsUpdate>.Builder} avoiding the need to create one manually via
         * {@link List<ReplicaGlobalSecondaryIndexSettingsUpdate>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ReplicaGlobalSecondaryIndexSettingsUpdate>.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #replicaGlobalSecondaryIndexSettingsUpdate(List<ReplicaGlobalSecondaryIndexSettingsUpdate>)}.
         * 
         * @param replicaGlobalSecondaryIndexSettingsUpdate
         *        a consumer that will call methods on {@link List<ReplicaGlobalSecondaryIndexSettingsUpdate>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replicaGlobalSecondaryIndexSettingsUpdate(List<ReplicaGlobalSecondaryIndexSettingsUpdate>)
         */
        Builder replicaGlobalSecondaryIndexSettingsUpdate(
                Consumer<ReplicaGlobalSecondaryIndexSettingsUpdate.Builder>... replicaGlobalSecondaryIndexSettingsUpdate);
    }

    static final class BuilderImpl implements Builder {
        private String regionName;

        private Long replicaProvisionedReadCapacityUnits;

        private AutoScalingSettingsUpdate replicaProvisionedReadCapacityAutoScalingSettingsUpdate;

        private List<ReplicaGlobalSecondaryIndexSettingsUpdate> replicaGlobalSecondaryIndexSettingsUpdate = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicaSettingsUpdate model) {
            regionName(model.regionName);
            replicaProvisionedReadCapacityUnits(model.replicaProvisionedReadCapacityUnits);
            replicaProvisionedReadCapacityAutoScalingSettingsUpdate(model.replicaProvisionedReadCapacityAutoScalingSettingsUpdate);
            replicaGlobalSecondaryIndexSettingsUpdate(model.replicaGlobalSecondaryIndexSettingsUpdate);
        }

        public final String getRegionName() {
            return regionName;
        }

        @Override
        public final Builder regionName(String regionName) {
            this.regionName = regionName;
            return this;
        }

        public final void setRegionName(String regionName) {
            this.regionName = regionName;
        }

        public final Long getReplicaProvisionedReadCapacityUnits() {
            return replicaProvisionedReadCapacityUnits;
        }

        @Override
        public final Builder replicaProvisionedReadCapacityUnits(Long replicaProvisionedReadCapacityUnits) {
            this.replicaProvisionedReadCapacityUnits = replicaProvisionedReadCapacityUnits;
            return this;
        }

        public final void setReplicaProvisionedReadCapacityUnits(Long replicaProvisionedReadCapacityUnits) {
            this.replicaProvisionedReadCapacityUnits = replicaProvisionedReadCapacityUnits;
        }

        public final AutoScalingSettingsUpdate.Builder getReplicaProvisionedReadCapacityAutoScalingSettingsUpdate() {
            return replicaProvisionedReadCapacityAutoScalingSettingsUpdate != null ? replicaProvisionedReadCapacityAutoScalingSettingsUpdate
                    .toBuilder() : null;
        }

        @Override
        public final Builder replicaProvisionedReadCapacityAutoScalingSettingsUpdate(
                AutoScalingSettingsUpdate replicaProvisionedReadCapacityAutoScalingSettingsUpdate) {
            this.replicaProvisionedReadCapacityAutoScalingSettingsUpdate = replicaProvisionedReadCapacityAutoScalingSettingsUpdate;
            return this;
        }

        public final void setReplicaProvisionedReadCapacityAutoScalingSettingsUpdate(
                AutoScalingSettingsUpdate.BuilderImpl replicaProvisionedReadCapacityAutoScalingSettingsUpdate) {
            this.replicaProvisionedReadCapacityAutoScalingSettingsUpdate = replicaProvisionedReadCapacityAutoScalingSettingsUpdate != null ? replicaProvisionedReadCapacityAutoScalingSettingsUpdate
                    .build() : null;
        }

        public final Collection<ReplicaGlobalSecondaryIndexSettingsUpdate.Builder> getReplicaGlobalSecondaryIndexSettingsUpdate() {
            return replicaGlobalSecondaryIndexSettingsUpdate != null ? replicaGlobalSecondaryIndexSettingsUpdate.stream()
                    .map(ReplicaGlobalSecondaryIndexSettingsUpdate::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder replicaGlobalSecondaryIndexSettingsUpdate(
                Collection<ReplicaGlobalSecondaryIndexSettingsUpdate> replicaGlobalSecondaryIndexSettingsUpdate) {
            this.replicaGlobalSecondaryIndexSettingsUpdate = ReplicaGlobalSecondaryIndexSettingsUpdateListCopier
                    .copy(replicaGlobalSecondaryIndexSettingsUpdate);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicaGlobalSecondaryIndexSettingsUpdate(
                ReplicaGlobalSecondaryIndexSettingsUpdate... replicaGlobalSecondaryIndexSettingsUpdate) {
            replicaGlobalSecondaryIndexSettingsUpdate(Arrays.asList(replicaGlobalSecondaryIndexSettingsUpdate));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicaGlobalSecondaryIndexSettingsUpdate(
                Consumer<ReplicaGlobalSecondaryIndexSettingsUpdate.Builder>... replicaGlobalSecondaryIndexSettingsUpdate) {
            replicaGlobalSecondaryIndexSettingsUpdate(Stream.of(replicaGlobalSecondaryIndexSettingsUpdate)
                    .map(c -> ReplicaGlobalSecondaryIndexSettingsUpdate.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setReplicaGlobalSecondaryIndexSettingsUpdate(
                Collection<ReplicaGlobalSecondaryIndexSettingsUpdate.BuilderImpl> replicaGlobalSecondaryIndexSettingsUpdate) {
            this.replicaGlobalSecondaryIndexSettingsUpdate = ReplicaGlobalSecondaryIndexSettingsUpdateListCopier
                    .copyFromBuilder(replicaGlobalSecondaryIndexSettingsUpdate);
        }

        @Override
        public ReplicaSettingsUpdate build() {
            return new ReplicaSettingsUpdate(this);
        }
    }
}
