/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.transform.RestoreSummaryMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details for the restore.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RestoreSummary implements StructuredPojo, ToCopyableBuilder<RestoreSummary.Builder, RestoreSummary> {
    private final String sourceBackupArn;

    private final String sourceTableArn;

    private final Instant restoreDateTime;

    private final Boolean restoreInProgress;

    private RestoreSummary(BuilderImpl builder) {
        this.sourceBackupArn = builder.sourceBackupArn;
        this.sourceTableArn = builder.sourceTableArn;
        this.restoreDateTime = builder.restoreDateTime;
        this.restoreInProgress = builder.restoreInProgress;
    }

    /**
     * <p>
     * ARN of the backup from which the table was restored.
     * </p>
     * 
     * @return ARN of the backup from which the table was restored.
     */
    public String sourceBackupArn() {
        return sourceBackupArn;
    }

    /**
     * <p>
     * ARN of the source table of the backup that is being restored.
     * </p>
     * 
     * @return ARN of the source table of the backup that is being restored.
     */
    public String sourceTableArn() {
        return sourceTableArn;
    }

    /**
     * <p>
     * Point in time or source backup time.
     * </p>
     * 
     * @return Point in time or source backup time.
     */
    public Instant restoreDateTime() {
        return restoreDateTime;
    }

    /**
     * <p>
     * Indicates if a restore is in progress or not.
     * </p>
     * 
     * @return Indicates if a restore is in progress or not.
     */
    public Boolean restoreInProgress() {
        return restoreInProgress;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceBackupArn());
        hashCode = 31 * hashCode + Objects.hashCode(sourceTableArn());
        hashCode = 31 * hashCode + Objects.hashCode(restoreDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(restoreInProgress());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreSummary)) {
            return false;
        }
        RestoreSummary other = (RestoreSummary) obj;
        return Objects.equals(sourceBackupArn(), other.sourceBackupArn())
                && Objects.equals(sourceTableArn(), other.sourceTableArn())
                && Objects.equals(restoreDateTime(), other.restoreDateTime())
                && Objects.equals(restoreInProgress(), other.restoreInProgress());
    }

    @Override
    public String toString() {
        return ToString.builder("RestoreSummary").add("SourceBackupArn", sourceBackupArn())
                .add("SourceTableArn", sourceTableArn()).add("RestoreDateTime", restoreDateTime())
                .add("RestoreInProgress", restoreInProgress()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceBackupArn":
            return Optional.ofNullable(clazz.cast(sourceBackupArn()));
        case "SourceTableArn":
            return Optional.ofNullable(clazz.cast(sourceTableArn()));
        case "RestoreDateTime":
            return Optional.ofNullable(clazz.cast(restoreDateTime()));
        case "RestoreInProgress":
            return Optional.ofNullable(clazz.cast(restoreInProgress()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RestoreSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, RestoreSummary> {
        /**
         * <p>
         * ARN of the backup from which the table was restored.
         * </p>
         * 
         * @param sourceBackupArn
         *        ARN of the backup from which the table was restored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceBackupArn(String sourceBackupArn);

        /**
         * <p>
         * ARN of the source table of the backup that is being restored.
         * </p>
         * 
         * @param sourceTableArn
         *        ARN of the source table of the backup that is being restored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceTableArn(String sourceTableArn);

        /**
         * <p>
         * Point in time or source backup time.
         * </p>
         * 
         * @param restoreDateTime
         *        Point in time or source backup time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restoreDateTime(Instant restoreDateTime);

        /**
         * <p>
         * Indicates if a restore is in progress or not.
         * </p>
         * 
         * @param restoreInProgress
         *        Indicates if a restore is in progress or not.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restoreInProgress(Boolean restoreInProgress);
    }

    static final class BuilderImpl implements Builder {
        private String sourceBackupArn;

        private String sourceTableArn;

        private Instant restoreDateTime;

        private Boolean restoreInProgress;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreSummary model) {
            sourceBackupArn(model.sourceBackupArn);
            sourceTableArn(model.sourceTableArn);
            restoreDateTime(model.restoreDateTime);
            restoreInProgress(model.restoreInProgress);
        }

        public final String getSourceBackupArn() {
            return sourceBackupArn;
        }

        @Override
        public final Builder sourceBackupArn(String sourceBackupArn) {
            this.sourceBackupArn = sourceBackupArn;
            return this;
        }

        public final void setSourceBackupArn(String sourceBackupArn) {
            this.sourceBackupArn = sourceBackupArn;
        }

        public final String getSourceTableArn() {
            return sourceTableArn;
        }

        @Override
        public final Builder sourceTableArn(String sourceTableArn) {
            this.sourceTableArn = sourceTableArn;
            return this;
        }

        public final void setSourceTableArn(String sourceTableArn) {
            this.sourceTableArn = sourceTableArn;
        }

        public final Instant getRestoreDateTime() {
            return restoreDateTime;
        }

        @Override
        public final Builder restoreDateTime(Instant restoreDateTime) {
            this.restoreDateTime = restoreDateTime;
            return this;
        }

        public final void setRestoreDateTime(Instant restoreDateTime) {
            this.restoreDateTime = restoreDateTime;
        }

        public final Boolean getRestoreInProgress() {
            return restoreInProgress;
        }

        @Override
        public final Builder restoreInProgress(Boolean restoreInProgress) {
            this.restoreInProgress = restoreInProgress;
            return this;
        }

        public final void setRestoreInProgress(Boolean restoreInProgress) {
            this.restoreInProgress = restoreInProgress;
        }

        @Override
        public RestoreSummary build() {
            return new RestoreSummary(this);
        }
    }
}
