/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RestoreTableFromBackupResponse extends DynamoDbResponse implements
        ToCopyableBuilder<RestoreTableFromBackupResponse.Builder, RestoreTableFromBackupResponse> {
    private final TableDescription tableDescription;

    private RestoreTableFromBackupResponse(BuilderImpl builder) {
        super(builder);
        this.tableDescription = builder.tableDescription;
    }

    /**
     * <p>
     * The description of the table created from an existing backup.
     * </p>
     * 
     * @return The description of the table created from an existing backup.
     */
    public TableDescription tableDescription() {
        return tableDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tableDescription());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreTableFromBackupResponse)) {
            return false;
        }
        RestoreTableFromBackupResponse other = (RestoreTableFromBackupResponse) obj;
        return Objects.equals(tableDescription(), other.tableDescription());
    }

    @Override
    public String toString() {
        return ToString.builder("RestoreTableFromBackupResponse").add("TableDescription", tableDescription()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TableDescription":
            return Optional.ofNullable(clazz.cast(tableDescription()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends DynamoDbResponse.Builder, CopyableBuilder<Builder, RestoreTableFromBackupResponse> {
        /**
         * <p>
         * The description of the table created from an existing backup.
         * </p>
         * 
         * @param tableDescription
         *        The description of the table created from an existing backup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableDescription(TableDescription tableDescription);

        /**
         * <p>
         * The description of the table created from an existing backup.
         * </p>
         * This is a convenience that creates an instance of the {@link TableDescription.Builder} avoiding the need to
         * create one manually via {@link TableDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link TableDescription.Builder#build()} is called immediately and its
         * result is passed to {@link #tableDescription(TableDescription)}.
         * 
         * @param tableDescription
         *        a consumer that will call methods on {@link TableDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tableDescription(TableDescription)
         */
        default Builder tableDescription(Consumer<TableDescription.Builder> tableDescription) {
            return tableDescription(TableDescription.builder().applyMutation(tableDescription).build());
        }
    }

    static final class BuilderImpl extends DynamoDbResponse.BuilderImpl implements Builder {
        private TableDescription tableDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreTableFromBackupResponse model) {
            super(model);
            tableDescription(model.tableDescription);
        }

        public final TableDescription.Builder getTableDescription() {
            return tableDescription != null ? tableDescription.toBuilder() : null;
        }

        @Override
        public final Builder tableDescription(TableDescription tableDescription) {
            this.tableDescription = tableDescription;
            return this;
        }

        public final void setTableDescription(TableDescription.BuilderImpl tableDescription) {
            this.tableDescription = tableDescription != null ? tableDescription.build() : null;
        }

        @Override
        public RestoreTableFromBackupResponse build() {
            return new RestoreTableFromBackupResponse(this);
        }
    }
}
