/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.transform.SSEDescriptionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The description of the server-side encryption status on the specified table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SSEDescription implements StructuredPojo, ToCopyableBuilder<SSEDescription.Builder, SSEDescription> {
    private final String status;

    private final String sseType;

    private final String kmsMasterKeyArn;

    private SSEDescription(BuilderImpl builder) {
        this.status = builder.status;
        this.sseType = builder.sseType;
        this.kmsMasterKeyArn = builder.kmsMasterKeyArn;
    }

    /**
     * <p>
     * The current state of server-side encryption:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ENABLING</code> - Server-side encryption is being enabled.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ENABLED</code> - Server-side encryption is enabled.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISABLING</code> - Server-side encryption is being disabled.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISABLED</code> - Server-side encryption is disabled.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATING</code> - Server-side encryption is being updated.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SSEStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current state of server-side encryption:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ENABLING</code> - Server-side encryption is being enabled.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ENABLED</code> - Server-side encryption is enabled.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISABLING</code> - Server-side encryption is being disabled.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISABLED</code> - Server-side encryption is disabled.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATING</code> - Server-side encryption is being updated.
     *         </p>
     *         </li>
     * @see SSEStatus
     */
    public SSEStatus status() {
        return SSEStatus.fromValue(status);
    }

    /**
     * <p>
     * The current state of server-side encryption:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ENABLING</code> - Server-side encryption is being enabled.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ENABLED</code> - Server-side encryption is enabled.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISABLING</code> - Server-side encryption is being disabled.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISABLED</code> - Server-side encryption is disabled.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATING</code> - Server-side encryption is being updated.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SSEStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current state of server-side encryption:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ENABLING</code> - Server-side encryption is being enabled.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ENABLED</code> - Server-side encryption is enabled.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISABLING</code> - Server-side encryption is being disabled.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISABLED</code> - Server-side encryption is disabled.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATING</code> - Server-side encryption is being updated.
     *         </p>
     *         </li>
     * @see SSEStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Server-side encryption type:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AES256</code> - Server-side encryption which uses the AES256 algorithm.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>KMS</code> - Server-side encryption which uses AWS Key Management Service.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sseType} will
     * return {@link SSEType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sseTypeAsString}.
     * </p>
     * 
     * @return Server-side encryption type:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>AES256</code> - Server-side encryption which uses the AES256 algorithm.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>KMS</code> - Server-side encryption which uses AWS Key Management Service.
     *         </p>
     *         </li>
     * @see SSEType
     */
    public SSEType sseType() {
        return SSEType.fromValue(sseType);
    }

    /**
     * <p>
     * Server-side encryption type:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AES256</code> - Server-side encryption which uses the AES256 algorithm.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>KMS</code> - Server-side encryption which uses AWS Key Management Service.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sseType} will
     * return {@link SSEType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sseTypeAsString}.
     * </p>
     * 
     * @return Server-side encryption type:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>AES256</code> - Server-side encryption which uses the AES256 algorithm.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>KMS</code> - Server-side encryption which uses AWS Key Management Service.
     *         </p>
     *         </li>
     * @see SSEType
     */
    public String sseTypeAsString() {
        return sseType;
    }

    /**
     * <p>
     * The KMS master key ARN used for the KMS encryption.
     * </p>
     * 
     * @return The KMS master key ARN used for the KMS encryption.
     */
    public String kmsMasterKeyArn() {
        return kmsMasterKeyArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sseTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(kmsMasterKeyArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SSEDescription)) {
            return false;
        }
        SSEDescription other = (SSEDescription) obj;
        return Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(sseTypeAsString(), other.sseTypeAsString())
                && Objects.equals(kmsMasterKeyArn(), other.kmsMasterKeyArn());
    }

    @Override
    public String toString() {
        return ToString.builder("SSEDescription").add("Status", statusAsString()).add("SSEType", sseTypeAsString())
                .add("KMSMasterKeyArn", kmsMasterKeyArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "SSEType":
            return Optional.ofNullable(clazz.cast(sseTypeAsString()));
        case "KMSMasterKeyArn":
            return Optional.ofNullable(clazz.cast(kmsMasterKeyArn()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SSEDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, SSEDescription> {
        /**
         * <p>
         * The current state of server-side encryption:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ENABLING</code> - Server-side encryption is being enabled.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ENABLED</code> - Server-side encryption is enabled.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISABLING</code> - Server-side encryption is being disabled.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISABLED</code> - Server-side encryption is disabled.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATING</code> - Server-side encryption is being updated.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The current state of server-side encryption:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ENABLING</code> - Server-side encryption is being enabled.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ENABLED</code> - Server-side encryption is enabled.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISABLING</code> - Server-side encryption is being disabled.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISABLED</code> - Server-side encryption is disabled.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATING</code> - Server-side encryption is being updated.
         *        </p>
         *        </li>
         * @see SSEStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SSEStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current state of server-side encryption:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ENABLING</code> - Server-side encryption is being enabled.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ENABLED</code> - Server-side encryption is enabled.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISABLING</code> - Server-side encryption is being disabled.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISABLED</code> - Server-side encryption is disabled.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATING</code> - Server-side encryption is being updated.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The current state of server-side encryption:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ENABLING</code> - Server-side encryption is being enabled.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ENABLED</code> - Server-side encryption is enabled.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISABLING</code> - Server-side encryption is being disabled.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISABLED</code> - Server-side encryption is disabled.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATING</code> - Server-side encryption is being updated.
         *        </p>
         *        </li>
         * @see SSEStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SSEStatus
         */
        Builder status(SSEStatus status);

        /**
         * <p>
         * Server-side encryption type:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AES256</code> - Server-side encryption which uses the AES256 algorithm.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KMS</code> - Server-side encryption which uses AWS Key Management Service.
         * </p>
         * </li>
         * </ul>
         * 
         * @param sseType
         *        Server-side encryption type:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AES256</code> - Server-side encryption which uses the AES256 algorithm.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KMS</code> - Server-side encryption which uses AWS Key Management Service.
         *        </p>
         *        </li>
         * @see SSEType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SSEType
         */
        Builder sseType(String sseType);

        /**
         * <p>
         * Server-side encryption type:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AES256</code> - Server-side encryption which uses the AES256 algorithm.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KMS</code> - Server-side encryption which uses AWS Key Management Service.
         * </p>
         * </li>
         * </ul>
         * 
         * @param sseType
         *        Server-side encryption type:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AES256</code> - Server-side encryption which uses the AES256 algorithm.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KMS</code> - Server-side encryption which uses AWS Key Management Service.
         *        </p>
         *        </li>
         * @see SSEType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SSEType
         */
        Builder sseType(SSEType sseType);

        /**
         * <p>
         * The KMS master key ARN used for the KMS encryption.
         * </p>
         * 
         * @param kmsMasterKeyArn
         *        The KMS master key ARN used for the KMS encryption.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsMasterKeyArn(String kmsMasterKeyArn);
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private String sseType;

        private String kmsMasterKeyArn;

        private BuilderImpl() {
        }

        private BuilderImpl(SSEDescription model) {
            status(model.status);
            sseType(model.sseType);
            kmsMasterKeyArn(model.kmsMasterKeyArn);
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SSEStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getSSEType() {
            return sseType;
        }

        @Override
        public final Builder sseType(String sseType) {
            this.sseType = sseType;
            return this;
        }

        @Override
        public final Builder sseType(SSEType sseType) {
            this.sseType(sseType.toString());
            return this;
        }

        public final void setSSEType(String sseType) {
            this.sseType = sseType;
        }

        public final String getKMSMasterKeyArn() {
            return kmsMasterKeyArn;
        }

        @Override
        public final Builder kmsMasterKeyArn(String kmsMasterKeyArn) {
            this.kmsMasterKeyArn = kmsMasterKeyArn;
            return this;
        }

        public final void setKMSMasterKeyArn(String kmsMasterKeyArn) {
            this.kmsMasterKeyArn = kmsMasterKeyArn;
        }

        @Override
        public SSEDescription build() {
            return new SSEDescription(this);
        }
    }
}
