/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateContinuousBackupsRequest extends DynamoDbRequest implements
        ToCopyableBuilder<UpdateContinuousBackupsRequest.Builder, UpdateContinuousBackupsRequest> {
    private final String tableName;

    private final PointInTimeRecoverySpecification pointInTimeRecoverySpecification;

    private UpdateContinuousBackupsRequest(BuilderImpl builder) {
        super(builder);
        this.tableName = builder.tableName;
        this.pointInTimeRecoverySpecification = builder.pointInTimeRecoverySpecification;
    }

    /**
     * <p>
     * The name of the table.
     * </p>
     * 
     * @return The name of the table.
     */
    public String tableName() {
        return tableName;
    }

    /**
     * <p>
     * Represents the settings used to enable point in time recovery.
     * </p>
     * 
     * @return Represents the settings used to enable point in time recovery.
     */
    public PointInTimeRecoverySpecification pointInTimeRecoverySpecification() {
        return pointInTimeRecoverySpecification;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        hashCode = 31 * hashCode + Objects.hashCode(pointInTimeRecoverySpecification());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateContinuousBackupsRequest)) {
            return false;
        }
        UpdateContinuousBackupsRequest other = (UpdateContinuousBackupsRequest) obj;
        return Objects.equals(tableName(), other.tableName())
                && Objects.equals(pointInTimeRecoverySpecification(), other.pointInTimeRecoverySpecification());
    }

    @Override
    public String toString() {
        return ToString.builder("UpdateContinuousBackupsRequest").add("TableName", tableName())
                .add("PointInTimeRecoverySpecification", pointInTimeRecoverySpecification()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        case "PointInTimeRecoverySpecification":
            return Optional.ofNullable(clazz.cast(pointInTimeRecoverySpecification()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends DynamoDbRequest.Builder, CopyableBuilder<Builder, UpdateContinuousBackupsRequest> {
        /**
         * <p>
         * The name of the table.
         * </p>
         * 
         * @param tableName
         *        The name of the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * Represents the settings used to enable point in time recovery.
         * </p>
         * 
         * @param pointInTimeRecoverySpecification
         *        Represents the settings used to enable point in time recovery.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pointInTimeRecoverySpecification(PointInTimeRecoverySpecification pointInTimeRecoverySpecification);

        /**
         * <p>
         * Represents the settings used to enable point in time recovery.
         * </p>
         * This is a convenience that creates an instance of the {@link PointInTimeRecoverySpecification.Builder}
         * avoiding the need to create one manually via {@link PointInTimeRecoverySpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link PointInTimeRecoverySpecification.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #pointInTimeRecoverySpecification(PointInTimeRecoverySpecification)}.
         * 
         * @param pointInTimeRecoverySpecification
         *        a consumer that will call methods on {@link PointInTimeRecoverySpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pointInTimeRecoverySpecification(PointInTimeRecoverySpecification)
         */
        default Builder pointInTimeRecoverySpecification(
                Consumer<PointInTimeRecoverySpecification.Builder> pointInTimeRecoverySpecification) {
            return pointInTimeRecoverySpecification(PointInTimeRecoverySpecification.builder()
                    .applyMutation(pointInTimeRecoverySpecification).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DynamoDbRequest.BuilderImpl implements Builder {
        private String tableName;

        private PointInTimeRecoverySpecification pointInTimeRecoverySpecification;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateContinuousBackupsRequest model) {
            super(model);
            tableName(model.tableName);
            pointInTimeRecoverySpecification(model.pointInTimeRecoverySpecification);
        }

        public final String getTableName() {
            return tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final PointInTimeRecoverySpecification.Builder getPointInTimeRecoverySpecification() {
            return pointInTimeRecoverySpecification != null ? pointInTimeRecoverySpecification.toBuilder() : null;
        }

        @Override
        public final Builder pointInTimeRecoverySpecification(PointInTimeRecoverySpecification pointInTimeRecoverySpecification) {
            this.pointInTimeRecoverySpecification = pointInTimeRecoverySpecification;
            return this;
        }

        public final void setPointInTimeRecoverySpecification(
                PointInTimeRecoverySpecification.BuilderImpl pointInTimeRecoverySpecification) {
            this.pointInTimeRecoverySpecification = pointInTimeRecoverySpecification != null ? pointInTimeRecoverySpecification
                    .build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateContinuousBackupsRequest build() {
            return new UpdateContinuousBackupsRequest(this);
        }
    }
}
