/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.transform;

import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link AttributeValue} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class AttributeValueMarshaller {
    private static final MarshallingInfo<String> S_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S").isBinary(false).build();

    private static final MarshallingInfo<String> N_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("N").isBinary(false).build();

    private static final MarshallingInfo<SdkBytes> B_BINDING = MarshallingInfo.builder(MarshallingType.SDK_BYTES)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("B").isBinary(false).build();

    private static final MarshallingInfo<List> SS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SS").isBinary(false).build();

    private static final MarshallingInfo<List> NS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NS").isBinary(false).build();

    private static final MarshallingInfo<List> BS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BS").isBinary(false).build();

    private static final MarshallingInfo<Map> M_BINDING = MarshallingInfo.builder(MarshallingType.MAP)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("M").isBinary(false).build();

    private static final MarshallingInfo<List> L_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("L").isBinary(false).build();

    private static final MarshallingInfo<Boolean> BOOL_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BOOL").isBinary(false).build();

    private static final MarshallingInfo<Boolean> NUL_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NULL").isBinary(false).build();

    private static final AttributeValueMarshaller INSTANCE = new AttributeValueMarshaller();

    private AttributeValueMarshaller() {
    }

    public static AttributeValueMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(AttributeValue attributeValue, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(attributeValue, "attributeValue");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(attributeValue.s(), S_BINDING);
            protocolMarshaller.marshall(attributeValue.n(), N_BINDING);
            protocolMarshaller.marshall(attributeValue.b(), B_BINDING);
            protocolMarshaller.marshall(attributeValue.ss(), SS_BINDING);
            protocolMarshaller.marshall(attributeValue.ns(), NS_BINDING);
            protocolMarshaller.marshall(attributeValue.bs(), BS_BINDING);
            protocolMarshaller.marshall(attributeValue.m(), M_BINDING);
            protocolMarshaller.marshall(attributeValue.l(), L_BINDING);
            protocolMarshaller.marshall(attributeValue.bool(), BOOL_BINDING);
            protocolMarshaller.marshall(attributeValue.nul(), NUL_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
