/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.transform;

import java.math.*;
import software.amazon.awssdk.core.SdkBytes;
import javax.annotation.Generated;

import software.amazon.awssdk.services.dynamodb.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * AttributeValue JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class AttributeValueUnmarshaller implements Unmarshaller<AttributeValue, JsonUnmarshallerContext> {

    public AttributeValue unmarshall(JsonUnmarshallerContext context) throws Exception {
        AttributeValue.Builder attributeValueBuilder = AttributeValue.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("S", targetDepth)) {
                    context.nextToken();
                    attributeValueBuilder.s(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("N", targetDepth)) {
                    context.nextToken();
                    attributeValueBuilder.n(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("B", targetDepth)) {
                    context.nextToken();
                    attributeValueBuilder.b(context.getUnmarshaller(software.amazon.awssdk.core.SdkBytes.class).unmarshall(
                            context));
                }
                if (context.testExpression("SS", targetDepth)) {
                    context.nextToken();
                    attributeValueBuilder.ss(new ListUnmarshaller<String>(context.getUnmarshaller(String.class))
                            .unmarshall(context));
                }
                if (context.testExpression("NS", targetDepth)) {
                    context.nextToken();
                    attributeValueBuilder.ns(new ListUnmarshaller<String>(context.getUnmarshaller(String.class))
                            .unmarshall(context));
                }
                if (context.testExpression("BS", targetDepth)) {
                    context.nextToken();
                    attributeValueBuilder.bs(new ListUnmarshaller<software.amazon.awssdk.core.SdkBytes>(context
                            .getUnmarshaller(software.amazon.awssdk.core.SdkBytes.class)).unmarshall(context));
                }
                if (context.testExpression("M", targetDepth)) {
                    context.nextToken();
                    attributeValueBuilder.m(new MapUnmarshaller<String, AttributeValue>(context.getUnmarshaller(String.class),
                            AttributeValueUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("L", targetDepth)) {
                    context.nextToken();
                    attributeValueBuilder.l(new ListUnmarshaller<AttributeValue>(AttributeValueUnmarshaller.getInstance())
                            .unmarshall(context));
                }
                if (context.testExpression("BOOL", targetDepth)) {
                    context.nextToken();
                    attributeValueBuilder.bool(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("NULL", targetDepth)) {
                    context.nextToken();
                    attributeValueBuilder.nul(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return attributeValueBuilder.build();
    }

    private static final AttributeValueUnmarshaller INSTANCE = new AttributeValueUnmarshaller();

    public static AttributeValueUnmarshaller getInstance() {
        return INSTANCE;
    }
}
