/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.transform;

import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.dynamodb.model.AutoScalingSettingsDescription;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link AutoScalingSettingsDescription} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class AutoScalingSettingsDescriptionMarshaller {
    private static final MarshallingInfo<Long> MINIMUMUNITS_BINDING = MarshallingInfo.builder(MarshallingType.LONG)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MinimumUnits").isBinary(false).build();

    private static final MarshallingInfo<Long> MAXIMUMUNITS_BINDING = MarshallingInfo.builder(MarshallingType.LONG)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaximumUnits").isBinary(false).build();

    private static final MarshallingInfo<Boolean> AUTOSCALINGDISABLED_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AutoScalingDisabled").isBinary(false).build();

    private static final MarshallingInfo<String> AUTOSCALINGROLEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AutoScalingRoleArn").isBinary(false).build();

    private static final MarshallingInfo<List> SCALINGPOLICIES_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ScalingPolicies").isBinary(false).build();

    private static final AutoScalingSettingsDescriptionMarshaller INSTANCE = new AutoScalingSettingsDescriptionMarshaller();

    private AutoScalingSettingsDescriptionMarshaller() {
    }

    public static AutoScalingSettingsDescriptionMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(AutoScalingSettingsDescription autoScalingSettingsDescription, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(autoScalingSettingsDescription, "autoScalingSettingsDescription");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(autoScalingSettingsDescription.minimumUnits(), MINIMUMUNITS_BINDING);
            protocolMarshaller.marshall(autoScalingSettingsDescription.maximumUnits(), MAXIMUMUNITS_BINDING);
            protocolMarshaller.marshall(autoScalingSettingsDescription.autoScalingDisabled(), AUTOSCALINGDISABLED_BINDING);
            protocolMarshaller.marshall(autoScalingSettingsDescription.autoScalingRoleArn(), AUTOSCALINGROLEARN_BINDING);
            protocolMarshaller.marshall(autoScalingSettingsDescription.scalingPolicies(), SCALINGPOLICIES_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
