/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.transform;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.dynamodb.model.AutoScalingTargetTrackingScalingPolicyConfigurationDescription;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link AutoScalingTargetTrackingScalingPolicyConfigurationDescription} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class AutoScalingTargetTrackingScalingPolicyConfigurationDescriptionMarshaller {
    private static final MarshallingInfo<Boolean> DISABLESCALEIN_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DisableScaleIn").isBinary(false).build();

    private static final MarshallingInfo<Integer> SCALEINCOOLDOWN_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ScaleInCooldown").isBinary(false).build();

    private static final MarshallingInfo<Integer> SCALEOUTCOOLDOWN_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ScaleOutCooldown").isBinary(false).build();

    private static final MarshallingInfo<Double> TARGETVALUE_BINDING = MarshallingInfo.builder(MarshallingType.DOUBLE)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TargetValue").isBinary(false).build();

    private static final AutoScalingTargetTrackingScalingPolicyConfigurationDescriptionMarshaller INSTANCE = new AutoScalingTargetTrackingScalingPolicyConfigurationDescriptionMarshaller();

    private AutoScalingTargetTrackingScalingPolicyConfigurationDescriptionMarshaller() {
    }

    public static AutoScalingTargetTrackingScalingPolicyConfigurationDescriptionMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(
            AutoScalingTargetTrackingScalingPolicyConfigurationDescription autoScalingTargetTrackingScalingPolicyConfigurationDescription,
            ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(autoScalingTargetTrackingScalingPolicyConfigurationDescription,
                "autoScalingTargetTrackingScalingPolicyConfigurationDescription");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(autoScalingTargetTrackingScalingPolicyConfigurationDescription.disableScaleIn(),
                    DISABLESCALEIN_BINDING);
            protocolMarshaller.marshall(autoScalingTargetTrackingScalingPolicyConfigurationDescription.scaleInCooldown(),
                    SCALEINCOOLDOWN_BINDING);
            protocolMarshaller.marshall(autoScalingTargetTrackingScalingPolicyConfigurationDescription.scaleOutCooldown(),
                    SCALEOUTCOOLDOWN_BINDING);
            protocolMarshaller.marshall(autoScalingTargetTrackingScalingPolicyConfigurationDescription.targetValue(),
                    TARGETVALUE_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
