/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.dynamodb.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * ReplicaGlobalSecondaryIndexSettingsDescription JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ReplicaGlobalSecondaryIndexSettingsDescriptionUnmarshaller implements
        Unmarshaller<ReplicaGlobalSecondaryIndexSettingsDescription, JsonUnmarshallerContext> {

    public ReplicaGlobalSecondaryIndexSettingsDescription unmarshall(JsonUnmarshallerContext context) throws Exception {
        ReplicaGlobalSecondaryIndexSettingsDescription.Builder replicaGlobalSecondaryIndexSettingsDescriptionBuilder = ReplicaGlobalSecondaryIndexSettingsDescription
                .builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("IndexName", targetDepth)) {
                    context.nextToken();
                    replicaGlobalSecondaryIndexSettingsDescriptionBuilder.indexName(context.getUnmarshaller(String.class)
                            .unmarshall(context));
                }
                if (context.testExpression("IndexStatus", targetDepth)) {
                    context.nextToken();
                    replicaGlobalSecondaryIndexSettingsDescriptionBuilder.indexStatus(context.getUnmarshaller(String.class)
                            .unmarshall(context));
                }
                if (context.testExpression("ProvisionedReadCapacityUnits", targetDepth)) {
                    context.nextToken();
                    replicaGlobalSecondaryIndexSettingsDescriptionBuilder.provisionedReadCapacityUnits(context.getUnmarshaller(
                            Long.class).unmarshall(context));
                }
                if (context.testExpression("ProvisionedReadCapacityAutoScalingSettings", targetDepth)) {
                    context.nextToken();
                    replicaGlobalSecondaryIndexSettingsDescriptionBuilder
                            .provisionedReadCapacityAutoScalingSettings(AutoScalingSettingsDescriptionUnmarshaller.getInstance()
                                    .unmarshall(context));
                }
                if (context.testExpression("ProvisionedWriteCapacityUnits", targetDepth)) {
                    context.nextToken();
                    replicaGlobalSecondaryIndexSettingsDescriptionBuilder.provisionedWriteCapacityUnits(context.getUnmarshaller(
                            Long.class).unmarshall(context));
                }
                if (context.testExpression("ProvisionedWriteCapacityAutoScalingSettings", targetDepth)) {
                    context.nextToken();
                    replicaGlobalSecondaryIndexSettingsDescriptionBuilder
                            .provisionedWriteCapacityAutoScalingSettings(AutoScalingSettingsDescriptionUnmarshaller.getInstance()
                                    .unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return replicaGlobalSecondaryIndexSettingsDescriptionBuilder.build();
    }

    private static final ReplicaGlobalSecondaryIndexSettingsDescriptionUnmarshaller INSTANCE = new ReplicaGlobalSecondaryIndexSettingsDescriptionUnmarshaller();

    public static ReplicaGlobalSecondaryIndexSettingsDescriptionUnmarshaller getInstance() {
        return INSTANCE;
    }
}
