/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.transform;

import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.model.ReplicaSettingsDescription;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link ReplicaSettingsDescription} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class ReplicaSettingsDescriptionMarshaller {
    private static final MarshallingInfo<String> REGIONNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RegionName").isBinary(false).build();

    private static final MarshallingInfo<String> REPLICASTATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReplicaStatus").isBinary(false).build();

    private static final MarshallingInfo<Long> REPLICAPROVISIONEDREADCAPACITYUNITS_BINDING = MarshallingInfo
            .builder(MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("ReplicaProvisionedReadCapacityUnits").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> REPLICAPROVISIONEDREADCAPACITYAUTOSCALINGSETTINGS_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("ReplicaProvisionedReadCapacityAutoScalingSettings").isBinary(false).build();

    private static final MarshallingInfo<Long> REPLICAPROVISIONEDWRITECAPACITYUNITS_BINDING = MarshallingInfo
            .builder(MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("ReplicaProvisionedWriteCapacityUnits").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> REPLICAPROVISIONEDWRITECAPACITYAUTOSCALINGSETTINGS_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("ReplicaProvisionedWriteCapacityAutoScalingSettings").isBinary(false).build();

    private static final MarshallingInfo<List> REPLICAGLOBALSECONDARYINDEXSETTINGS_BINDING = MarshallingInfo
            .builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("ReplicaGlobalSecondaryIndexSettings").isBinary(false).build();

    private static final ReplicaSettingsDescriptionMarshaller INSTANCE = new ReplicaSettingsDescriptionMarshaller();

    private ReplicaSettingsDescriptionMarshaller() {
    }

    public static ReplicaSettingsDescriptionMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(ReplicaSettingsDescription replicaSettingsDescription, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(replicaSettingsDescription, "replicaSettingsDescription");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(replicaSettingsDescription.regionName(), REGIONNAME_BINDING);
            protocolMarshaller.marshall(replicaSettingsDescription.replicaStatusAsString(), REPLICASTATUS_BINDING);
            protocolMarshaller.marshall(replicaSettingsDescription.replicaProvisionedReadCapacityUnits(),
                    REPLICAPROVISIONEDREADCAPACITYUNITS_BINDING);
            protocolMarshaller.marshall(replicaSettingsDescription.replicaProvisionedReadCapacityAutoScalingSettings(),
                    REPLICAPROVISIONEDREADCAPACITYAUTOSCALINGSETTINGS_BINDING);
            protocolMarshaller.marshall(replicaSettingsDescription.replicaProvisionedWriteCapacityUnits(),
                    REPLICAPROVISIONEDWRITECAPACITYUNITS_BINDING);
            protocolMarshaller.marshall(replicaSettingsDescription.replicaProvisionedWriteCapacityAutoScalingSettings(),
                    REPLICAPROVISIONEDWRITECAPACITYAUTOSCALINGSETTINGS_BINDING);
            protocolMarshaller.marshall(replicaSettingsDescription.replicaGlobalSecondaryIndexSettings(),
                    REPLICAGLOBALSECONDARYINDEXSETTINGS_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
