/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.dynamodb.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * ReplicaSettingsDescription JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ReplicaSettingsDescriptionUnmarshaller implements Unmarshaller<ReplicaSettingsDescription, JsonUnmarshallerContext> {

    public ReplicaSettingsDescription unmarshall(JsonUnmarshallerContext context) throws Exception {
        ReplicaSettingsDescription.Builder replicaSettingsDescriptionBuilder = ReplicaSettingsDescription.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("RegionName", targetDepth)) {
                    context.nextToken();
                    replicaSettingsDescriptionBuilder.regionName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("ReplicaStatus", targetDepth)) {
                    context.nextToken();
                    replicaSettingsDescriptionBuilder.replicaStatus(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("ReplicaProvisionedReadCapacityUnits", targetDepth)) {
                    context.nextToken();
                    replicaSettingsDescriptionBuilder.replicaProvisionedReadCapacityUnits(context.getUnmarshaller(Long.class)
                            .unmarshall(context));
                }
                if (context.testExpression("ReplicaProvisionedReadCapacityAutoScalingSettings", targetDepth)) {
                    context.nextToken();
                    replicaSettingsDescriptionBuilder
                            .replicaProvisionedReadCapacityAutoScalingSettings(AutoScalingSettingsDescriptionUnmarshaller
                                    .getInstance().unmarshall(context));
                }
                if (context.testExpression("ReplicaProvisionedWriteCapacityUnits", targetDepth)) {
                    context.nextToken();
                    replicaSettingsDescriptionBuilder.replicaProvisionedWriteCapacityUnits(context.getUnmarshaller(Long.class)
                            .unmarshall(context));
                }
                if (context.testExpression("ReplicaProvisionedWriteCapacityAutoScalingSettings", targetDepth)) {
                    context.nextToken();
                    replicaSettingsDescriptionBuilder
                            .replicaProvisionedWriteCapacityAutoScalingSettings(AutoScalingSettingsDescriptionUnmarshaller
                                    .getInstance().unmarshall(context));
                }
                if (context.testExpression("ReplicaGlobalSecondaryIndexSettings", targetDepth)) {
                    context.nextToken();
                    replicaSettingsDescriptionBuilder
                            .replicaGlobalSecondaryIndexSettings(new ListUnmarshaller<ReplicaGlobalSecondaryIndexSettingsDescription>(
                                    ReplicaGlobalSecondaryIndexSettingsDescriptionUnmarshaller.getInstance()).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return replicaSettingsDescriptionBuilder.build();
    }

    private static final ReplicaSettingsDescriptionUnmarshaller INSTANCE = new ReplicaSettingsDescriptionUnmarshaller();

    public static ReplicaSettingsDescriptionUnmarshaller getInstance() {
        return INSTANCE;
    }
}
