/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.dynamodb.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * SourceTableDetails JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class SourceTableDetailsUnmarshaller implements Unmarshaller<SourceTableDetails, JsonUnmarshallerContext> {

    public SourceTableDetails unmarshall(JsonUnmarshallerContext context) throws Exception {
        SourceTableDetails.Builder sourceTableDetailsBuilder = SourceTableDetails.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("TableName", targetDepth)) {
                    context.nextToken();
                    sourceTableDetailsBuilder.tableName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("TableId", targetDepth)) {
                    context.nextToken();
                    sourceTableDetailsBuilder.tableId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("TableArn", targetDepth)) {
                    context.nextToken();
                    sourceTableDetailsBuilder.tableArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("TableSizeBytes", targetDepth)) {
                    context.nextToken();
                    sourceTableDetailsBuilder.tableSizeBytes(context.getUnmarshaller(Long.class).unmarshall(context));
                }
                if (context.testExpression("KeySchema", targetDepth)) {
                    context.nextToken();
                    sourceTableDetailsBuilder.keySchema(new ListUnmarshaller<KeySchemaElement>(KeySchemaElementUnmarshaller
                            .getInstance()).unmarshall(context));
                }
                if (context.testExpression("TableCreationDateTime", targetDepth)) {
                    context.nextToken();
                    sourceTableDetailsBuilder.tableCreationDateTime(context.getUnmarshaller(java.time.Instant.class).unmarshall(
                            context));
                }
                if (context.testExpression("ProvisionedThroughput", targetDepth)) {
                    context.nextToken();
                    sourceTableDetailsBuilder.provisionedThroughput(ProvisionedThroughputUnmarshaller.getInstance().unmarshall(
                            context));
                }
                if (context.testExpression("ItemCount", targetDepth)) {
                    context.nextToken();
                    sourceTableDetailsBuilder.itemCount(context.getUnmarshaller(Long.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return sourceTableDetailsBuilder.build();
    }

    private static final SourceTableDetailsUnmarshaller INSTANCE = new SourceTableDetailsUnmarshaller();

    public static SourceTableDetailsUnmarshaller getInstance() {
        return INSTANCE;
    }
}
