/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.dynamodb.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * SourceTableFeatureDetails JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class SourceTableFeatureDetailsUnmarshaller implements Unmarshaller<SourceTableFeatureDetails, JsonUnmarshallerContext> {

    public SourceTableFeatureDetails unmarshall(JsonUnmarshallerContext context) throws Exception {
        SourceTableFeatureDetails.Builder sourceTableFeatureDetailsBuilder = SourceTableFeatureDetails.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("LocalSecondaryIndexes", targetDepth)) {
                    context.nextToken();
                    sourceTableFeatureDetailsBuilder.localSecondaryIndexes(new ListUnmarshaller<LocalSecondaryIndexInfo>(
                            LocalSecondaryIndexInfoUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("GlobalSecondaryIndexes", targetDepth)) {
                    context.nextToken();
                    sourceTableFeatureDetailsBuilder.globalSecondaryIndexes(new ListUnmarshaller<GlobalSecondaryIndexInfo>(
                            GlobalSecondaryIndexInfoUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("StreamDescription", targetDepth)) {
                    context.nextToken();
                    sourceTableFeatureDetailsBuilder.streamDescription(StreamSpecificationUnmarshaller.getInstance().unmarshall(
                            context));
                }
                if (context.testExpression("TimeToLiveDescription", targetDepth)) {
                    context.nextToken();
                    sourceTableFeatureDetailsBuilder.timeToLiveDescription(TimeToLiveDescriptionUnmarshaller.getInstance()
                            .unmarshall(context));
                }
                if (context.testExpression("SSEDescription", targetDepth)) {
                    context.nextToken();
                    sourceTableFeatureDetailsBuilder.sseDescription(SSEDescriptionUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return sourceTableFeatureDetailsBuilder.build();
    }

    private static final SourceTableFeatureDetailsUnmarshaller INSTANCE = new SourceTableFeatureDetailsUnmarshaller();

    public static SourceTableFeatureDetailsUnmarshaller getInstance() {
        return INSTANCE;
    }
}
