/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.transform.EndpointMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Endpoint
implements StructuredPojo,
ToCopyableBuilder<Builder, Endpoint> {
    private final String address;
    private final Long cachePeriodInMinutes;

    private Endpoint(BuilderImpl builder) {
        this.address = builder.address;
        this.cachePeriodInMinutes = builder.cachePeriodInMinutes;
    }

    public String address() {
        return this.address;
    }

    public Long cachePeriodInMinutes() {
        return this.cachePeriodInMinutes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.address());
        hashCode = 31 * hashCode + Objects.hashCode(this.cachePeriodInMinutes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Endpoint)) {
            return false;
        }
        Endpoint other = (Endpoint)obj;
        return Objects.equals(this.address(), other.address()) && Objects.equals(this.cachePeriodInMinutes(), other.cachePeriodInMinutes());
    }

    public String toString() {
        return ToString.builder((String)"Endpoint").add("Address", (Object)this.address()).add("CachePeriodInMinutes", (Object)this.cachePeriodInMinutes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Address": {
                return Optional.ofNullable(clazz.cast(this.address()));
            }
            case "CachePeriodInMinutes": {
                return Optional.ofNullable(clazz.cast(this.cachePeriodInMinutes()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EndpointMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String address;
        private Long cachePeriodInMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(Endpoint model) {
            this.address(model.address);
            this.cachePeriodInMinutes(model.cachePeriodInMinutes);
        }

        public final String getAddress() {
            return this.address;
        }

        @Override
        public final Builder address(String address) {
            this.address = address;
            return this;
        }

        public final void setAddress(String address) {
            this.address = address;
        }

        public final Long getCachePeriodInMinutes() {
            return this.cachePeriodInMinutes;
        }

        @Override
        public final Builder cachePeriodInMinutes(Long cachePeriodInMinutes) {
            this.cachePeriodInMinutes = cachePeriodInMinutes;
            return this;
        }

        public final void setCachePeriodInMinutes(Long cachePeriodInMinutes) {
            this.cachePeriodInMinutes = cachePeriodInMinutes;
        }

        public Endpoint build() {
            return new Endpoint(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Endpoint> {
        public Builder address(String var1);

        public Builder cachePeriodInMinutes(Long var1);
    }
}

