/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.dynamodb.model.PointInTimeRecoveryDescription;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class PointInTimeRecoveryDescriptionMarshaller {
    private static final MarshallingInfo<String> POINTINTIMERECOVERYSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PointInTimeRecoveryStatus").isBinary(false).build();
    private static final MarshallingInfo<Instant> EARLIESTRESTORABLEDATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EarliestRestorableDateTime").isBinary(false).build();
    private static final MarshallingInfo<Instant> LATESTRESTORABLEDATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LatestRestorableDateTime").isBinary(false).build();
    private static final PointInTimeRecoveryDescriptionMarshaller INSTANCE = new PointInTimeRecoveryDescriptionMarshaller();

    private PointInTimeRecoveryDescriptionMarshaller() {
    }

    public static PointInTimeRecoveryDescriptionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(PointInTimeRecoveryDescription pointInTimeRecoveryDescription, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)pointInTimeRecoveryDescription, (String)"pointInTimeRecoveryDescription");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)pointInTimeRecoveryDescription.pointInTimeRecoveryStatusAsString(), POINTINTIMERECOVERYSTATUS_BINDING);
            protocolMarshaller.marshall((Object)pointInTimeRecoveryDescription.earliestRestorableDateTime(), EARLIESTRESTORABLEDATETIME_BINDING);
            protocolMarshaller.marshall((Object)pointInTimeRecoveryDescription.latestRestorableDateTime(), LATESTRESTORABLEDATETIME_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

