/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Map;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a <code>BatchGetItem</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class BatchGetItemRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<BatchGetItemRequest.Builder, BatchGetItemRequest> {
    private final Map<String, KeysAndAttributes> requestItems;

    private final String returnConsumedCapacity;

    private BatchGetItemRequest(BuilderImpl builder) {
        this.requestItems = builder.requestItems;
        this.returnConsumedCapacity = builder.returnConsumedCapacity;
    }

    /**
     * <p>
     * A map of one or more table names and, for each table, a map that describes one or more items to retrieve from
     * that table. Each table name can be used only once per <code>BatchGetItem</code> request.
     * </p>
     * <p>
     * Each element in the map of items to retrieve consists of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ConsistentRead</code> - If <code>true</code>, a strongly consistent read is used; if <code>false</code>
     * (the default), an eventually consistent read is used.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ExpressionAttributeNames</code> - One or more substitution tokens for attribute names in the
     * <code>ProjectionExpression</code> parameter. The following are some use cases for using
     * <code>ExpressionAttributeNames</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To access an attribute whose name conflicts with a DynamoDB reserved word.
     * </p>
     * </li>
     * <li>
     * <p>
     * To create a placeholder for repeating occurrences of an attribute name in an expression.
     * </p>
     * </li>
     * <li>
     * <p>
     * To prevent special characters in an attribute name from being misinterpreted in an expression.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Use the <b>#</b> character in an expression to dereference an attribute name. For example, consider the following
     * attribute name:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Percentile</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * The name of this attribute conflicts with a reserved word, so it cannot be used directly in an expression. (For
     * the complete list of reserved words, see <a
     * href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a> in
     * the <i>Amazon DynamoDB Developer Guide</i>). To work around this, you could specify the following for
     * <code>ExpressionAttributeNames</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>{"#P":"Percentile"}</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * You could then use this substitution in an expression, as in this example:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>#P = :val</code>
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * Tokens that begin with the <b>:</b> character are <i>expression attribute values</i>, which are placeholders for
     * the actual value at runtime.
     * </p>
     * </note>
     * <p>
     * For more information on expression attribute names, see <a
     * href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html"
     * >Accessing Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Keys</code> - An array of primary key attribute values that define specific items in the table. For each
     * primary key, you must provide <i>all</i> of the key attributes. For example, with a simple primary key, you only
     * need to provide the partition key value. For a composite key, you must provide <i>both</i> the partition key
     * value and the sort key value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ProjectionExpression</code> - A string that identifies one or more attributes to retrieve from the table.
     * These attributes can include scalars, sets, or elements of a JSON document. The attributes in the expression must
     * be separated by commas.
     * </p>
     * <p>
     * If no attribute names are specified, then all attributes will be returned. If any of the requested attributes are
     * not found, they will not appear in the result.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html"
     * >Accessing Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AttributesToGet</code> - This is a legacy parameter. Use <code>ProjectionExpression</code> instead. For
     * more information, see <a href=
     * "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributesToGet.html"
     * >AttributesToGet</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A map of one or more table names and, for each table, a map that describes one or more items to retrieve
     *         from that table. Each table name can be used only once per <code>BatchGetItem</code> request.</p>
     *         <p>
     *         Each element in the map of items to retrieve consists of the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ConsistentRead</code> - If <code>true</code>, a strongly consistent read is used; if
     *         <code>false</code> (the default), an eventually consistent read is used.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ExpressionAttributeNames</code> - One or more substitution tokens for attribute names in the
     *         <code>ProjectionExpression</code> parameter. The following are some use cases for using
     *         <code>ExpressionAttributeNames</code>:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         To access an attribute whose name conflicts with a DynamoDB reserved word.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To create a placeholder for repeating occurrences of an attribute name in an expression.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To prevent special characters in an attribute name from being misinterpreted in an expression.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Use the <b>#</b> character in an expression to dereference an attribute name. For example, consider the
     *         following attribute name:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Percentile</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The name of this attribute conflicts with a reserved word, so it cannot be used directly in an
     *         expression. (For the complete list of reserved words, see <a
     *         href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved
     *         Words</a> in the <i>Amazon DynamoDB Developer Guide</i>). To work around this, you could specify the
     *         following for <code>ExpressionAttributeNames</code>:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>{"#P":"Percentile"}</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         You could then use this substitution in an expression, as in this example:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>#P = :val</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         Tokens that begin with the <b>:</b> character are <i>expression attribute values</i>, which are
     *         placeholders for the actual value at runtime.
     *         </p>
     *         </note>
     *         <p>
     *         For more information on expression attribute names, see <a href=
     *         "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html"
     *         >Accessing Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Keys</code> - An array of primary key attribute values that define specific items in the table. For
     *         each primary key, you must provide <i>all</i> of the key attributes. For example, with a simple primary
     *         key, you only need to provide the partition key value. For a composite key, you must provide <i>both</i>
     *         the partition key value and the sort key value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ProjectionExpression</code> - A string that identifies one or more attributes to retrieve from the
     *         table. These attributes can include scalars, sets, or elements of a JSON document. The attributes in the
     *         expression must be separated by commas.
     *         </p>
     *         <p>
     *         If no attribute names are specified, then all attributes will be returned. If any of the requested
     *         attributes are not found, they will not appear in the result.
     *         </p>
     *         <p>
     *         For more information, see <a href=
     *         "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html"
     *         >Accessing Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AttributesToGet</code> - This is a legacy parameter. Use <code>ProjectionExpression</code> instead.
     *         For more information, see <a href=
     *         "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributesToGet.html"
     *         >AttributesToGet</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     *         </p>
     *         </li>
     */
    public Map<String, KeysAndAttributes> requestItems() {
        return requestItems;
    }

    /**
     * Returns the value of the ReturnConsumedCapacity property for this object.
     * 
     * @return The value of the ReturnConsumedCapacity property for this object.
     * @see ReturnConsumedCapacity
     */
    public String returnConsumedCapacity() {
        return returnConsumedCapacity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((requestItems() == null) ? 0 : requestItems().hashCode());
        hashCode = 31 * hashCode + ((returnConsumedCapacity() == null) ? 0 : returnConsumedCapacity().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetItemRequest)) {
            return false;
        }
        BatchGetItemRequest other = (BatchGetItemRequest) obj;
        if (other.requestItems() == null ^ this.requestItems() == null) {
            return false;
        }
        if (other.requestItems() != null && !other.requestItems().equals(this.requestItems())) {
            return false;
        }
        if (other.returnConsumedCapacity() == null ^ this.returnConsumedCapacity() == null) {
            return false;
        }
        if (other.returnConsumedCapacity() != null && !other.returnConsumedCapacity().equals(this.returnConsumedCapacity())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (requestItems() != null) {
            sb.append("RequestItems: ").append(requestItems()).append(",");
        }
        if (returnConsumedCapacity() != null) {
            sb.append("ReturnConsumedCapacity: ").append(returnConsumedCapacity()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, BatchGetItemRequest> {
        /**
         * <p>
         * A map of one or more table names and, for each table, a map that describes one or more items to retrieve from
         * that table. Each table name can be used only once per <code>BatchGetItem</code> request.
         * </p>
         * <p>
         * Each element in the map of items to retrieve consists of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ConsistentRead</code> - If <code>true</code>, a strongly consistent read is used; if <code>false</code>
         * (the default), an eventually consistent read is used.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ExpressionAttributeNames</code> - One or more substitution tokens for attribute names in the
         * <code>ProjectionExpression</code> parameter. The following are some use cases for using
         * <code>ExpressionAttributeNames</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * To access an attribute whose name conflicts with a DynamoDB reserved word.
         * </p>
         * </li>
         * <li>
         * <p>
         * To create a placeholder for repeating occurrences of an attribute name in an expression.
         * </p>
         * </li>
         * <li>
         * <p>
         * To prevent special characters in an attribute name from being misinterpreted in an expression.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Use the <b>#</b> character in an expression to dereference an attribute name. For example, consider the
         * following attribute name:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Percentile</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * The name of this attribute conflicts with a reserved word, so it cannot be used directly in an expression.
         * (For the complete list of reserved words, see <a
         * href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a>
         * in the <i>Amazon DynamoDB Developer Guide</i>). To work around this, you could specify the following for
         * <code>ExpressionAttributeNames</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>{"#P":"Percentile"}</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * You could then use this substitution in an expression, as in this example:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>#P = :val</code>
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * Tokens that begin with the <b>:</b> character are <i>expression attribute values</i>, which are placeholders
         * for the actual value at runtime.
         * </p>
         * </note>
         * <p>
         * For more information on expression attribute names, see <a href=
         * "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html"
         * >Accessing Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Keys</code> - An array of primary key attribute values that define specific items in the table. For
         * each primary key, you must provide <i>all</i> of the key attributes. For example, with a simple primary key,
         * you only need to provide the partition key value. For a composite key, you must provide <i>both</i> the
         * partition key value and the sort key value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ProjectionExpression</code> - A string that identifies one or more attributes to retrieve from the
         * table. These attributes can include scalars, sets, or elements of a JSON document. The attributes in the
         * expression must be separated by commas.
         * </p>
         * <p>
         * If no attribute names are specified, then all attributes will be returned. If any of the requested attributes
         * are not found, they will not appear in the result.
         * </p>
         * <p>
         * For more information, see <a href=
         * "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html"
         * >Accessing Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AttributesToGet</code> - This is a legacy parameter. Use <code>ProjectionExpression</code> instead. For
         * more information, see <a href=
         * "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributesToGet.html"
         * >AttributesToGet</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param requestItems
         *        A map of one or more table names and, for each table, a map that describes one or more items to
         *        retrieve from that table. Each table name can be used only once per <code>BatchGetItem</code>
         *        request.</p>
         *        <p>
         *        Each element in the map of items to retrieve consists of the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ConsistentRead</code> - If <code>true</code>, a strongly consistent read is used; if
         *        <code>false</code> (the default), an eventually consistent read is used.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ExpressionAttributeNames</code> - One or more substitution tokens for attribute names in the
         *        <code>ProjectionExpression</code> parameter. The following are some use cases for using
         *        <code>ExpressionAttributeNames</code>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        To access an attribute whose name conflicts with a DynamoDB reserved word.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        To create a placeholder for repeating occurrences of an attribute name in an expression.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        To prevent special characters in an attribute name from being misinterpreted in an expression.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Use the <b>#</b> character in an expression to dereference an attribute name. For example, consider
         *        the following attribute name:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Percentile</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The name of this attribute conflicts with a reserved word, so it cannot be used directly in an
         *        expression. (For the complete list of reserved words, see <a
         *        href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved
         *        Words</a> in the <i>Amazon DynamoDB Developer Guide</i>). To work around this, you could specify the
         *        following for <code>ExpressionAttributeNames</code>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>{"#P":"Percentile"}</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        You could then use this substitution in an expression, as in this example:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>#P = :val</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        Tokens that begin with the <b>:</b> character are <i>expression attribute values</i>, which are
         *        placeholders for the actual value at runtime.
         *        </p>
         *        </note>
         *        <p>
         *        For more information on expression attribute names, see <a href=
         *        "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html"
         *        >Accessing Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Keys</code> - An array of primary key attribute values that define specific items in the table.
         *        For each primary key, you must provide <i>all</i> of the key attributes. For example, with a simple
         *        primary key, you only need to provide the partition key value. For a composite key, you must provide
         *        <i>both</i> the partition key value and the sort key value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ProjectionExpression</code> - A string that identifies one or more attributes to retrieve from
         *        the table. These attributes can include scalars, sets, or elements of a JSON document. The attributes
         *        in the expression must be separated by commas.
         *        </p>
         *        <p>
         *        If no attribute names are specified, then all attributes will be returned. If any of the requested
         *        attributes are not found, they will not appear in the result.
         *        </p>
         *        <p>
         *        For more information, see <a href=
         *        "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html"
         *        >Accessing Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AttributesToGet</code> - This is a legacy parameter. Use <code>ProjectionExpression</code>
         *        instead. For more information, see <a href=
         *        "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributesToGet.html"
         *        >AttributesToGet</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestItems(Map<String, KeysAndAttributes> requestItems);

        /**
         * Sets the value of the ReturnConsumedCapacity property for this object.
         *
         * @param returnConsumedCapacity
         *        The new value for the ReturnConsumedCapacity property for this object.
         * @see ReturnConsumedCapacity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReturnConsumedCapacity
         */
        Builder returnConsumedCapacity(String returnConsumedCapacity);

        /**
         * Sets the value of the ReturnConsumedCapacity property for this object.
         *
         * @param returnConsumedCapacity
         *        The new value for the ReturnConsumedCapacity property for this object.
         * @see ReturnConsumedCapacity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReturnConsumedCapacity
         */
        Builder returnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity);
    }

    private static final class BuilderImpl implements Builder {
        private Map<String, KeysAndAttributes> requestItems;

        private String returnConsumedCapacity;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetItemRequest model) {
            setRequestItems(model.requestItems);
            setReturnConsumedCapacity(model.returnConsumedCapacity);
        }

        public final Map<String, KeysAndAttributes> getRequestItems() {
            return requestItems;
        }

        @Override
        public final Builder requestItems(Map<String, KeysAndAttributes> requestItems) {
            this.requestItems = BatchGetRequestMapCopier.copy(requestItems);
            return this;
        }

        public final void setRequestItems(Map<String, KeysAndAttributes> requestItems) {
            this.requestItems = BatchGetRequestMapCopier.copy(requestItems);
        }

        public final String getReturnConsumedCapacity() {
            return returnConsumedCapacity;
        }

        @Override
        public final Builder returnConsumedCapacity(String returnConsumedCapacity) {
            this.returnConsumedCapacity = returnConsumedCapacity;
            return this;
        }

        @Override
        public final Builder returnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity) {
            this.returnConsumedCapacity(returnConsumedCapacity.toString());
            return this;
        }

        public final void setReturnConsumedCapacity(String returnConsumedCapacity) {
            this.returnConsumedCapacity = returnConsumedCapacity;
        }

        public final void setReturnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity) {
            this.returnConsumedCapacity(returnConsumedCapacity.toString());
        }

        @Override
        public BatchGetItemRequest build() {
            return new BatchGetItemRequest(this);
        }
    }
}
