/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <code>BatchGetItem</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class BatchGetItemResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<BatchGetItemResponse.Builder, BatchGetItemResponse> {
    private final Map<String, List<Map<String, AttributeValue>>> responses;

    private final Map<String, KeysAndAttributes> unprocessedKeys;

    private final List<ConsumedCapacity> consumedCapacity;

    private BatchGetItemResponse(BuilderImpl builder) {
        this.responses = builder.responses;
        this.unprocessedKeys = builder.unprocessedKeys;
        this.consumedCapacity = builder.consumedCapacity;
    }

    /**
     * <p>
     * A map of table name to a list of items. Each object in <code>Responses</code> consists of a table name, along
     * with a map of attribute data consisting of the data type and attribute value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A map of table name to a list of items. Each object in <code>Responses</code> consists of a table name,
     *         along with a map of attribute data consisting of the data type and attribute value.
     */
    public Map<String, List<Map<String, AttributeValue>>> responses() {
        return responses;
    }

    /**
     * <p>
     * A map of tables and their respective keys that were not processed with the current response. The
     * <code>UnprocessedKeys</code> value is in the same form as <code>RequestItems</code>, so the value can be provided
     * directly to a subsequent <code>BatchGetItem</code> operation. For more information, see <code>RequestItems</code>
     * in the Request Parameters section.
     * </p>
     * <p>
     * Each element consists of:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Keys</code> - An array of primary key attribute values that define specific items in the table.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ProjectionExpression</code> - One or more attributes to be retrieved from the table or index. By default,
     * all attributes are returned. If a requested attribute is not found, it does not appear in the result.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ConsistentRead</code> - The consistency of a read operation. If set to <code>true</code>, then a strongly
     * consistent read is used; otherwise, an eventually consistent read is used.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If there are no unprocessed keys remaining, the response contains an empty <code>UnprocessedKeys</code> map.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A map of tables and their respective keys that were not processed with the current response. The
     *         <code>UnprocessedKeys</code> value is in the same form as <code>RequestItems</code>, so the value can be
     *         provided directly to a subsequent <code>BatchGetItem</code> operation. For more information, see
     *         <code>RequestItems</code> in the Request Parameters section.</p>
     *         <p>
     *         Each element consists of:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Keys</code> - An array of primary key attribute values that define specific items in the table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ProjectionExpression</code> - One or more attributes to be retrieved from the table or index. By
     *         default, all attributes are returned. If a requested attribute is not found, it does not appear in the
     *         result.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ConsistentRead</code> - The consistency of a read operation. If set to <code>true</code>, then a
     *         strongly consistent read is used; otherwise, an eventually consistent read is used.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If there are no unprocessed keys remaining, the response contains an empty <code>UnprocessedKeys</code>
     *         map.
     */
    public Map<String, KeysAndAttributes> unprocessedKeys() {
        return unprocessedKeys;
    }

    /**
     * <p>
     * The read capacity units consumed by the entire <code>BatchGetItem</code> operation.
     * </p>
     * <p>
     * Each element consists of:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>TableName</code> - The table that consumed the provisioned throughput.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CapacityUnits</code> - The total number of capacity units consumed.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The read capacity units consumed by the entire <code>BatchGetItem</code> operation.</p>
     *         <p>
     *         Each element consists of:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>TableName</code> - The table that consumed the provisioned throughput.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CapacityUnits</code> - The total number of capacity units consumed.
     *         </p>
     *         </li>
     */
    public List<ConsumedCapacity> consumedCapacity() {
        return consumedCapacity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((responses() == null) ? 0 : responses().hashCode());
        hashCode = 31 * hashCode + ((unprocessedKeys() == null) ? 0 : unprocessedKeys().hashCode());
        hashCode = 31 * hashCode + ((consumedCapacity() == null) ? 0 : consumedCapacity().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetItemResponse)) {
            return false;
        }
        BatchGetItemResponse other = (BatchGetItemResponse) obj;
        if (other.responses() == null ^ this.responses() == null) {
            return false;
        }
        if (other.responses() != null && !other.responses().equals(this.responses())) {
            return false;
        }
        if (other.unprocessedKeys() == null ^ this.unprocessedKeys() == null) {
            return false;
        }
        if (other.unprocessedKeys() != null && !other.unprocessedKeys().equals(this.unprocessedKeys())) {
            return false;
        }
        if (other.consumedCapacity() == null ^ this.consumedCapacity() == null) {
            return false;
        }
        if (other.consumedCapacity() != null && !other.consumedCapacity().equals(this.consumedCapacity())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (responses() != null) {
            sb.append("Responses: ").append(responses()).append(",");
        }
        if (unprocessedKeys() != null) {
            sb.append("UnprocessedKeys: ").append(unprocessedKeys()).append(",");
        }
        if (consumedCapacity() != null) {
            sb.append("ConsumedCapacity: ").append(consumedCapacity()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, BatchGetItemResponse> {
        /**
         * <p>
         * A map of table name to a list of items. Each object in <code>Responses</code> consists of a table name, along
         * with a map of attribute data consisting of the data type and attribute value.
         * </p>
         * 
         * @param responses
         *        A map of table name to a list of items. Each object in <code>Responses</code> consists of a table
         *        name, along with a map of attribute data consisting of the data type and attribute value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responses(Map<String, ? extends Collection<Map<String, AttributeValue>>> responses);

        /**
         * <p>
         * A map of tables and their respective keys that were not processed with the current response. The
         * <code>UnprocessedKeys</code> value is in the same form as <code>RequestItems</code>, so the value can be
         * provided directly to a subsequent <code>BatchGetItem</code> operation. For more information, see
         * <code>RequestItems</code> in the Request Parameters section.
         * </p>
         * <p>
         * Each element consists of:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Keys</code> - An array of primary key attribute values that define specific items in the table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ProjectionExpression</code> - One or more attributes to be retrieved from the table or index. By
         * default, all attributes are returned. If a requested attribute is not found, it does not appear in the
         * result.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ConsistentRead</code> - The consistency of a read operation. If set to <code>true</code>, then a
         * strongly consistent read is used; otherwise, an eventually consistent read is used.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If there are no unprocessed keys remaining, the response contains an empty <code>UnprocessedKeys</code> map.
         * </p>
         * 
         * @param unprocessedKeys
         *        A map of tables and their respective keys that were not processed with the current response. The
         *        <code>UnprocessedKeys</code> value is in the same form as <code>RequestItems</code>, so the value can
         *        be provided directly to a subsequent <code>BatchGetItem</code> operation. For more information, see
         *        <code>RequestItems</code> in the Request Parameters section.</p>
         *        <p>
         *        Each element consists of:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Keys</code> - An array of primary key attribute values that define specific items in the table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ProjectionExpression</code> - One or more attributes to be retrieved from the table or index. By
         *        default, all attributes are returned. If a requested attribute is not found, it does not appear in the
         *        result.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ConsistentRead</code> - The consistency of a read operation. If set to <code>true</code>, then a
         *        strongly consistent read is used; otherwise, an eventually consistent read is used.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If there are no unprocessed keys remaining, the response contains an empty
         *        <code>UnprocessedKeys</code> map.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unprocessedKeys(Map<String, KeysAndAttributes> unprocessedKeys);

        /**
         * <p>
         * The read capacity units consumed by the entire <code>BatchGetItem</code> operation.
         * </p>
         * <p>
         * Each element consists of:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>TableName</code> - The table that consumed the provisioned throughput.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CapacityUnits</code> - The total number of capacity units consumed.
         * </p>
         * </li>
         * </ul>
         * 
         * @param consumedCapacity
         *        The read capacity units consumed by the entire <code>BatchGetItem</code> operation.</p>
         *        <p>
         *        Each element consists of:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>TableName</code> - The table that consumed the provisioned throughput.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CapacityUnits</code> - The total number of capacity units consumed.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumedCapacity(Collection<ConsumedCapacity> consumedCapacity);

        /**
         * <p>
         * The read capacity units consumed by the entire <code>BatchGetItem</code> operation.
         * </p>
         * <p>
         * Each element consists of:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>TableName</code> - The table that consumed the provisioned throughput.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CapacityUnits</code> - The total number of capacity units consumed.
         * </p>
         * </li>
         * </ul>
         * 
         * @param consumedCapacity
         *        The read capacity units consumed by the entire <code>BatchGetItem</code> operation.</p>
         *        <p>
         *        Each element consists of:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>TableName</code> - The table that consumed the provisioned throughput.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CapacityUnits</code> - The total number of capacity units consumed.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumedCapacity(ConsumedCapacity... consumedCapacity);
    }

    private static final class BuilderImpl implements Builder {
        private Map<String, List<Map<String, AttributeValue>>> responses;

        private Map<String, KeysAndAttributes> unprocessedKeys;

        private List<ConsumedCapacity> consumedCapacity;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetItemResponse model) {
            setResponses(model.responses);
            setUnprocessedKeys(model.unprocessedKeys);
            setConsumedCapacity(model.consumedCapacity);
        }

        public final Map<String, ? extends Collection<Map<String, AttributeValue>>> getResponses() {
            return responses;
        }

        @Override
        public final Builder responses(Map<String, ? extends Collection<Map<String, AttributeValue>>> responses) {
            this.responses = BatchGetResponseMapCopier.copy(responses);
            return this;
        }

        public final void setResponses(Map<String, ? extends Collection<Map<String, AttributeValue>>> responses) {
            this.responses = BatchGetResponseMapCopier.copy(responses);
        }

        public final Map<String, KeysAndAttributes> getUnprocessedKeys() {
            return unprocessedKeys;
        }

        @Override
        public final Builder unprocessedKeys(Map<String, KeysAndAttributes> unprocessedKeys) {
            this.unprocessedKeys = BatchGetRequestMapCopier.copy(unprocessedKeys);
            return this;
        }

        public final void setUnprocessedKeys(Map<String, KeysAndAttributes> unprocessedKeys) {
            this.unprocessedKeys = BatchGetRequestMapCopier.copy(unprocessedKeys);
        }

        public final Collection<ConsumedCapacity> getConsumedCapacity() {
            return consumedCapacity;
        }

        @Override
        public final Builder consumedCapacity(Collection<ConsumedCapacity> consumedCapacity) {
            this.consumedCapacity = ConsumedCapacityMultipleCopier.copy(consumedCapacity);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder consumedCapacity(ConsumedCapacity... consumedCapacity) {
            consumedCapacity(Arrays.asList(consumedCapacity));
            return this;
        }

        public final void setConsumedCapacity(Collection<ConsumedCapacity> consumedCapacity) {
            this.consumedCapacity = ConsumedCapacityMultipleCopier.copy(consumedCapacity);
        }

        @SafeVarargs
        public final void setConsumedCapacity(ConsumedCapacity... consumedCapacity) {
            consumedCapacity(Arrays.asList(consumedCapacity));
        }

        @Override
        public BatchGetItemResponse build() {
            return new BatchGetItemResponse(this);
        }
    }
}
