/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <code>DescribeLimits</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeLimitsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeLimitsResponse.Builder, DescribeLimitsResponse> {
    private final Long accountMaxReadCapacityUnits;

    private final Long accountMaxWriteCapacityUnits;

    private final Long tableMaxReadCapacityUnits;

    private final Long tableMaxWriteCapacityUnits;

    private DescribeLimitsResponse(BuilderImpl builder) {
        this.accountMaxReadCapacityUnits = builder.accountMaxReadCapacityUnits;
        this.accountMaxWriteCapacityUnits = builder.accountMaxWriteCapacityUnits;
        this.tableMaxReadCapacityUnits = builder.tableMaxReadCapacityUnits;
        this.tableMaxWriteCapacityUnits = builder.tableMaxWriteCapacityUnits;
    }

    /**
     * <p>
     * The maximum total read capacity units that your account allows you to provision across all of your tables in this
     * region.
     * </p>
     * 
     * @return The maximum total read capacity units that your account allows you to provision across all of your tables
     *         in this region.
     */
    public Long accountMaxReadCapacityUnits() {
        return accountMaxReadCapacityUnits;
    }

    /**
     * <p>
     * The maximum total write capacity units that your account allows you to provision across all of your tables in
     * this region.
     * </p>
     * 
     * @return The maximum total write capacity units that your account allows you to provision across all of your
     *         tables in this region.
     */
    public Long accountMaxWriteCapacityUnits() {
        return accountMaxWriteCapacityUnits;
    }

    /**
     * <p>
     * The maximum read capacity units that your account allows you to provision for a new table that you are creating
     * in this region, including the read capacity units provisioned for its global secondary indexes (GSIs).
     * </p>
     * 
     * @return The maximum read capacity units that your account allows you to provision for a new table that you are
     *         creating in this region, including the read capacity units provisioned for its global secondary indexes
     *         (GSIs).
     */
    public Long tableMaxReadCapacityUnits() {
        return tableMaxReadCapacityUnits;
    }

    /**
     * <p>
     * The maximum write capacity units that your account allows you to provision for a new table that you are creating
     * in this region, including the write capacity units provisioned for its global secondary indexes (GSIs).
     * </p>
     * 
     * @return The maximum write capacity units that your account allows you to provision for a new table that you are
     *         creating in this region, including the write capacity units provisioned for its global secondary indexes
     *         (GSIs).
     */
    public Long tableMaxWriteCapacityUnits() {
        return tableMaxWriteCapacityUnits;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((accountMaxReadCapacityUnits() == null) ? 0 : accountMaxReadCapacityUnits().hashCode());
        hashCode = 31 * hashCode + ((accountMaxWriteCapacityUnits() == null) ? 0 : accountMaxWriteCapacityUnits().hashCode());
        hashCode = 31 * hashCode + ((tableMaxReadCapacityUnits() == null) ? 0 : tableMaxReadCapacityUnits().hashCode());
        hashCode = 31 * hashCode + ((tableMaxWriteCapacityUnits() == null) ? 0 : tableMaxWriteCapacityUnits().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLimitsResponse)) {
            return false;
        }
        DescribeLimitsResponse other = (DescribeLimitsResponse) obj;
        if (other.accountMaxReadCapacityUnits() == null ^ this.accountMaxReadCapacityUnits() == null) {
            return false;
        }
        if (other.accountMaxReadCapacityUnits() != null
                && !other.accountMaxReadCapacityUnits().equals(this.accountMaxReadCapacityUnits())) {
            return false;
        }
        if (other.accountMaxWriteCapacityUnits() == null ^ this.accountMaxWriteCapacityUnits() == null) {
            return false;
        }
        if (other.accountMaxWriteCapacityUnits() != null
                && !other.accountMaxWriteCapacityUnits().equals(this.accountMaxWriteCapacityUnits())) {
            return false;
        }
        if (other.tableMaxReadCapacityUnits() == null ^ this.tableMaxReadCapacityUnits() == null) {
            return false;
        }
        if (other.tableMaxReadCapacityUnits() != null
                && !other.tableMaxReadCapacityUnits().equals(this.tableMaxReadCapacityUnits())) {
            return false;
        }
        if (other.tableMaxWriteCapacityUnits() == null ^ this.tableMaxWriteCapacityUnits() == null) {
            return false;
        }
        if (other.tableMaxWriteCapacityUnits() != null
                && !other.tableMaxWriteCapacityUnits().equals(this.tableMaxWriteCapacityUnits())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (accountMaxReadCapacityUnits() != null) {
            sb.append("AccountMaxReadCapacityUnits: ").append(accountMaxReadCapacityUnits()).append(",");
        }
        if (accountMaxWriteCapacityUnits() != null) {
            sb.append("AccountMaxWriteCapacityUnits: ").append(accountMaxWriteCapacityUnits()).append(",");
        }
        if (tableMaxReadCapacityUnits() != null) {
            sb.append("TableMaxReadCapacityUnits: ").append(tableMaxReadCapacityUnits()).append(",");
        }
        if (tableMaxWriteCapacityUnits() != null) {
            sb.append("TableMaxWriteCapacityUnits: ").append(tableMaxWriteCapacityUnits()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeLimitsResponse> {
        /**
         * <p>
         * The maximum total read capacity units that your account allows you to provision across all of your tables in
         * this region.
         * </p>
         * 
         * @param accountMaxReadCapacityUnits
         *        The maximum total read capacity units that your account allows you to provision across all of your
         *        tables in this region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountMaxReadCapacityUnits(Long accountMaxReadCapacityUnits);

        /**
         * <p>
         * The maximum total write capacity units that your account allows you to provision across all of your tables in
         * this region.
         * </p>
         * 
         * @param accountMaxWriteCapacityUnits
         *        The maximum total write capacity units that your account allows you to provision across all of your
         *        tables in this region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountMaxWriteCapacityUnits(Long accountMaxWriteCapacityUnits);

        /**
         * <p>
         * The maximum read capacity units that your account allows you to provision for a new table that you are
         * creating in this region, including the read capacity units provisioned for its global secondary indexes
         * (GSIs).
         * </p>
         * 
         * @param tableMaxReadCapacityUnits
         *        The maximum read capacity units that your account allows you to provision for a new table that you are
         *        creating in this region, including the read capacity units provisioned for its global secondary
         *        indexes (GSIs).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableMaxReadCapacityUnits(Long tableMaxReadCapacityUnits);

        /**
         * <p>
         * The maximum write capacity units that your account allows you to provision for a new table that you are
         * creating in this region, including the write capacity units provisioned for its global secondary indexes
         * (GSIs).
         * </p>
         * 
         * @param tableMaxWriteCapacityUnits
         *        The maximum write capacity units that your account allows you to provision for a new table that you
         *        are creating in this region, including the write capacity units provisioned for its global secondary
         *        indexes (GSIs).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableMaxWriteCapacityUnits(Long tableMaxWriteCapacityUnits);
    }

    private static final class BuilderImpl implements Builder {
        private Long accountMaxReadCapacityUnits;

        private Long accountMaxWriteCapacityUnits;

        private Long tableMaxReadCapacityUnits;

        private Long tableMaxWriteCapacityUnits;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLimitsResponse model) {
            setAccountMaxReadCapacityUnits(model.accountMaxReadCapacityUnits);
            setAccountMaxWriteCapacityUnits(model.accountMaxWriteCapacityUnits);
            setTableMaxReadCapacityUnits(model.tableMaxReadCapacityUnits);
            setTableMaxWriteCapacityUnits(model.tableMaxWriteCapacityUnits);
        }

        public final Long getAccountMaxReadCapacityUnits() {
            return accountMaxReadCapacityUnits;
        }

        @Override
        public final Builder accountMaxReadCapacityUnits(Long accountMaxReadCapacityUnits) {
            this.accountMaxReadCapacityUnits = accountMaxReadCapacityUnits;
            return this;
        }

        public final void setAccountMaxReadCapacityUnits(Long accountMaxReadCapacityUnits) {
            this.accountMaxReadCapacityUnits = accountMaxReadCapacityUnits;
        }

        public final Long getAccountMaxWriteCapacityUnits() {
            return accountMaxWriteCapacityUnits;
        }

        @Override
        public final Builder accountMaxWriteCapacityUnits(Long accountMaxWriteCapacityUnits) {
            this.accountMaxWriteCapacityUnits = accountMaxWriteCapacityUnits;
            return this;
        }

        public final void setAccountMaxWriteCapacityUnits(Long accountMaxWriteCapacityUnits) {
            this.accountMaxWriteCapacityUnits = accountMaxWriteCapacityUnits;
        }

        public final Long getTableMaxReadCapacityUnits() {
            return tableMaxReadCapacityUnits;
        }

        @Override
        public final Builder tableMaxReadCapacityUnits(Long tableMaxReadCapacityUnits) {
            this.tableMaxReadCapacityUnits = tableMaxReadCapacityUnits;
            return this;
        }

        public final void setTableMaxReadCapacityUnits(Long tableMaxReadCapacityUnits) {
            this.tableMaxReadCapacityUnits = tableMaxReadCapacityUnits;
        }

        public final Long getTableMaxWriteCapacityUnits() {
            return tableMaxWriteCapacityUnits;
        }

        @Override
        public final Builder tableMaxWriteCapacityUnits(Long tableMaxWriteCapacityUnits) {
            this.tableMaxWriteCapacityUnits = tableMaxWriteCapacityUnits;
            return this;
        }

        public final void setTableMaxWriteCapacityUnits(Long tableMaxWriteCapacityUnits) {
            this.tableMaxWriteCapacityUnits = tableMaxWriteCapacityUnits;
        }

        @Override
        public DescribeLimitsResponse build() {
            return new DescribeLimitsResponse(this);
        }
    }
}
