/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a <code>DescribeStream</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeStreamRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DescribeStreamRequest.Builder, DescribeStreamRequest> {
    private final String streamArn;

    private final Integer limit;

    private final String exclusiveStartShardId;

    private DescribeStreamRequest(BuilderImpl builder) {
        this.streamArn = builder.streamArn;
        this.limit = builder.limit;
        this.exclusiveStartShardId = builder.exclusiveStartShardId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the stream.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the stream.
     */
    public String streamArn() {
        return streamArn;
    }

    /**
     * <p>
     * The maximum number of shard objects to return. The upper limit is 100.
     * </p>
     * 
     * @return The maximum number of shard objects to return. The upper limit is 100.
     */
    public Integer limit() {
        return limit;
    }

    /**
     * <p>
     * The shard ID of the first item that this operation will evaluate. Use the value that was returned for
     * <code>LastEvaluatedShardId</code> in the previous operation.
     * </p>
     * 
     * @return The shard ID of the first item that this operation will evaluate. Use the value that was returned for
     *         <code>LastEvaluatedShardId</code> in the previous operation.
     */
    public String exclusiveStartShardId() {
        return exclusiveStartShardId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((streamArn() == null) ? 0 : streamArn().hashCode());
        hashCode = 31 * hashCode + ((limit() == null) ? 0 : limit().hashCode());
        hashCode = 31 * hashCode + ((exclusiveStartShardId() == null) ? 0 : exclusiveStartShardId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStreamRequest)) {
            return false;
        }
        DescribeStreamRequest other = (DescribeStreamRequest) obj;
        if (other.streamArn() == null ^ this.streamArn() == null) {
            return false;
        }
        if (other.streamArn() != null && !other.streamArn().equals(this.streamArn())) {
            return false;
        }
        if (other.limit() == null ^ this.limit() == null) {
            return false;
        }
        if (other.limit() != null && !other.limit().equals(this.limit())) {
            return false;
        }
        if (other.exclusiveStartShardId() == null ^ this.exclusiveStartShardId() == null) {
            return false;
        }
        if (other.exclusiveStartShardId() != null && !other.exclusiveStartShardId().equals(this.exclusiveStartShardId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (streamArn() != null) {
            sb.append("StreamArn: ").append(streamArn()).append(",");
        }
        if (limit() != null) {
            sb.append("Limit: ").append(limit()).append(",");
        }
        if (exclusiveStartShardId() != null) {
            sb.append("ExclusiveStartShardId: ").append(exclusiveStartShardId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeStreamRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for the stream.
         * </p>
         * 
         * @param streamArn
         *        The Amazon Resource Name (ARN) for the stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamArn(String streamArn);

        /**
         * <p>
         * The maximum number of shard objects to return. The upper limit is 100.
         * </p>
         * 
         * @param limit
         *        The maximum number of shard objects to return. The upper limit is 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        /**
         * <p>
         * The shard ID of the first item that this operation will evaluate. Use the value that was returned for
         * <code>LastEvaluatedShardId</code> in the previous operation.
         * </p>
         * 
         * @param exclusiveStartShardId
         *        The shard ID of the first item that this operation will evaluate. Use the value that was returned for
         *        <code>LastEvaluatedShardId</code> in the previous operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exclusiveStartShardId(String exclusiveStartShardId);
    }

    private static final class BuilderImpl implements Builder {
        private String streamArn;

        private Integer limit;

        private String exclusiveStartShardId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStreamRequest model) {
            setStreamArn(model.streamArn);
            setLimit(model.limit);
            setExclusiveStartShardId(model.exclusiveStartShardId);
        }

        public final String getStreamArn() {
            return streamArn;
        }

        @Override
        public final Builder streamArn(String streamArn) {
            this.streamArn = streamArn;
            return this;
        }

        public final void setStreamArn(String streamArn) {
            this.streamArn = streamArn;
        }

        public final Integer getLimit() {
            return limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getExclusiveStartShardId() {
            return exclusiveStartShardId;
        }

        @Override
        public final Builder exclusiveStartShardId(String exclusiveStartShardId) {
            this.exclusiveStartShardId = exclusiveStartShardId;
            return this;
        }

        public final void setExclusiveStartShardId(String exclusiveStartShardId) {
            this.exclusiveStartShardId = exclusiveStartShardId;
        }

        @Override
        public DescribeStreamRequest build() {
            return new DescribeStreamRequest(this);
        }
    }
}
