/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeTimeToLiveRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DescribeTimeToLiveRequest.Builder, DescribeTimeToLiveRequest> {
    private final String tableName;

    private DescribeTimeToLiveRequest(BuilderImpl builder) {
        this.tableName = builder.tableName;
    }

    /**
     * <p>
     * The name of the table to be described.
     * </p>
     * 
     * @return The name of the table to be described.
     */
    public String tableName() {
        return tableName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((tableName() == null) ? 0 : tableName().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTimeToLiveRequest)) {
            return false;
        }
        DescribeTimeToLiveRequest other = (DescribeTimeToLiveRequest) obj;
        if (other.tableName() == null ^ this.tableName() == null) {
            return false;
        }
        if (other.tableName() != null && !other.tableName().equals(this.tableName())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (tableName() != null) {
            sb.append("TableName: ").append(tableName()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeTimeToLiveRequest> {
        /**
         * <p>
         * The name of the table to be described.
         * </p>
         * 
         * @param tableName
         *        The name of the table to be described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);
    }

    private static final class BuilderImpl implements Builder {
        private String tableName;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTimeToLiveRequest model) {
            setTableName(model.tableName);
        }

        public final String getTableName() {
            return tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public DescribeTimeToLiveRequest build() {
            return new DescribeTimeToLiveRequest(this);
        }
    }
}
