/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.transform.IdentityMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about the type of identity that made the request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Identity implements StructuredPojo, ToCopyableBuilder<Identity.Builder, Identity> {
    private final String principalId;

    private final String type;

    private Identity(BuilderImpl builder) {
        this.principalId = builder.principalId;
        this.type = builder.type;
    }

    /**
     * <p>
     * A unique identifier for the entity that made the call. For Time To Live, the principalId is
     * "dynamodb.amazonaws.com".
     * </p>
     * 
     * @return A unique identifier for the entity that made the call. For Time To Live, the principalId is
     *         "dynamodb.amazonaws.com".
     */
    public String principalId() {
        return principalId;
    }

    /**
     * <p>
     * The type of the identity. For Time To Live, the type is "Service".
     * </p>
     * 
     * @return The type of the identity. For Time To Live, the type is "Service".
     */
    public String type() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((principalId() == null) ? 0 : principalId().hashCode());
        hashCode = 31 * hashCode + ((type() == null) ? 0 : type().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Identity)) {
            return false;
        }
        Identity other = (Identity) obj;
        if (other.principalId() == null ^ this.principalId() == null) {
            return false;
        }
        if (other.principalId() != null && !other.principalId().equals(this.principalId())) {
            return false;
        }
        if (other.type() == null ^ this.type() == null) {
            return false;
        }
        if (other.type() != null && !other.type().equals(this.type())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (principalId() != null) {
            sb.append("PrincipalId: ").append(principalId()).append(",");
        }
        if (type() != null) {
            sb.append("Type: ").append(type()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        IdentityMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Identity> {
        /**
         * <p>
         * A unique identifier for the entity that made the call. For Time To Live, the principalId is
         * "dynamodb.amazonaws.com".
         * </p>
         * 
         * @param principalId
         *        A unique identifier for the entity that made the call. For Time To Live, the principalId is
         *        "dynamodb.amazonaws.com".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principalId(String principalId);

        /**
         * <p>
         * The type of the identity. For Time To Live, the type is "Service".
         * </p>
         * 
         * @param type
         *        The type of the identity. For Time To Live, the type is "Service".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);
    }

    private static final class BuilderImpl implements Builder {
        private String principalId;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(Identity model) {
            setPrincipalId(model.principalId);
            setType(model.type);
        }

        public final String getPrincipalId() {
            return principalId;
        }

        @Override
        public final Builder principalId(String principalId) {
            this.principalId = principalId;
            return this;
        }

        public final void setPrincipalId(String principalId) {
            this.principalId = principalId;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public Identity build() {
            return new Identity(this);
        }
    }
}
