/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.transform.ShardMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A uniquely identified group of stream records within a stream.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Shard implements StructuredPojo, ToCopyableBuilder<Shard.Builder, Shard> {
    private final String shardId;

    private final SequenceNumberRange sequenceNumberRange;

    private final String parentShardId;

    private Shard(BuilderImpl builder) {
        this.shardId = builder.shardId;
        this.sequenceNumberRange = builder.sequenceNumberRange;
        this.parentShardId = builder.parentShardId;
    }

    /**
     * <p>
     * The system-generated identifier for this shard.
     * </p>
     * 
     * @return The system-generated identifier for this shard.
     */
    public String shardId() {
        return shardId;
    }

    /**
     * <p>
     * The range of possible sequence numbers for the shard.
     * </p>
     * 
     * @return The range of possible sequence numbers for the shard.
     */
    public SequenceNumberRange sequenceNumberRange() {
        return sequenceNumberRange;
    }

    /**
     * <p>
     * The shard ID of the current shard's parent.
     * </p>
     * 
     * @return The shard ID of the current shard's parent.
     */
    public String parentShardId() {
        return parentShardId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((shardId() == null) ? 0 : shardId().hashCode());
        hashCode = 31 * hashCode + ((sequenceNumberRange() == null) ? 0 : sequenceNumberRange().hashCode());
        hashCode = 31 * hashCode + ((parentShardId() == null) ? 0 : parentShardId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Shard)) {
            return false;
        }
        Shard other = (Shard) obj;
        if (other.shardId() == null ^ this.shardId() == null) {
            return false;
        }
        if (other.shardId() != null && !other.shardId().equals(this.shardId())) {
            return false;
        }
        if (other.sequenceNumberRange() == null ^ this.sequenceNumberRange() == null) {
            return false;
        }
        if (other.sequenceNumberRange() != null && !other.sequenceNumberRange().equals(this.sequenceNumberRange())) {
            return false;
        }
        if (other.parentShardId() == null ^ this.parentShardId() == null) {
            return false;
        }
        if (other.parentShardId() != null && !other.parentShardId().equals(this.parentShardId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (shardId() != null) {
            sb.append("ShardId: ").append(shardId()).append(",");
        }
        if (sequenceNumberRange() != null) {
            sb.append("SequenceNumberRange: ").append(sequenceNumberRange()).append(",");
        }
        if (parentShardId() != null) {
            sb.append("ParentShardId: ").append(parentShardId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ShardMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Shard> {
        /**
         * <p>
         * The system-generated identifier for this shard.
         * </p>
         * 
         * @param shardId
         *        The system-generated identifier for this shard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shardId(String shardId);

        /**
         * <p>
         * The range of possible sequence numbers for the shard.
         * </p>
         * 
         * @param sequenceNumberRange
         *        The range of possible sequence numbers for the shard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sequenceNumberRange(SequenceNumberRange sequenceNumberRange);

        /**
         * <p>
         * The shard ID of the current shard's parent.
         * </p>
         * 
         * @param parentShardId
         *        The shard ID of the current shard's parent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentShardId(String parentShardId);
    }

    private static final class BuilderImpl implements Builder {
        private String shardId;

        private SequenceNumberRange sequenceNumberRange;

        private String parentShardId;

        private BuilderImpl() {
        }

        private BuilderImpl(Shard model) {
            setShardId(model.shardId);
            setSequenceNumberRange(model.sequenceNumberRange);
            setParentShardId(model.parentShardId);
        }

        public final String getShardId() {
            return shardId;
        }

        @Override
        public final Builder shardId(String shardId) {
            this.shardId = shardId;
            return this;
        }

        public final void setShardId(String shardId) {
            this.shardId = shardId;
        }

        public final SequenceNumberRange getSequenceNumberRange() {
            return sequenceNumberRange;
        }

        @Override
        public final Builder sequenceNumberRange(SequenceNumberRange sequenceNumberRange) {
            this.sequenceNumberRange = sequenceNumberRange;
            return this;
        }

        public final void setSequenceNumberRange(SequenceNumberRange sequenceNumberRange) {
            this.sequenceNumberRange = sequenceNumberRange;
        }

        public final String getParentShardId() {
            return parentShardId;
        }

        @Override
        public final Builder parentShardId(String parentShardId) {
            this.parentShardId = parentShardId;
            return this;
        }

        public final void setParentShardId(String parentShardId) {
            this.parentShardId = parentShardId;
        }

        @Override
        public Shard build() {
            return new Shard(this);
        }
    }
}
