/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.time.Instant;
import java.util.Map;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.transform.StreamRecordMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A description of a single data modification that was performed on an item in a DynamoDB table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class StreamRecord implements StructuredPojo, ToCopyableBuilder<StreamRecord.Builder, StreamRecord> {
    private final Instant approximateCreationDateTime;

    private final Map<String, AttributeValue> keys;

    private final Map<String, AttributeValue> newImage;

    private final Map<String, AttributeValue> oldImage;

    private final String sequenceNumber;

    private final Long sizeBytes;

    private final String streamViewType;

    private StreamRecord(BuilderImpl builder) {
        this.approximateCreationDateTime = builder.approximateCreationDateTime;
        this.keys = builder.keys;
        this.newImage = builder.newImage;
        this.oldImage = builder.oldImage;
        this.sequenceNumber = builder.sequenceNumber;
        this.sizeBytes = builder.sizeBytes;
        this.streamViewType = builder.streamViewType;
    }

    /**
     * <p>
     * The approximate date and time when the stream record was created, in <a
     * href="http://www.epochconverter.com/">UNIX epoch time</a> format.
     * </p>
     * 
     * @return The approximate date and time when the stream record was created, in <a
     *         href="http://www.epochconverter.com/">UNIX epoch time</a> format.
     */
    public Instant approximateCreationDateTime() {
        return approximateCreationDateTime;
    }

    /**
     * <p>
     * The primary key attribute(s) for the DynamoDB item that was modified.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The primary key attribute(s) for the DynamoDB item that was modified.
     */
    public Map<String, AttributeValue> keys() {
        return keys;
    }

    /**
     * <p>
     * The item in the DynamoDB table as it appeared after it was modified.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The item in the DynamoDB table as it appeared after it was modified.
     */
    public Map<String, AttributeValue> newImage() {
        return newImage;
    }

    /**
     * <p>
     * The item in the DynamoDB table as it appeared before it was modified.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The item in the DynamoDB table as it appeared before it was modified.
     */
    public Map<String, AttributeValue> oldImage() {
        return oldImage;
    }

    /**
     * <p>
     * The sequence number of the stream record.
     * </p>
     * 
     * @return The sequence number of the stream record.
     */
    public String sequenceNumber() {
        return sequenceNumber;
    }

    /**
     * <p>
     * The size of the stream record, in bytes.
     * </p>
     * 
     * @return The size of the stream record, in bytes.
     */
    public Long sizeBytes() {
        return sizeBytes;
    }

    /**
     * <p>
     * The type of data from the modified DynamoDB item that was captured in this stream record:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>KEYS_ONLY</code> - only the key attributes of the modified item.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NEW_IMAGE</code> - the entire item, as it appeared after it was modified.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OLD_IMAGE</code> - the entire item, as it appeared before it was modified.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NEW_AND_OLD_IMAGES</code> - both the new and the old item images of the item.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The type of data from the modified DynamoDB item that was captured in this stream record:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>KEYS_ONLY</code> - only the key attributes of the modified item.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NEW_IMAGE</code> - the entire item, as it appeared after it was modified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OLD_IMAGE</code> - the entire item, as it appeared before it was modified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NEW_AND_OLD_IMAGES</code> - both the new and the old item images of the item.
     *         </p>
     *         </li>
     * @see StreamViewType
     */
    public String streamViewType() {
        return streamViewType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((approximateCreationDateTime() == null) ? 0 : approximateCreationDateTime().hashCode());
        hashCode = 31 * hashCode + ((keys() == null) ? 0 : keys().hashCode());
        hashCode = 31 * hashCode + ((newImage() == null) ? 0 : newImage().hashCode());
        hashCode = 31 * hashCode + ((oldImage() == null) ? 0 : oldImage().hashCode());
        hashCode = 31 * hashCode + ((sequenceNumber() == null) ? 0 : sequenceNumber().hashCode());
        hashCode = 31 * hashCode + ((sizeBytes() == null) ? 0 : sizeBytes().hashCode());
        hashCode = 31 * hashCode + ((streamViewType() == null) ? 0 : streamViewType().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamRecord)) {
            return false;
        }
        StreamRecord other = (StreamRecord) obj;
        if (other.approximateCreationDateTime() == null ^ this.approximateCreationDateTime() == null) {
            return false;
        }
        if (other.approximateCreationDateTime() != null
                && !other.approximateCreationDateTime().equals(this.approximateCreationDateTime())) {
            return false;
        }
        if (other.keys() == null ^ this.keys() == null) {
            return false;
        }
        if (other.keys() != null && !other.keys().equals(this.keys())) {
            return false;
        }
        if (other.newImage() == null ^ this.newImage() == null) {
            return false;
        }
        if (other.newImage() != null && !other.newImage().equals(this.newImage())) {
            return false;
        }
        if (other.oldImage() == null ^ this.oldImage() == null) {
            return false;
        }
        if (other.oldImage() != null && !other.oldImage().equals(this.oldImage())) {
            return false;
        }
        if (other.sequenceNumber() == null ^ this.sequenceNumber() == null) {
            return false;
        }
        if (other.sequenceNumber() != null && !other.sequenceNumber().equals(this.sequenceNumber())) {
            return false;
        }
        if (other.sizeBytes() == null ^ this.sizeBytes() == null) {
            return false;
        }
        if (other.sizeBytes() != null && !other.sizeBytes().equals(this.sizeBytes())) {
            return false;
        }
        if (other.streamViewType() == null ^ this.streamViewType() == null) {
            return false;
        }
        if (other.streamViewType() != null && !other.streamViewType().equals(this.streamViewType())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (approximateCreationDateTime() != null) {
            sb.append("ApproximateCreationDateTime: ").append(approximateCreationDateTime()).append(",");
        }
        if (keys() != null) {
            sb.append("Keys: ").append(keys()).append(",");
        }
        if (newImage() != null) {
            sb.append("NewImage: ").append(newImage()).append(",");
        }
        if (oldImage() != null) {
            sb.append("OldImage: ").append(oldImage()).append(",");
        }
        if (sequenceNumber() != null) {
            sb.append("SequenceNumber: ").append(sequenceNumber()).append(",");
        }
        if (sizeBytes() != null) {
            sb.append("SizeBytes: ").append(sizeBytes()).append(",");
        }
        if (streamViewType() != null) {
            sb.append("StreamViewType: ").append(streamViewType()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StreamRecordMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, StreamRecord> {
        /**
         * <p>
         * The approximate date and time when the stream record was created, in <a
         * href="http://www.epochconverter.com/">UNIX epoch time</a> format.
         * </p>
         * 
         * @param approximateCreationDateTime
         *        The approximate date and time when the stream record was created, in <a
         *        href="http://www.epochconverter.com/">UNIX epoch time</a> format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approximateCreationDateTime(Instant approximateCreationDateTime);

        /**
         * <p>
         * The primary key attribute(s) for the DynamoDB item that was modified.
         * </p>
         * 
         * @param keys
         *        The primary key attribute(s) for the DynamoDB item that was modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keys(Map<String, AttributeValue> keys);

        /**
         * <p>
         * The item in the DynamoDB table as it appeared after it was modified.
         * </p>
         * 
         * @param newImage
         *        The item in the DynamoDB table as it appeared after it was modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newImage(Map<String, AttributeValue> newImage);

        /**
         * <p>
         * The item in the DynamoDB table as it appeared before it was modified.
         * </p>
         * 
         * @param oldImage
         *        The item in the DynamoDB table as it appeared before it was modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oldImage(Map<String, AttributeValue> oldImage);

        /**
         * <p>
         * The sequence number of the stream record.
         * </p>
         * 
         * @param sequenceNumber
         *        The sequence number of the stream record.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sequenceNumber(String sequenceNumber);

        /**
         * <p>
         * The size of the stream record, in bytes.
         * </p>
         * 
         * @param sizeBytes
         *        The size of the stream record, in bytes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sizeBytes(Long sizeBytes);

        /**
         * <p>
         * The type of data from the modified DynamoDB item that was captured in this stream record:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>KEYS_ONLY</code> - only the key attributes of the modified item.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NEW_IMAGE</code> - the entire item, as it appeared after it was modified.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OLD_IMAGE</code> - the entire item, as it appeared before it was modified.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NEW_AND_OLD_IMAGES</code> - both the new and the old item images of the item.
         * </p>
         * </li>
         * </ul>
         * 
         * @param streamViewType
         *        The type of data from the modified DynamoDB item that was captured in this stream record:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>KEYS_ONLY</code> - only the key attributes of the modified item.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NEW_IMAGE</code> - the entire item, as it appeared after it was modified.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OLD_IMAGE</code> - the entire item, as it appeared before it was modified.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NEW_AND_OLD_IMAGES</code> - both the new and the old item images of the item.
         *        </p>
         *        </li>
         * @see StreamViewType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StreamViewType
         */
        Builder streamViewType(String streamViewType);

        /**
         * <p>
         * The type of data from the modified DynamoDB item that was captured in this stream record:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>KEYS_ONLY</code> - only the key attributes of the modified item.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NEW_IMAGE</code> - the entire item, as it appeared after it was modified.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OLD_IMAGE</code> - the entire item, as it appeared before it was modified.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NEW_AND_OLD_IMAGES</code> - both the new and the old item images of the item.
         * </p>
         * </li>
         * </ul>
         * 
         * @param streamViewType
         *        The type of data from the modified DynamoDB item that was captured in this stream record:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>KEYS_ONLY</code> - only the key attributes of the modified item.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NEW_IMAGE</code> - the entire item, as it appeared after it was modified.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OLD_IMAGE</code> - the entire item, as it appeared before it was modified.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NEW_AND_OLD_IMAGES</code> - both the new and the old item images of the item.
         *        </p>
         *        </li>
         * @see StreamViewType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StreamViewType
         */
        Builder streamViewType(StreamViewType streamViewType);
    }

    private static final class BuilderImpl implements Builder {
        private Instant approximateCreationDateTime;

        private Map<String, AttributeValue> keys;

        private Map<String, AttributeValue> newImage;

        private Map<String, AttributeValue> oldImage;

        private String sequenceNumber;

        private Long sizeBytes;

        private String streamViewType;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamRecord model) {
            setApproximateCreationDateTime(model.approximateCreationDateTime);
            setKeys(model.keys);
            setNewImage(model.newImage);
            setOldImage(model.oldImage);
            setSequenceNumber(model.sequenceNumber);
            setSizeBytes(model.sizeBytes);
            setStreamViewType(model.streamViewType);
        }

        public final Instant getApproximateCreationDateTime() {
            return approximateCreationDateTime;
        }

        @Override
        public final Builder approximateCreationDateTime(Instant approximateCreationDateTime) {
            this.approximateCreationDateTime = approximateCreationDateTime;
            return this;
        }

        public final void setApproximateCreationDateTime(Instant approximateCreationDateTime) {
            this.approximateCreationDateTime = approximateCreationDateTime;
        }

        public final Map<String, AttributeValue> getKeys() {
            return keys;
        }

        @Override
        public final Builder keys(Map<String, AttributeValue> keys) {
            this.keys = AttributeMapCopier.copy(keys);
            return this;
        }

        public final void setKeys(Map<String, AttributeValue> keys) {
            this.keys = AttributeMapCopier.copy(keys);
        }

        public final Map<String, AttributeValue> getNewImage() {
            return newImage;
        }

        @Override
        public final Builder newImage(Map<String, AttributeValue> newImage) {
            this.newImage = AttributeMapCopier.copy(newImage);
            return this;
        }

        public final void setNewImage(Map<String, AttributeValue> newImage) {
            this.newImage = AttributeMapCopier.copy(newImage);
        }

        public final Map<String, AttributeValue> getOldImage() {
            return oldImage;
        }

        @Override
        public final Builder oldImage(Map<String, AttributeValue> oldImage) {
            this.oldImage = AttributeMapCopier.copy(oldImage);
            return this;
        }

        public final void setOldImage(Map<String, AttributeValue> oldImage) {
            this.oldImage = AttributeMapCopier.copy(oldImage);
        }

        public final String getSequenceNumber() {
            return sequenceNumber;
        }

        @Override
        public final Builder sequenceNumber(String sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
            return this;
        }

        public final void setSequenceNumber(String sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
        }

        public final Long getSizeBytes() {
            return sizeBytes;
        }

        @Override
        public final Builder sizeBytes(Long sizeBytes) {
            this.sizeBytes = sizeBytes;
            return this;
        }

        public final void setSizeBytes(Long sizeBytes) {
            this.sizeBytes = sizeBytes;
        }

        public final String getStreamViewType() {
            return streamViewType;
        }

        @Override
        public final Builder streamViewType(String streamViewType) {
            this.streamViewType = streamViewType;
            return this;
        }

        @Override
        public final Builder streamViewType(StreamViewType streamViewType) {
            this.streamViewType(streamViewType.toString());
            return this;
        }

        public final void setStreamViewType(String streamViewType) {
            this.streamViewType = streamViewType;
        }

        public final void setStreamViewType(StreamViewType streamViewType) {
            this.streamViewType(streamViewType.toString());
        }

        @Override
        public StreamRecord build() {
            return new StreamRecord(this);
        }
    }
}
