/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.transform.TimeToLiveDescriptionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The description of the Time to Live (TTL) status on the specified table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class TimeToLiveDescription implements StructuredPojo,
        ToCopyableBuilder<TimeToLiveDescription.Builder, TimeToLiveDescription> {
    private final String timeToLiveStatus;

    private final String attributeName;

    private TimeToLiveDescription(BuilderImpl builder) {
        this.timeToLiveStatus = builder.timeToLiveStatus;
        this.attributeName = builder.attributeName;
    }

    /**
     * <p>
     * The Time to Live status for the table.
     * </p>
     * 
     * @return The Time to Live status for the table.
     * @see TimeToLiveStatus
     */
    public String timeToLiveStatus() {
        return timeToLiveStatus;
    }

    /**
     * <p>
     * The name of the Time to Live attribute for items in the table.
     * </p>
     * 
     * @return The name of the Time to Live attribute for items in the table.
     */
    public String attributeName() {
        return attributeName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((timeToLiveStatus() == null) ? 0 : timeToLiveStatus().hashCode());
        hashCode = 31 * hashCode + ((attributeName() == null) ? 0 : attributeName().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeToLiveDescription)) {
            return false;
        }
        TimeToLiveDescription other = (TimeToLiveDescription) obj;
        if (other.timeToLiveStatus() == null ^ this.timeToLiveStatus() == null) {
            return false;
        }
        if (other.timeToLiveStatus() != null && !other.timeToLiveStatus().equals(this.timeToLiveStatus())) {
            return false;
        }
        if (other.attributeName() == null ^ this.attributeName() == null) {
            return false;
        }
        if (other.attributeName() != null && !other.attributeName().equals(this.attributeName())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (timeToLiveStatus() != null) {
            sb.append("TimeToLiveStatus: ").append(timeToLiveStatus()).append(",");
        }
        if (attributeName() != null) {
            sb.append("AttributeName: ").append(attributeName()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TimeToLiveDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, TimeToLiveDescription> {
        /**
         * <p>
         * The Time to Live status for the table.
         * </p>
         * 
         * @param timeToLiveStatus
         *        The Time to Live status for the table.
         * @see TimeToLiveStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TimeToLiveStatus
         */
        Builder timeToLiveStatus(String timeToLiveStatus);

        /**
         * <p>
         * The Time to Live status for the table.
         * </p>
         * 
         * @param timeToLiveStatus
         *        The Time to Live status for the table.
         * @see TimeToLiveStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TimeToLiveStatus
         */
        Builder timeToLiveStatus(TimeToLiveStatus timeToLiveStatus);

        /**
         * <p>
         * The name of the Time to Live attribute for items in the table.
         * </p>
         * 
         * @param attributeName
         *        The name of the Time to Live attribute for items in the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeName(String attributeName);
    }

    private static final class BuilderImpl implements Builder {
        private String timeToLiveStatus;

        private String attributeName;

        private BuilderImpl() {
        }

        private BuilderImpl(TimeToLiveDescription model) {
            setTimeToLiveStatus(model.timeToLiveStatus);
            setAttributeName(model.attributeName);
        }

        public final String getTimeToLiveStatus() {
            return timeToLiveStatus;
        }

        @Override
        public final Builder timeToLiveStatus(String timeToLiveStatus) {
            this.timeToLiveStatus = timeToLiveStatus;
            return this;
        }

        @Override
        public final Builder timeToLiveStatus(TimeToLiveStatus timeToLiveStatus) {
            this.timeToLiveStatus(timeToLiveStatus.toString());
            return this;
        }

        public final void setTimeToLiveStatus(String timeToLiveStatus) {
            this.timeToLiveStatus = timeToLiveStatus;
        }

        public final void setTimeToLiveStatus(TimeToLiveStatus timeToLiveStatus) {
            this.timeToLiveStatus(timeToLiveStatus.toString());
        }

        public final String getAttributeName() {
            return attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        @Override
        public TimeToLiveDescription build() {
            return new TimeToLiveDescription(this);
        }
    }
}
