/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.transform.UpdateGlobalSecondaryIndexActionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the new provisioned throughput settings to be applied to a global secondary index.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateGlobalSecondaryIndexAction implements StructuredPojo,
        ToCopyableBuilder<UpdateGlobalSecondaryIndexAction.Builder, UpdateGlobalSecondaryIndexAction> {
    private final String indexName;

    private final ProvisionedThroughput provisionedThroughput;

    private UpdateGlobalSecondaryIndexAction(BuilderImpl builder) {
        this.indexName = builder.indexName;
        this.provisionedThroughput = builder.provisionedThroughput;
    }

    /**
     * <p>
     * The name of the global secondary index to be updated.
     * </p>
     * 
     * @return The name of the global secondary index to be updated.
     */
    public String indexName() {
        return indexName;
    }

    /**
     * <p>
     * Represents the provisioned throughput settings for the specified global secondary index.
     * </p>
     * <p>
     * For current minimum and maximum provisioned throughput values, see <a
     * href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Limits</a> in the <i>Amazon
     * DynamoDB Developer Guide</i>.
     * </p>
     * 
     * @return Represents the provisioned throughput settings for the specified global secondary index.</p>
     *         <p>
     *         For current minimum and maximum provisioned throughput values, see <a
     *         href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Limits</a> in the
     *         <i>Amazon DynamoDB Developer Guide</i>.
     */
    public ProvisionedThroughput provisionedThroughput() {
        return provisionedThroughput;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((indexName() == null) ? 0 : indexName().hashCode());
        hashCode = 31 * hashCode + ((provisionedThroughput() == null) ? 0 : provisionedThroughput().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateGlobalSecondaryIndexAction)) {
            return false;
        }
        UpdateGlobalSecondaryIndexAction other = (UpdateGlobalSecondaryIndexAction) obj;
        if (other.indexName() == null ^ this.indexName() == null) {
            return false;
        }
        if (other.indexName() != null && !other.indexName().equals(this.indexName())) {
            return false;
        }
        if (other.provisionedThroughput() == null ^ this.provisionedThroughput() == null) {
            return false;
        }
        if (other.provisionedThroughput() != null && !other.provisionedThroughput().equals(this.provisionedThroughput())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (indexName() != null) {
            sb.append("IndexName: ").append(indexName()).append(",");
        }
        if (provisionedThroughput() != null) {
            sb.append("ProvisionedThroughput: ").append(provisionedThroughput()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        UpdateGlobalSecondaryIndexActionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, UpdateGlobalSecondaryIndexAction> {
        /**
         * <p>
         * The name of the global secondary index to be updated.
         * </p>
         * 
         * @param indexName
         *        The name of the global secondary index to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexName(String indexName);

        /**
         * <p>
         * Represents the provisioned throughput settings for the specified global secondary index.
         * </p>
         * <p>
         * For current minimum and maximum provisioned throughput values, see <a
         * href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Limits</a> in the
         * <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param provisionedThroughput
         *        Represents the provisioned throughput settings for the specified global secondary index.</p>
         *        <p>
         *        For current minimum and maximum provisioned throughput values, see <a
         *        href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Limits</a> in the
         *        <i>Amazon DynamoDB Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedThroughput(ProvisionedThroughput provisionedThroughput);
    }

    private static final class BuilderImpl implements Builder {
        private String indexName;

        private ProvisionedThroughput provisionedThroughput;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateGlobalSecondaryIndexAction model) {
            setIndexName(model.indexName);
            setProvisionedThroughput(model.provisionedThroughput);
        }

        public final String getIndexName() {
            return indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        public final ProvisionedThroughput getProvisionedThroughput() {
            return provisionedThroughput;
        }

        @Override
        public final Builder provisionedThroughput(ProvisionedThroughput provisionedThroughput) {
            this.provisionedThroughput = provisionedThroughput;
            return this;
        }

        public final void setProvisionedThroughput(ProvisionedThroughput provisionedThroughput) {
            this.provisionedThroughput = provisionedThroughput;
        }

        @Override
        public UpdateGlobalSecondaryIndexAction build() {
            return new UpdateGlobalSecondaryIndexAction(this);
        }
    }
}
