/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Map;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of an <code>UpdateItem</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateItemResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<UpdateItemResponse.Builder, UpdateItemResponse> {
    private final Map<String, AttributeValue> attributes;

    private final ConsumedCapacity consumedCapacity;

    private final ItemCollectionMetrics itemCollectionMetrics;

    private UpdateItemResponse(BuilderImpl builder) {
        this.attributes = builder.attributes;
        this.consumedCapacity = builder.consumedCapacity;
        this.itemCollectionMetrics = builder.itemCollectionMetrics;
    }

    /**
     * <p>
     * A map of attribute values as they appeared before the <code>UpdateItem</code> operation. This map only appears if
     * <code>ReturnValues</code> was specified as something other than <code>NONE</code> in the request. Each element
     * represents one attribute.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A map of attribute values as they appeared before the <code>UpdateItem</code> operation. This map only
     *         appears if <code>ReturnValues</code> was specified as something other than <code>NONE</code> in the
     *         request. Each element represents one attribute.
     */
    public Map<String, AttributeValue> attributes() {
        return attributes;
    }

    /**
     * <p>
     * The capacity units consumed by the <code>UpdateItem</code> operation. The data returned includes the total
     * provisioned throughput consumed, along with statistics for the table and any indexes involved in the operation.
     * <code>ConsumedCapacity</code> is only returned if the <code>ReturnConsumedCapacity</code> parameter was
     * specified. For more information, see <a
     * href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html"
     * >Provisioned Throughput</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * 
     * @return The capacity units consumed by the <code>UpdateItem</code> operation. The data returned includes the
     *         total provisioned throughput consumed, along with statistics for the table and any indexes involved in
     *         the operation. <code>ConsumedCapacity</code> is only returned if the <code>ReturnConsumedCapacity</code>
     *         parameter was specified. For more information, see <a
     *         href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html"
     *         >Provisioned Throughput</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     */
    public ConsumedCapacity consumedCapacity() {
        return consumedCapacity;
    }

    /**
     * <p>
     * Information about item collections, if any, that were affected by the <code>UpdateItem</code> operation.
     * <code>ItemCollectionMetrics</code> is only returned if the <code>ReturnItemCollectionMetrics</code> parameter was
     * specified. If the table does not have any local secondary indexes, this information is not returned in the
     * response.
     * </p>
     * <p>
     * Each <code>ItemCollectionMetrics</code> element consists of:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ItemCollectionKey</code> - The partition key value of the item collection. This is the same as the
     * partition key value of the item itself.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SizeEstimateRange</code> - An estimate of item collection size, in gigabytes. This value is a two-element
     * array containing a lower bound and an upper bound for the estimate. The estimate includes the size of all the
     * items in the table, plus the size of all attributes projected into all of the local secondary indexes on that
     * table. Use this estimate to measure whether a local secondary index is approaching its size limit.
     * </p>
     * <p>
     * The estimate is subject to change over time; therefore, do not rely on the precision or accuracy of the estimate.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Information about item collections, if any, that were affected by the <code>UpdateItem</code> operation.
     *         <code>ItemCollectionMetrics</code> is only returned if the <code>ReturnItemCollectionMetrics</code>
     *         parameter was specified. If the table does not have any local secondary indexes, this information is not
     *         returned in the response.</p>
     *         <p>
     *         Each <code>ItemCollectionMetrics</code> element consists of:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ItemCollectionKey</code> - The partition key value of the item collection. This is the same as the
     *         partition key value of the item itself.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SizeEstimateRange</code> - An estimate of item collection size, in gigabytes. This value is a
     *         two-element array containing a lower bound and an upper bound for the estimate. The estimate includes the
     *         size of all the items in the table, plus the size of all attributes projected into all of the local
     *         secondary indexes on that table. Use this estimate to measure whether a local secondary index is
     *         approaching its size limit.
     *         </p>
     *         <p>
     *         The estimate is subject to change over time; therefore, do not rely on the precision or accuracy of the
     *         estimate.
     *         </p>
     *         </li>
     */
    public ItemCollectionMetrics itemCollectionMetrics() {
        return itemCollectionMetrics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((attributes() == null) ? 0 : attributes().hashCode());
        hashCode = 31 * hashCode + ((consumedCapacity() == null) ? 0 : consumedCapacity().hashCode());
        hashCode = 31 * hashCode + ((itemCollectionMetrics() == null) ? 0 : itemCollectionMetrics().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateItemResponse)) {
            return false;
        }
        UpdateItemResponse other = (UpdateItemResponse) obj;
        if (other.attributes() == null ^ this.attributes() == null) {
            return false;
        }
        if (other.attributes() != null && !other.attributes().equals(this.attributes())) {
            return false;
        }
        if (other.consumedCapacity() == null ^ this.consumedCapacity() == null) {
            return false;
        }
        if (other.consumedCapacity() != null && !other.consumedCapacity().equals(this.consumedCapacity())) {
            return false;
        }
        if (other.itemCollectionMetrics() == null ^ this.itemCollectionMetrics() == null) {
            return false;
        }
        if (other.itemCollectionMetrics() != null && !other.itemCollectionMetrics().equals(this.itemCollectionMetrics())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (attributes() != null) {
            sb.append("Attributes: ").append(attributes()).append(",");
        }
        if (consumedCapacity() != null) {
            sb.append("ConsumedCapacity: ").append(consumedCapacity()).append(",");
        }
        if (itemCollectionMetrics() != null) {
            sb.append("ItemCollectionMetrics: ").append(itemCollectionMetrics()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, UpdateItemResponse> {
        /**
         * <p>
         * A map of attribute values as they appeared before the <code>UpdateItem</code> operation. This map only
         * appears if <code>ReturnValues</code> was specified as something other than <code>NONE</code> in the request.
         * Each element represents one attribute.
         * </p>
         * 
         * @param attributes
         *        A map of attribute values as they appeared before the <code>UpdateItem</code> operation. This map only
         *        appears if <code>ReturnValues</code> was specified as something other than <code>NONE</code> in the
         *        request. Each element represents one attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<String, AttributeValue> attributes);

        /**
         * <p>
         * The capacity units consumed by the <code>UpdateItem</code> operation. The data returned includes the total
         * provisioned throughput consumed, along with statistics for the table and any indexes involved in the
         * operation. <code>ConsumedCapacity</code> is only returned if the <code>ReturnConsumedCapacity</code>
         * parameter was specified. For more information, see <a
         * href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html"
         * >Provisioned Throughput</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param consumedCapacity
         *        The capacity units consumed by the <code>UpdateItem</code> operation. The data returned includes the
         *        total provisioned throughput consumed, along with statistics for the table and any indexes involved in
         *        the operation. <code>ConsumedCapacity</code> is only returned if the
         *        <code>ReturnConsumedCapacity</code> parameter was specified. For more information, see <a
         *        href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html"
         *        >Provisioned Throughput</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumedCapacity(ConsumedCapacity consumedCapacity);

        /**
         * <p>
         * Information about item collections, if any, that were affected by the <code>UpdateItem</code> operation.
         * <code>ItemCollectionMetrics</code> is only returned if the <code>ReturnItemCollectionMetrics</code> parameter
         * was specified. If the table does not have any local secondary indexes, this information is not returned in
         * the response.
         * </p>
         * <p>
         * Each <code>ItemCollectionMetrics</code> element consists of:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ItemCollectionKey</code> - The partition key value of the item collection. This is the same as the
         * partition key value of the item itself.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SizeEstimateRange</code> - An estimate of item collection size, in gigabytes. This value is a
         * two-element array containing a lower bound and an upper bound for the estimate. The estimate includes the
         * size of all the items in the table, plus the size of all attributes projected into all of the local secondary
         * indexes on that table. Use this estimate to measure whether a local secondary index is approaching its size
         * limit.
         * </p>
         * <p>
         * The estimate is subject to change over time; therefore, do not rely on the precision or accuracy of the
         * estimate.
         * </p>
         * </li>
         * </ul>
         * 
         * @param itemCollectionMetrics
         *        Information about item collections, if any, that were affected by the <code>UpdateItem</code>
         *        operation. <code>ItemCollectionMetrics</code> is only returned if the
         *        <code>ReturnItemCollectionMetrics</code> parameter was specified. If the table does not have any local
         *        secondary indexes, this information is not returned in the response.</p>
         *        <p>
         *        Each <code>ItemCollectionMetrics</code> element consists of:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ItemCollectionKey</code> - The partition key value of the item collection. This is the same as
         *        the partition key value of the item itself.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SizeEstimateRange</code> - An estimate of item collection size, in gigabytes. This value is a
         *        two-element array containing a lower bound and an upper bound for the estimate. The estimate includes
         *        the size of all the items in the table, plus the size of all attributes projected into all of the
         *        local secondary indexes on that table. Use this estimate to measure whether a local secondary index is
         *        approaching its size limit.
         *        </p>
         *        <p>
         *        The estimate is subject to change over time; therefore, do not rely on the precision or accuracy of
         *        the estimate.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder itemCollectionMetrics(ItemCollectionMetrics itemCollectionMetrics);
    }

    private static final class BuilderImpl implements Builder {
        private Map<String, AttributeValue> attributes;

        private ConsumedCapacity consumedCapacity;

        private ItemCollectionMetrics itemCollectionMetrics;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateItemResponse model) {
            setAttributes(model.attributes);
            setConsumedCapacity(model.consumedCapacity);
            setItemCollectionMetrics(model.itemCollectionMetrics);
        }

        public final Map<String, AttributeValue> getAttributes() {
            return attributes;
        }

        @Override
        public final Builder attributes(Map<String, AttributeValue> attributes) {
            this.attributes = AttributeMapCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, AttributeValue> attributes) {
            this.attributes = AttributeMapCopier.copy(attributes);
        }

        public final ConsumedCapacity getConsumedCapacity() {
            return consumedCapacity;
        }

        @Override
        public final Builder consumedCapacity(ConsumedCapacity consumedCapacity) {
            this.consumedCapacity = consumedCapacity;
            return this;
        }

        public final void setConsumedCapacity(ConsumedCapacity consumedCapacity) {
            this.consumedCapacity = consumedCapacity;
        }

        public final ItemCollectionMetrics getItemCollectionMetrics() {
            return itemCollectionMetrics;
        }

        @Override
        public final Builder itemCollectionMetrics(ItemCollectionMetrics itemCollectionMetrics) {
            this.itemCollectionMetrics = itemCollectionMetrics;
            return this;
        }

        public final void setItemCollectionMetrics(ItemCollectionMetrics itemCollectionMetrics) {
            this.itemCollectionMetrics = itemCollectionMetrics;
        }

        @Override
        public UpdateItemResponse build() {
            return new UpdateItemResponse(this);
        }
    }
}
