/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of an <code>UpdateTimeToLive</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateTimeToLiveRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<UpdateTimeToLiveRequest.Builder, UpdateTimeToLiveRequest> {
    private final String tableName;

    private final TimeToLiveSpecification timeToLiveSpecification;

    private UpdateTimeToLiveRequest(BuilderImpl builder) {
        this.tableName = builder.tableName;
        this.timeToLiveSpecification = builder.timeToLiveSpecification;
    }

    /**
     * <p>
     * The name of the table to be configured.
     * </p>
     * 
     * @return The name of the table to be configured.
     */
    public String tableName() {
        return tableName;
    }

    /**
     * <p>
     * Represents the settings used to enable or disable Time to Live for the specified table.
     * </p>
     * 
     * @return Represents the settings used to enable or disable Time to Live for the specified table.
     */
    public TimeToLiveSpecification timeToLiveSpecification() {
        return timeToLiveSpecification;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((tableName() == null) ? 0 : tableName().hashCode());
        hashCode = 31 * hashCode + ((timeToLiveSpecification() == null) ? 0 : timeToLiveSpecification().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTimeToLiveRequest)) {
            return false;
        }
        UpdateTimeToLiveRequest other = (UpdateTimeToLiveRequest) obj;
        if (other.tableName() == null ^ this.tableName() == null) {
            return false;
        }
        if (other.tableName() != null && !other.tableName().equals(this.tableName())) {
            return false;
        }
        if (other.timeToLiveSpecification() == null ^ this.timeToLiveSpecification() == null) {
            return false;
        }
        if (other.timeToLiveSpecification() != null && !other.timeToLiveSpecification().equals(this.timeToLiveSpecification())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (tableName() != null) {
            sb.append("TableName: ").append(tableName()).append(",");
        }
        if (timeToLiveSpecification() != null) {
            sb.append("TimeToLiveSpecification: ").append(timeToLiveSpecification()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, UpdateTimeToLiveRequest> {
        /**
         * <p>
         * The name of the table to be configured.
         * </p>
         * 
         * @param tableName
         *        The name of the table to be configured.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * Represents the settings used to enable or disable Time to Live for the specified table.
         * </p>
         * 
         * @param timeToLiveSpecification
         *        Represents the settings used to enable or disable Time to Live for the specified table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeToLiveSpecification(TimeToLiveSpecification timeToLiveSpecification);
    }

    private static final class BuilderImpl implements Builder {
        private String tableName;

        private TimeToLiveSpecification timeToLiveSpecification;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTimeToLiveRequest model) {
            setTableName(model.tableName);
            setTimeToLiveSpecification(model.timeToLiveSpecification);
        }

        public final String getTableName() {
            return tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final TimeToLiveSpecification getTimeToLiveSpecification() {
            return timeToLiveSpecification;
        }

        @Override
        public final Builder timeToLiveSpecification(TimeToLiveSpecification timeToLiveSpecification) {
            this.timeToLiveSpecification = timeToLiveSpecification;
            return this;
        }

        public final void setTimeToLiveSpecification(TimeToLiveSpecification timeToLiveSpecification) {
            this.timeToLiveSpecification = timeToLiveSpecification;
        }

        @Override
        public UpdateTimeToLiveRequest build() {
            return new UpdateTimeToLiveRequest(this);
        }
    }
}
