/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.transform.WriteRequestMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents an operation to perform - either <code>DeleteItem</code> or <code>PutItem</code>. You can only request one
 * of these operations, not both, in a single <code>WriteRequest</code>. If you do need to perform both of these
 * operations, you will need to provide two separate <code>WriteRequest</code> objects.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class WriteRequest implements StructuredPojo, ToCopyableBuilder<WriteRequest.Builder, WriteRequest> {
    private final PutRequest putRequest;

    private final DeleteRequest deleteRequest;

    private WriteRequest(BuilderImpl builder) {
        this.putRequest = builder.putRequest;
        this.deleteRequest = builder.deleteRequest;
    }

    /**
     * <p>
     * A request to perform a <code>PutItem</code> operation.
     * </p>
     * 
     * @return A request to perform a <code>PutItem</code> operation.
     */
    public PutRequest putRequest() {
        return putRequest;
    }

    /**
     * <p>
     * A request to perform a <code>DeleteItem</code> operation.
     * </p>
     * 
     * @return A request to perform a <code>DeleteItem</code> operation.
     */
    public DeleteRequest deleteRequest() {
        return deleteRequest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((putRequest() == null) ? 0 : putRequest().hashCode());
        hashCode = 31 * hashCode + ((deleteRequest() == null) ? 0 : deleteRequest().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WriteRequest)) {
            return false;
        }
        WriteRequest other = (WriteRequest) obj;
        if (other.putRequest() == null ^ this.putRequest() == null) {
            return false;
        }
        if (other.putRequest() != null && !other.putRequest().equals(this.putRequest())) {
            return false;
        }
        if (other.deleteRequest() == null ^ this.deleteRequest() == null) {
            return false;
        }
        if (other.deleteRequest() != null && !other.deleteRequest().equals(this.deleteRequest())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (putRequest() != null) {
            sb.append("PutRequest: ").append(putRequest()).append(",");
        }
        if (deleteRequest() != null) {
            sb.append("DeleteRequest: ").append(deleteRequest()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        WriteRequestMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, WriteRequest> {
        /**
         * <p>
         * A request to perform a <code>PutItem</code> operation.
         * </p>
         * 
         * @param putRequest
         *        A request to perform a <code>PutItem</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder putRequest(PutRequest putRequest);

        /**
         * <p>
         * A request to perform a <code>DeleteItem</code> operation.
         * </p>
         * 
         * @param deleteRequest
         *        A request to perform a <code>DeleteItem</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteRequest(DeleteRequest deleteRequest);
    }

    private static final class BuilderImpl implements Builder {
        private PutRequest putRequest;

        private DeleteRequest deleteRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(WriteRequest model) {
            setPutRequest(model.putRequest);
            setDeleteRequest(model.deleteRequest);
        }

        public final PutRequest getPutRequest() {
            return putRequest;
        }

        @Override
        public final Builder putRequest(PutRequest putRequest) {
            this.putRequest = putRequest;
            return this;
        }

        public final void setPutRequest(PutRequest putRequest) {
            this.putRequest = putRequest;
        }

        public final DeleteRequest getDeleteRequest() {
            return deleteRequest;
        }

        @Override
        public final Builder deleteRequest(DeleteRequest deleteRequest) {
            this.deleteRequest = deleteRequest;
            return this;
        }

        public final void setDeleteRequest(DeleteRequest deleteRequest) {
            this.deleteRequest = deleteRequest;
        }

        @Override
        public WriteRequest build() {
            return new WriteRequest(this);
        }
    }
}
