/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.datamodeling;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.UUID;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDb;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbAutoGenerateStrategy;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbAutoGenerated;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbAutoGenerator;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbTypeConverter;
import software.amazon.awssdk.services.dynamodb.datamodeling.StandardTypeConverters;

@DynamoDb
@DynamoDbAutoGenerated(generator=Generator.class)
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.FIELD, ElementType.METHOD, ElementType.ANNOTATION_TYPE})
public @interface DynamoDbGeneratedUuid {
    public DynamoDbAutoGenerateStrategy value();

    public static final class Generator<T>
    extends DynamoDbAutoGenerator.AbstractGenerator<T> {
        private final DynamoDbTypeConverter<T, UUID> converter;

        Generator(Class<T> targetType, DynamoDbGeneratedUuid annotation) {
            super(annotation.value());
            this.converter = StandardTypeConverters.factory().getConverter(targetType, UUID.class);
        }

        @Override
        public T generate(T currentValue) {
            return this.converter.convert(UUID.randomUUID());
        }
    }
}

