/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.datamodeling;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import software.amazon.awssdk.annotation.GuardedBy;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbAttribute;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbAutoGeneratedKey;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbDocument;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbHashKey;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbIgnore;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbIndexHashKey;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbIndexRangeKey;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbMappingException;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbRangeKey;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbTable;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbVersionAttribute;
import software.amazon.awssdk.services.dynamodb.datamodeling.ReflectionUtils;

@Deprecated
@SdkInternalApi
class DynamoDbReflector {
    private final Map<Class<?>, Collection<Method>> getterCache = new HashMap();
    private final Map<Class<?>, Method> primaryHashKeyGetterCache = new HashMap();
    private final Map<Class<?>, Method> primaryRangeKeyGetterCache = new HashMap();
    private final Map<Class<?>, List<Method>> primaryKeyGettersCache = new HashMap();
    private final Map<Method, Method> setterCache = new HashMap<Method, Method>();
    @GuardedBy(value="readWriteLockAttrName")
    private final Map<Method, String> attributeNameCache = new HashMap<Method, String>();
    private final Map<Method, Boolean> versionAttributeGetterCache = new HashMap<Method, Boolean>();
    private final Map<Method, Boolean> autoGeneratedKeyGetterCache = new HashMap<Method, Boolean>();
    private final ReentrantReadWriteLock readWriteLockAttrName = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock readLockAttrName = this.readWriteLockAttrName.readLock();
    private final ReentrantReadWriteLock.WriteLock writeLockAttrName = this.readWriteLockAttrName.writeLock();

    DynamoDbReflector() {
    }

    static List<Method> findRelevantGetters(Class<?> clazz) {
        LinkedList<Method> relevantGetters = new LinkedList<Method>();
        for (Method m : clazz.getMethods()) {
            if (!DynamoDbReflector.isRelevantGetter(m)) continue;
            relevantGetters.add(m);
        }
        return relevantGetters;
    }

    private static boolean isRelevantGetter(Method m) {
        return (m.getName().startsWith("get") || m.getName().startsWith("is")) && m.getParameterTypes().length == 0 && !m.isBridge() && !m.isSynthetic() && DynamoDbReflector.isDocumentType(m.getDeclaringClass()) && !ReflectionUtils.getterOrFieldHasAnnotation(m, DynamoDbIgnore.class);
    }

    private static boolean isDocumentType(Class<?> clazz) {
        return clazz.getAnnotation(DynamoDbTable.class) != null || clazz.getAnnotation(DynamoDbDocument.class) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<Method> getRelevantGetters(Class<?> clazz) {
        Map<Class<?>, Collection<Method>> map = this.getterCache;
        synchronized (map) {
            if (!this.getterCache.containsKey(clazz)) {
                List<Method> relevantGetters = DynamoDbReflector.findRelevantGetters(clazz);
                this.getterCache.put(clazz, relevantGetters);
            }
            return this.getterCache.get(clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> Method getPrimaryRangeKeyGetter(Class<T> clazz) {
        Map<Class<?>, Method> map = this.primaryRangeKeyGetterCache;
        synchronized (map) {
            if (!this.primaryRangeKeyGetterCache.containsKey(clazz)) {
                Method rangeKeyMethod = null;
                for (Method method : this.getRelevantGetters(clazz)) {
                    if (method.getParameterTypes().length != 0 || !ReflectionUtils.getterOrFieldHasAnnotation(method, DynamoDbRangeKey.class)) continue;
                    rangeKeyMethod = method;
                    break;
                }
                this.primaryRangeKeyGetterCache.put(clazz, rangeKeyMethod);
            }
            return this.primaryRangeKeyGetterCache.get(clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> Collection<Method> getPrimaryKeyGetters(Class<T> clazz) {
        Map<Class<?>, List<Method>> map = this.primaryKeyGettersCache;
        synchronized (map) {
            if (!this.primaryKeyGettersCache.containsKey(clazz)) {
                LinkedList<Method> keyGetters = new LinkedList<Method>();
                for (Method getter : this.getRelevantGetters(clazz)) {
                    if (!ReflectionUtils.getterOrFieldHasAnnotation(getter, DynamoDbHashKey.class) && !ReflectionUtils.getterOrFieldHasAnnotation(getter, DynamoDbRangeKey.class)) continue;
                    keyGetters.add(getter);
                }
                this.primaryKeyGettersCache.put(clazz, keyGetters);
            }
            return this.primaryKeyGettersCache.get(clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> Method getPrimaryHashKeyGetter(Class<T> clazz) {
        Method hashKeyMethod;
        Map<Class<?>, Method> map = this.primaryHashKeyGetterCache;
        synchronized (map) {
            if (!this.primaryHashKeyGetterCache.containsKey(clazz)) {
                for (Method method : this.getRelevantGetters(clazz)) {
                    if (method.getParameterTypes().length != 0 || !ReflectionUtils.getterOrFieldHasAnnotation(method, DynamoDbHashKey.class)) continue;
                    this.primaryHashKeyGetterCache.put(clazz, method);
                    break;
                }
            }
            hashKeyMethod = this.primaryHashKeyGetterCache.get(clazz);
        }
        if (hashKeyMethod == null) {
            throw new DynamoDbMappingException("Public, zero-parameter hash key property must be annotated with " + DynamoDbHashKey.class);
        }
        return hashKeyMethod;
    }

    <T> DynamoDbTable getTable(Class<T> clazz) {
        DynamoDbTable table = clazz.getAnnotation(DynamoDbTable.class);
        if (table == null) {
            throw new DynamoDbMappingException("Class " + clazz + " must be annotated with " + DynamoDbTable.class);
        }
        return table;
    }

    String getAttributeName(Method getter) {
        String attributeName;
        this.readLockAttrName.lock();
        try {
            attributeName = this.attributeNameCache.get(getter);
        }
        finally {
            this.readLockAttrName.unlock();
        }
        if (attributeName != null) {
            return attributeName;
        }
        DynamoDbHashKey hashKeyAnnotation = ReflectionUtils.getAnnotationFromGetterOrField(getter, DynamoDbHashKey.class);
        if (hashKeyAnnotation != null && (attributeName = hashKeyAnnotation.attributeName()) != null && attributeName.length() > 0) {
            return this.cacheAttributeName(getter, attributeName);
        }
        DynamoDbIndexHashKey indexHashKey = ReflectionUtils.getAnnotationFromGetterOrField(getter, DynamoDbIndexHashKey.class);
        if (indexHashKey != null && (attributeName = indexHashKey.attributeName()) != null && attributeName.length() > 0) {
            return this.cacheAttributeName(getter, attributeName);
        }
        DynamoDbRangeKey rangeKey = ReflectionUtils.getAnnotationFromGetterOrField(getter, DynamoDbRangeKey.class);
        if (rangeKey != null && (attributeName = rangeKey.attributeName()) != null && attributeName.length() > 0) {
            return this.cacheAttributeName(getter, attributeName);
        }
        DynamoDbIndexRangeKey indexRangeKey = ReflectionUtils.getAnnotationFromGetterOrField(getter, DynamoDbIndexRangeKey.class);
        if (indexRangeKey != null && (attributeName = indexRangeKey.attributeName()) != null && attributeName.length() > 0) {
            return this.cacheAttributeName(getter, attributeName);
        }
        DynamoDbAttribute attribute = ReflectionUtils.getAnnotationFromGetterOrField(getter, DynamoDbAttribute.class);
        if (attribute != null && (attributeName = attribute.attributeName()) != null && attributeName.length() > 0) {
            return this.cacheAttributeName(getter, attributeName);
        }
        DynamoDbVersionAttribute version = ReflectionUtils.getAnnotationFromGetterOrField(getter, DynamoDbVersionAttribute.class);
        if (version != null && (attributeName = version.attributeName()) != null && attributeName.length() > 0) {
            return this.cacheAttributeName(getter, attributeName);
        }
        attributeName = ReflectionUtils.getFieldNameByGetter(getter, true);
        return this.cacheAttributeName(getter, attributeName);
    }

    private String cacheAttributeName(Method getter, String attributeName) {
        this.writeLockAttrName.lock();
        try {
            this.attributeNameCache.put(getter, attributeName);
        }
        finally {
            this.writeLockAttrName.unlock();
        }
        return attributeName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Method setter(Method getter) {
        Map<Method, Method> map = this.setterCache;
        synchronized (map) {
            if (!this.setterCache.containsKey(getter)) {
                String fieldName = ReflectionUtils.getFieldNameByGetter(getter, false);
                String setterName = "set" + fieldName;
                Method setter = null;
                try {
                    setter = getter.getDeclaringClass().getMethod(setterName, getter.getReturnType());
                }
                catch (NoSuchMethodException e) {
                    throw new DynamoDbMappingException("Expected a public, one-argument method called " + setterName + " on " + getter.getDeclaringClass(), e);
                }
                catch (SecurityException e) {
                    throw new DynamoDbMappingException("No access to public, one-argument method called " + setterName + " on " + getter.getDeclaringClass(), e);
                }
                this.setterCache.put(getter, setter);
            }
            return this.setterCache.get(getter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isVersionAttributeGetter(Method getter) {
        Map<Method, Boolean> map = this.versionAttributeGetterCache;
        synchronized (map) {
            if (!this.versionAttributeGetterCache.containsKey(getter)) {
                this.versionAttributeGetterCache.put(getter, getter.getName().startsWith("get") && getter.getParameterTypes().length == 0 && ReflectionUtils.getterOrFieldHasAnnotation(getter, DynamoDbVersionAttribute.class));
            }
            return this.versionAttributeGetterCache.get(getter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isAssignableKey(Method getter) {
        Map<Method, Boolean> map = this.autoGeneratedKeyGetterCache;
        synchronized (map) {
            if (!this.autoGeneratedKeyGetterCache.containsKey(getter)) {
                this.autoGeneratedKeyGetterCache.put(getter, ReflectionUtils.getterOrFieldHasAnnotation(getter, DynamoDbAutoGeneratedKey.class) && (ReflectionUtils.getterOrFieldHasAnnotation(getter, DynamoDbHashKey.class) || ReflectionUtils.getterOrFieldHasAnnotation(getter, DynamoDbRangeKey.class) || ReflectionUtils.getterOrFieldHasAnnotation(getter, DynamoDbIndexHashKey.class) || ReflectionUtils.getterOrFieldHasAnnotation(getter, DynamoDbIndexRangeKey.class)));
            }
            return this.autoGeneratedKeyGetterCache.get(getter);
        }
    }

    String getPrimaryHashKeyName(Class<?> clazz) {
        return this.getAttributeName(this.getPrimaryHashKeyGetter(clazz));
    }

    String getPrimaryRangeKeyName(Class<?> clazz) {
        return this.getAttributeName(this.getPrimaryRangeKeyGetter(clazz));
    }

    boolean hasPrimaryRangeKey(Class<?> clazz) {
        return this.getPrimaryRangeKeyGetter(clazz) != null;
    }
}

