/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.datamodeling.marshallers;

import java.util.ArrayList;
import java.util.Set;
import software.amazon.awssdk.services.dynamodb.datamodeling.ArgumentMarshaller;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

public class BooleanSetToNumberSetMarshaller
implements ArgumentMarshaller.NumberSetAttributeMarshaller {
    private static final BooleanSetToNumberSetMarshaller INSTANCE = new BooleanSetToNumberSetMarshaller();

    private BooleanSetToNumberSetMarshaller() {
    }

    public static BooleanSetToNumberSetMarshaller instance() {
        return INSTANCE;
    }

    @Override
    public AttributeValue marshall(Object obj) {
        Set booleans = (Set)obj;
        ArrayList<String> booleanAttributes = new ArrayList<String>(booleans.size());
        for (Boolean b : booleans) {
            if (b == null || !b.booleanValue()) {
                booleanAttributes.add("0");
                continue;
            }
            booleanAttributes.add("1");
        }
        return (AttributeValue)AttributeValue.builder().ns(booleanAttributes).build();
    }
}

